hex2asc	proc

;requires:
;		dx = binary number 
;		di = address of ASCII string
;uses:
;		ax - for character conversion
;		cx - loop control
;returns:
;		nothing

	push	cx	;save cx
	push	ax	;save ax
	mov	cx,4	;number of hex digits
h1:	push	cx	;save cx inside this loop
	mov	cl,4	;shift count (bits/hex digit)
	rol	dx,cl	;rotate left 1 hex digit
	mov	al,dl	;move hex digit to al
	and	al,0fh	;mask off desired hex digit
	cmp	al,0ah	;is it above 9h?
	jge	h2	;yes
	add	al,30h	;numeric hex digit
	jmp	h3	;skip
h2:	add	al,37h	;alpha hex digit
h3:	mov	cs:[di],al	;store hex digit in string
	inc	di	;next string address
	pop	cx	;get saved loop count
	loop	h1	;loop start
	pop	ax	;restore ax
	pop	cx	;restore cx
	ret		;return to caller	
hex2asc	endp

