title UP - move up 1 directory level
page 60,132

;++++++++++++++++++++++++++++++
; Abstract:
;    This routine will move the
; user up one directory level. It
; will yield an error message as
; to it's success. The dos errorlevel
; parameter is used for exit. It is
; set to:
; 0 - if the up was successful
; 1 - if the user was at the top of
;     the tree when up was executed.
; 2 - If there was an error in the
;     program.
;------------------------------

; +++
; Author:
;	Jeffrey Spidle
;	Office of Continuing Education
;	Ames,Ia 50011
;	(515)294-6222
;
; Date:
;	11 JAN 84
;
; System:
;	IBM-PC executing PC-DOS 2.0 or
;			 MS-DOS 2.0
; Release:
;	1.1
; ---
;*****************************************
; Instructions:
;   To assemble link and go:
;  Masm up;
;  Link up;
;  Exe2bin up.exe up.com
;  UP
;
; This program is placed in the public domain and
; is not intended for any type of commercial sale.
; Free use and copying of this program is allowed
; provided that no fee is charged for its distribution.
;******************************************
cgroup group code_seg, data_seg
	assume cs:cgroup,ds:cgroup

data_seg	segment 	public
hello		db	'Up ok.$'
cant_go_up	db	'Can',39,'t go up.$'
error		db	'Up Error.$'
start_path	db	'\'
path_name	db	64 dup (0)
data_seg ends

code_seg segment
	org 100h
main	proc	near
	mov	si,offset cgroup:path_name ;address of where to put the
					; current path_name
	mov	dl,0			; default drive request
	mov	ah,47H			; get current path
	int	21H			; call dos to get it
	jnc	ok1			; call ok ?
	jmp	oops			; nope
ok1:	mov	bx,offset cgroup:path_name ; get the begining of the
					; path into bx
	cmp	byte ptr [bx],0 	; if first char of path is a
					; null then we must be at the
					; top of the tree ==> we can't
					; go up from here
	je	cant			; therefore put out a message
	add	bx,64			; get the end of the path area
loop:	cmp	byte ptr [bx],92	; is this a \ char
	je	backslash		; it is
	mov	byte ptr [bx],0 	; no then null it
	dec	bx			; back up a char
	cmp	bx,offset cgroup:path_name ; begining of string?
	jne	loop			; nope go back up
backslash:				; it is or found a \
	mov	byte ptr [bx],0 	; get rid of the backslash
	mov	dx,offset cgroup:start_path
					; have dx point to the new
					; pathname prefaced with a \
	mov	ah,3bH			; chdir call
	int	21H			; call dos to do it
	jnc	ok2			; call ok?
	jmp	oops			; nope
ok2:	mov	dx,offset cgroup:hello
	mov	ah,9
	int	21H
	mov	ax,4c00H		; set errorcode 00
	int	21H

oops:	mov	dx,offset cgroup:error
	mov	ah,9
	int	21H
	mov	ax,4c02H		; set errorcode 02
	int	21H

cant:	mov	dx,offset cgroup:cant_go_up
	mov	ah,9
	int	21H
	mov	ax,4c01H		; set errorcode 01
	int	21H

main	endp
code_seg ends
	end	main
