; add1.asm - adds signed and unsigned words and bytes

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
STACKSEG    SEGMENT   STACK  'STACK'

             dw     100h  dup (?)

STACKSEG    ENDS
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DATASTUFF    SEGMENT   PUBLIC  'DATA'

       ; 1 = signed, 2 = unsigned, 3 = binary
       ; 4 = hex, 5 = ascii 
       ; 90h = signed, A0h = unsigned, B0h = binary
       ; C0h = hex, D0h = ascii 

ax_byte      db  2
bx_byte      db  2
cx_byte      db  2
dx_byte      db  2
si_byte      db  2
di_byte      db  2
bp_byte      db  2
sp_byte      db  2

; + + + + + + + + + + + + + + + START DATA BELOW THIS LINE

; + + + + + + + + + + + + + + + END DATA ABOVE THIS LINE

DATASTUFF    ENDS
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
CODESTUFF    SEGMENT   PUBLIC  'CODE'

       ; **************  ASMHELP.OBJ  INFO

       EXTRN  show_regs:NEAR , show_regs_and_wait:NEAR
       EXTRN  set_reg_style:NEAR , set_count:NEAR
       EXTRN  set_blue:NEAR , get_continue:NEAR
       
       EXTRN  get_num:NEAR ,            print_num:NEAR 
       EXTRN  get_string:NEAR ,         print_string:NEAR
       EXTRN  get_ascii_byte:NEAR  ,    print_ascii_byte:NEAR
       EXTRN  get_ascii:NEAR  ,         print_ascii:NEAR
       EXTRN  get_hex_byte:NEAR ,       print_hex_byte:NEAR
       EXTRN  get_hex:NEAR ,            print_hex:NEAR 
       EXTRN  get_binary_byte:NEAR ,    print_binary_byte:NEAR
       EXTRN  get_binary:NEAR ,         print_binary:NEAR
       EXTRN  get_bcd:NEAR   ,          print_bcd:NEAR
       
       EXTRN  get_signed_byte:NEAR ,    print_signed_byte:NEAR
       EXTRN  get_unsigned_byte:NEAR ,  print_unsigned_byte:NEAR
       EXTRN  get_signed:NEAR ,         print_signed:NEAR
       EXTRN  get_unsigned:NEAR ,       print_unsigned:NEAR 
       EXTRN  get_signed_4byte:NEAR ,   print_signed_4byte:NEAR
       EXTRN  get_unsigned_4byte:NEAR , print_unsigned_4byte:NEAR
       EXTRN  get_signed_8byte:NEAR ,   print_signed_8byte:NEAR
       EXTRN  get_unsigned_8byte:NEAR , print_unsigned_8byte:NEAR

       ; **************  END ASMHELP.OBJ  INFO
          
       ASSUME cs:CODESTUFF, ds:DATASTUFF

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

main   proc far

start: push  ds               ; set up for return
       sub   ax,ax
       push  ax

       mov   ax, DATASTUFF    ; load ds
       mov   ds,ax

; + + + + + + + + + + + + + + + START CODE BELOW THIS LINE

       mov   si, 0               ; clear unused registers
       mov   di, 0
       mov   bp, 0
       call  show_regs

outer_loop:

       ; UNSIGNED WORD ADDITION
       mov   ax_byte, 2          ; ax, bx, dx unsigned
       mov   bx_byte, 2
       mov   dx_byte, 2
       lea   ax, ax_byte         ; call set_reg_style
       call  set_reg_style

       mov   cx, 3               ; 3 iterations
unsigned_loop:
       mov   ax, 0               ; clear the registers for visibility
       mov   bx, 0
       mov   dx, 0
       call  show_regs
       call  get_unsigned        ; first number to  ax
       call  show_regs
       push  ax                  ; temporarily save ax
       call  get_unsigned        ; second number to bx
       mov   bx, ax
       pop   ax                  ; get ax back
       mov   dx, ax              ; copy of ax to dx
       add   dx, bx              ; dx (=ax) + bx
       call  show_regs_and_wait
       loop  unsigned_loop

       ; UNSIGNED BYTE ADDITION
       mov   ax_byte, 0A2h       ; ax, bx, dx unsigned half regs
       mov   bx_byte, 0A2h
       mov   dx_byte, 0A2h
       lea   ax, ax_byte         ; call set_reg_style
       call  set_reg_style

       mov   cx, 3               ; 3 iterations
unsigned_byte_loop:
       mov   ax, 0               ; clear the registers for visibility
       mov   bx, 0
       mov   dx, 0
       call  show_regs
       call  get_unsigned_byte   ; first number to  al
       call  show_regs
       push  ax                  ; temporarily save ax
       call  get_unsigned_byte   ; second number to bl
       mov   bl, al
       pop   ax                  ; get ax back
       mov   dl, al              ; copy of al to dl
       add   dl, bl              ; dl (=al) + bl
       call  show_regs_and_wait
       loop  unsigned_byte_loop

       ; SIGNED WORD ADDITION
       mov   ax_byte, 1          ; ax, bx, dx signed
       mov   bx_byte, 1
       mov   dx_byte, 1
       lea   ax, ax_byte         ; call set_reg_style
       call  set_reg_style

       mov   cx, 3               ; 3 iterations
signed_loop:
       mov   ax, 0               ; clear the registers for visibility
       mov   bx, 0
       mov   dx, 0
       call  show_regs
       call  get_signed          ; first number to  ax
       call  show_regs
       push  ax                  ; temporarily save ax
       call  get_signed          ; second number to bx
       mov   bx, ax
       pop   ax                  ; get ax back
       mov   dx, ax              ; copy of ax to dx
       add   dx, bx              ; dx (=ax) + bx
       call  show_regs_and_wait
       loop  signed_loop

       ; SIGNED BYTE ADDITION
       mov   ax_byte, 91h        ; ax, bx, dx signed half regs
       mov   bx_byte, 91h
       mov   dx_byte, 91h
       lea   ax, ax_byte         ; call set_reg_style
       call  set_reg_style

       mov   cx, 3               ; 3 iterations
signed_byte_loop:
       mov   ax, 0               ; clear the registers for visibility
       mov   bx, 0
       mov   dx, 0
       call  show_regs
       call  get_signed_byte     ; first number to  al
       call  show_regs
       push  ax                  ; temporarily save ax
       call  get_signed_byte     ; second number to bl
       mov   bl, al
       pop   ax                  ; get ax back
       mov   dl, al              ; copy of al to dl
       add   dl, bl              ; dl (=al) + bl
       call  show_regs_and_wait
       loop  signed_byte_loop

       jmp   outer_loop
; + + + + + + + + + + + + + + + END CODE ABOVE THIS LINE

       ret

main   endp
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

CODESTUFF    ENDS
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
       END     start

