SLOWDOWN            equ       0h
RED       equ       05h
GREEN     equ       02h
BLUE      equ       04h
WHITE     equ       08h
VGA_SEGMENT         equ       0a000h
SC_INDEX            equ       3c4h
MAP_MASK            equ       2
SCREEN_WIDTH        equ       80
SCREEN_HEIGHT       equ       350       ;???????????
WORD_OUTS_OK        equ       1
stak     segment   para stack 'STACK'
         db        512 dup (?)
stak     ends
ObjectStructure     struc
Delay               dw        ?
BaseDelay           dw        ?
Image               dw        ?
XCoord              dw        ?
XInc                dw        ?
XLeftLimit          dw        ?
XRightLimit         dw        ?
YCoord              dw        ?
YInc                dw        ?
YTopLimit           dw        ?
YBottomLimit        dw        ?
PlaneSelect         db        ?
                    db        ?
ObjectStructure     ends
Data    segment word 'DATA'
Colors  db        000h
        db        03ch
        db        03ah
        db        03ch
        db        039h
        db        03ch
        db        03ah
        db        03ch
        db        03fh
        db        03ch
        db        03ah
        db        03ch
        db        039h
        db        03ch
        db        03ah
        db        03ch
        db        000h
Square  label     byte
        dw        48,6
        rept      8
        db        0,0,0,0,0,0
        endm
        .radix    2
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,00000000,00000000,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        db        0,11111111,11111111,11111111,11111111,0
        .radix    10
        rept        8
        db          0,0,0,0,0,0
        endm
Diamond label   byte
        dw      48,6
        rept    8
        db      0,0,0,0,0,0
        endm
        .radix  2
        db        0,00000000,00000001,10000000,00000000,0
        db        0,00000000,00000011,11000000,00000000,0
        db        0,00000000,00000111,11100000,00000000,0
        db        0,00000000,00001111,11110000,00000000,0
        db        0,00000000,00011111,11111000,00000000,0
        db        0,00000000,00111110,01111100,00000000,0
        db        0,00000000,01111100,00111110,00000000,0
        db        0,00000000,11111000,00011111,00000000,0
        db        0,00000001,11110000,00001111,10000000,0
        db        0,00000011,11100000,00000111,11000000,0
        db        0,00000111,11000000,00000011,11100000,0
        db        0,00001111,10000001,10000001,11110000,0
        db        0,00011111,00000011,11000000,11111000,0
        db        0,00111110,00000111,11100000,01111100,0
        db        0,01111100,00001111,11110000,00111110,0
        db        0,11111000,00011111,11111000,00011111,0
        db        0,11111000,00011111,11111000,00011111,0
        db        0,01111100,00001111,11110000,00111110,0
        db        0,00111110,00000111,11100000,01111100,0
        db        0,00011111,00000011,11000000,11111000,0
        db        0,00001111,10000001,10000001,11110000,0
        db        0,00000111,11000000,00000011,11100000,0
        db        0,00000011,11100000,00000111,11000000,0
        db        0,00000001,11110000,00001111,10000000,0
        db        0,00000000,11111000,00011111,00000000,0
        db        0,00000000,01111100,00111110,00000000,0
        db        0,00000000,00111110,01111100,00000000,0
        db        0,00000000,00011111,11111000,00000000,0
        db        0,00000000,00001111,11110000,00000000,0
        db        0,00000000,00000111,11100000,00000000,0
        db        0,00000000,00000011,11000000,00000000,0
        db        0,00000000,00000001,10000000,00000000,0
        .radix  10
        rept    8
        db      0,0,0,0,0,0
        endm
        even
ObjectList      label   ObjectStructure
 ObjectStructure <1,21,Diamond,88,8,80,512,016,0,0,350,RED>
 ObjectStructure <1,15,Square ,296,8,112,480,144,0,0,350,RED>
 ObjectStructure <1,23,Diamond,88,8,80,512,256,0,0,350,RED>
 ObjectStructure <1,13,Square ,120,0,0,640,144,4,0,280,BLUE>
 ObjectStructure <1,11,Diamond,208,0,0,512,144,4,0,280,BLUE>
 ObjectStructure <1,08,Square ,296,0,0,512,144,4,0,288,BLUE>
 ObjectStructure <1,09,Diamond,384,0,0,512,144,4,0,288,BLUE>
 ObjectStructure <1,14,Square ,472,0,0,512,144,4,0,280,BLUE>
 ObjectStructure <1,08,Diamond,200,8,0,576,048,6,0,280,GREEN>
 ObjectStructure <1,08,Square ,248,8,0,576,096,6,0,280,GREEN>
 ObjectStructure <1,08,Diamond,296,8,0,576,144,6,0,280,GREEN>
 ObjectStructure <1,08,Square ,344,8,0,576,192,6,0,280,GREEN>
 ObjectStructure <1,08,Diamond,392,8,0,576,240,6,0,280,GREEN>
ObjectListEnd   label   ObjectStructure
Data    ends
OUT_WORD        macro
if WORD_OUTS_OK
        out     dx,ax
else
        out     dx,al
        inc     dx
        xchg    ah,al
        out     dx,al
        dec     dx
        xchg    ah,al
endif
        endm
CONSTANT_TO_INDEXED_REGISTER    macro ADDRESS,  INDEX,  VALUE
        mov     dx,ADDRESS
        mov     ax,(VALUE shl 8) + INDEX
        OUT_WORD
        endm
Code    segment
        assume  cs:Code, ds:Data
Start   proc    near
        cld
        mov     ax,Data
        mov     ds,ax
        mov     ax,0010h
        int     10h
        mov     ax,(10h shl 8) + 2
        push    ds
        pop     es
        mov     dx,offset Colors
        int     10h
        CONSTANT_TO_INDEXED_REGISTER SC_INDEX, MAP_MASK, 08H
        mov     ax,VGA_SEGMENT
        mov     es,ax
        sub     di,di
        mov     bp,SCREEN_HEIGHT/16
BackdropBlockLoop:
 ;   call    DrawGridCross
 ;   call    DrawGridVert
        dec     bp
        jnz     BackdropBlockLoop
 ;   call    DrawGridCross
AnimationLoop:
        mov bx,offset ObjectList
ObjectLoop:
        dec     [bx+Delay]
        jnz     DoNextObject
        mov     ax,[bx+BaseDelay]
        mov     [bx+Delay],ax
        mov     dx,SC_INDEX
        mov     ah,[bx+PlaneSelect]
        mov     al,MAP_MASK
        OUT_WORD
        mov     cx,[bx+XCoord]
        cmp     cx,[bx+XLeftLimit]
        ja      CheckXRightLimit
        neg     [bx+XInc]
CheckXRightLimit:
        cmp     cx,[bx+XRightLimit]
        jb      SetNewX
        neg     [bx+XInc]
SetNewX:
        add     cx,[bx+XInc]
        mov     [bx+XCoord],cx
        mov     dx,[bx+YCoord]
        cmp     dx,[bx+YTopLimit]
        ja      CheckYBottomLimit
        neg     [bx+YInc]
CheckYBottomLimit:
        cmp     dx,[bx+YBottomLimit]
        jb      SetNewY
        neg     [bx+YInc]
SetNewY:
        add     dx,[bx+YInc]
        mov     [bx+YCoord],dx
        mov     si,[bx+Image]
        call    DrawObject
DoNextObject:
        add     bx,size ObjectStructure
        cmp     bx,offset ObjectListEnd
        jb      ObjectLoop
if SLOWDOWN
        mov     cx,SLOWDOWN
DelayLoop:
        loop    DelayLoop
endif
CheckKey:
        mov     ah,1
        int     16h
        jz      AnimationLoop
        sub     ah,ah
        int     16h
        mov     ax,0003h
        int     10h
        mov     ah,4ch
        int     21h
Start   endp
DrawGridCross   proc    near
        mov     ax,0ffffh
        mov     cx,SCREEN_WIDTH/2-1
        rep     stosw
        mov     ax,0080h
        stosw
        ret
DrawGridCross   endp
DrawGridVert    proc    near
        mov     ax,0080h
        mov     dx,15
BackdropRowLoop:
        mov     cx,SCREEN_WIDTH/2
        rep     stosw
        dec     dx
        jnz     BackdropRowLoop
        ret
DrawGridVert    endp
DrawObject      proc    near
        mov     ax,SCREEN_WIDTH
        mul     dx
        shr     cx,1
        shr     cx,1
        shr     cx,1
        add     ax,cx
        mov     di,ax
        lodsw
        mov     dx,ax
        lodsw
        mov     bp,SCREEN_WIDTH
        sub     bp,ax
DrawLoop:
        mov     cx,ax
        rep     movsb
        add     di,bp
        dec     dx
        jnz     DrawLoop
        ret
DrawObject      endp
Code    ends
        end     Start
