.radix  16
                ;
cseg    segment
                assume  cs:cseg, ds:cseg, es:cseg
                ;
                video   equ     10      ; bios video interrupt
                exit    equ     20      ; return to ccp routine
                getmode equ     0f
                setmode equ     0
                cgual   equ     1110    ; char gen routine, user alpha load
                ;
                org     100
                ;
tableadd    equ offset tabl
                ;
line58:         mov     ah, getmode
                int     video           ; get screen mode
                ;
                mov     ah, setmode
                int     video           ; set screen mode
                mov     ax, cgual       ; char gen routine, must follow a set mode
                mov     bx, 600         ; bx=6 ==> 6 bytes per char
                                        ; bl=0 ==> char block to load
                mov     cx, 100         ; 100 characters to load (256d)
                xor     dx, dx          ; offset into table located at
                mov     bp, tableadd    ; es:bp
                int     video
                int     exit
                ;
                ;
tabl:
                db      000h, 000h, 000h, 000h, 000h, 000       ; 0     "^@"
                db      07Eh, 0A5h, 081h, 0BDh, 099h, 07E       ; 1     "^A"
                db      07Eh, 0DBh, 0FFh, 0C3h, 0E7h, 07E       ; 2     "^B"
                db      06Ch, 0FEh, 0FEh, 07Ch, 038h, 010       ; 3     "^C"
                db      010h, 038h, 07Ch, 038h, 010h, 000       ; 4     "^D"
                db      038h, 038h, 0D6h, 0FEh, 0D6h, 038       ; 5     "^E"
                db      010h, 038h, 07Ch, 0FEh, 0D6h, 038       ; 6     "^F"
                db      000h, 038h, 07Ch, 07Ch, 038h, 000       ; 7     "^G"
                db      0FEh, 0C6h, 082h, 082h, 0C6h, 0FE       ; 8     "^H"
                db      000h, 038h, 044h, 044h, 038h, 000       ; 9     "^I"
                db      0FEh, 0C6h, 0BAh, 0BAh, 0C6h, 0FE       ; 10    "^J"
                db      00Fh, 007h, 07Dh, 0CCh, 0CCh, 078       ; 11    "^K"
                db      03Ch, 066h, 03Ch, 018h, 07Eh, 018       ; 12    "^L"
                db      03Fh, 031h, 03Fh, 030h, 0F0h, 0E0       ; 13    "^M"
                db      07Fh, 063h, 07Fh, 0E3h, 0CFh, 00E       ; 14    "^N"
                db      0DBh, 03Ch, 0E7h, 0E7h, 03Ch, 0DBh      ; 15    "^O"
                db      040h, 070h, 07Ch, 070h, 040h, 000       ; 16    "^P"
                db      004h, 01Ch, 07Ch, 01Ch, 004h, 000       ; 17    "^Q"
                db      018h, 03Ch, 018h, 018h, 03Ch, 018       ; 18    "^R"
                db      066h, 066h, 066h, 000h, 066h, 000       ; 19    "^S"
                db      07Fh, 0DBh, 07Bh, 01Bh, 01Bh, 000       ; 20    "^T"
                db      03Eh, 063h, 038h, 038h, 0CCh, 078       ; 21    "^U"
                db      000h, 000h, 000h, 07Eh, 07Eh, 000       ; 22    "^V"
                db      018h, 03Ch, 018h, 03Ch, 018h, 0FF       ; 23    "^W"
                db      018h, 03Ch, 05Ah, 018h, 018h, 000       ; 24    "^X"
                db      018h, 018h, 05Ah, 03Ch, 018h, 000       ; 25    "^Y"
                db      018h, 00Ch, 0FEh, 00Ch, 018h, 000       ; 26    "^Z"
                db      030h, 060h, 0FEh, 060h, 030h, 000       ; 27    "^["
                db      000h, 0C0h, 0C0h, 0FEh, 000h, 000       ; 28    "^\"
                db      024h, 066h, 0FFh, 066h, 024h, 000       ; 29    "^]"
                db      000h, 010h, 038h, 07Ch, 0FEh, 000       ; 30    "^^"
                db      000h, 0FEh, 07Ch, 038h, 010h, 000       ; 31    "^_"
                db      000h, 000h, 000h, 000h, 000h, 000       ; 32    " "
                db      018h, 018h, 018h, 000h, 018h, 000       ; 33    "!"
                db      06Ch, 06Ch, 000h, 000h, 000h, 000       ; 34    """
                db      06Ch, 0FEh, 06Ch, 0FEh, 06Ch, 000       ; 35    "#"
                db      018h, 03Eh, 070h, 00Eh, 07Ch, 018       ; 36    "$"
                db      066h, 06Ch, 018h, 036h, 066h, 000       ; 37    "%"
                db      070h, 0D8h, 076h, 0CCh, 076h, 000       ; 38    "&"
                db      018h, 018h, 030h, 000h, 000h, 000       ; 39    "'"
                db      018h, 030h, 030h, 030h, 018h, 000       ; 40    "("
                db      030h, 018h, 018h, 018h, 030h, 000       ; 41    ")"
                db      066h, 03Ch, 0FFh, 03Ch, 066h, 000       ; 42    "*"
                db      018h, 018h, 07Eh, 018h, 018h, 000       ; 43    "+"
                db      000h, 000h, 000h, 018h, 018h, 030       ; 44    ","
                db      000h, 000h, 07Eh, 000h, 000h, 000       ; 45    "-"
                db      000h, 000h, 000h, 018h, 018h, 000       ; 46    "."
                db      006h, 00Ch, 018h, 030h, 060h, 000       ; 47    "/"
                db      03Ch, 066h, 066h, 066h, 03Ch, 000       ; 48    "0"
                db      018h, 038h, 018h, 018h, 07Eh, 000       ; 49    "1"
                db      03Ch, 066h, 00Ch, 038h, 07Eh, 000       ; 50    "2"
                db      07Ch, 006h, 03Ch, 006h, 07Ch, 000       ; 51    "3"
                db      01Ch, 03Ch, 06Ch, 0FEh, 00Ch, 000       ; 52    "4"
                db      07Ch, 060h, 07Ch, 006h, 07Ch, 000       ; 53    "5"
                db      03Ch, 060h, 07Ch, 066h, 03Ch, 000       ; 54    "6"
                db      07Eh, 006h, 00Ch, 018h, 018h, 000       ; 55    "7"
                db      03Ch, 066h, 03Ch, 066h, 03Ch, 000       ; 56    "8"
                db      03Ch, 066h, 03Eh, 006h, 03Ch, 000       ; 57    "9"
                db      018h, 018h, 000h, 018h, 018h, 000       ; 58    ":"
                db      018h, 018h, 000h, 018h, 018h, 030       ; 59    ";"
                db      00Ch, 018h, 030h, 018h, 00Ch, 000       ; 60    "<"
                db      000h, 07Eh, 000h, 07Eh, 000h, 000       ; 61    "="
                db      030h, 018h, 00Ch, 018h, 030h, 000       ; 62    ">"
                db      07Ch, 0C6h, 01Ch, 000h, 018h, 000       ; 63    "?"
                db      07Ch, 0C6h, 0DEh, 0DEh, 0C0h, 078       ; 64    "@"
                db      018h, 03Ch, 066h, 07Eh, 066h, 000       ; 65    "A"
                db      0FCh, 066h, 07Ch, 066h, 0FCh, 000       ; 66    "B"
                db      07Eh, 0C2h, 0C0h, 0C0h, 07Eh, 000       ; 67    "C"
                db      0FCh, 066h, 066h, 066h, 0FCh, 000       ; 68    "D"
                db      0FEh, 062h, 078h, 062h, 0FEh, 000       ; 69    "E"
                db      0FEh, 062h, 078h, 060h, 0F0h, 000       ; 70    "F"
                db      07Ch, 0C0h, 0DEh, 0C6h, 07Eh, 000       ; 71    "G"
                db      066h, 066h, 07Eh, 066h, 066h, 000       ; 72    "H"
                db      03Ch, 018h, 018h, 018h, 03Ch, 000       ; 73    "I"
                db      01Eh, 00Ch, 00Ch, 0CCh, 078h, 000       ; 74    "J"
                db      0E6h, 06Ch, 078h, 06Ch, 0E6h, 000       ; 75    "K"
                db      0F0h, 060h, 060h, 062h, 0FEh, 000       ; 76    "L"
                db      0C6h, 0EEh, 0FEh, 0D6h, 0C6h, 000       ; 77    "M"
                db      0E6h, 0F6h, 0DEh, 0CEh, 0C6h, 000       ; 78    "N"
                db      07Ch, 0C6h, 0C6h, 0C6h, 07Ch, 000       ; 79    "O"
                db      0FCh, 066h, 07Ch, 060h, 0F0h, 000       ; 80    "P"
                db      078h, 0CCh, 0CCh, 068h, 01Eh, 000       ; 81    "Q"
                db      0FCh, 066h, 07Ch, 06Ch, 0E6h, 000       ; 82    "R"
                db      07Ch, 0C0h, 07Ch, 006h, 0FCh, 000       ; 83    "S"
                db      07Eh, 05Ah, 018h, 018h, 03Ch, 000       ; 84    "T"
                db      066h, 066h, 066h, 066h, 07Eh, 000       ; 85    "U"
                db      066h, 066h, 066h, 03Ch, 018h, 000       ; 86    "V"
                db      0C6h, 0D6h, 0FEh, 0EEh, 0C6h, 000       ; 87    "W"
                db      066h, 03Ch, 018h, 03Ch, 066h, 000       ; 88    "X"
                db      066h, 066h, 03Ch, 018h, 018h, 000       ; 89    "Y"
                db      07Eh, 04Ch, 018h, 032h, 07Eh, 000       ; 90    "Z"
                db      03Ch, 030h, 030h, 030h, 03Ch, 000       ; 91    "["
                db      060h, 030h, 018h, 00Ch, 006h, 000       ; 92    "\"
                db      03Ch, 00Ch, 00Ch, 00Ch, 03Ch, 000       ; 93    "]"
                db      010h, 038h, 06Ch, 000h, 000h, 000       ; 94    "^"
                db      000h, 000h, 000h, 000h, 000h, 0FF       ; 95    "_"
                db      030h, 030h, 018h, 000h, 000h, 000       ; 96    "`"
                db      000h, 07Ch, 0CCh, 0CCh, 076h, 000       ; 97    "a"
                db      0E0h, 06Ch, 076h, 066h, 0FCh, 000       ; 98    "b"
                db      000h, 03Eh, 060h, 060h, 03Eh, 000       ; 99    "c"
                db      00Ch, 06Ch, 0DCh, 0CCh, 07Eh, 000       ; 100   "d"
                db      000h, 03Ch, 06Eh, 070h, 03Eh, 000       ; 101   "e"
                db      01Ch, 030h, 07Ch, 030h, 078h, 000       ; 102   "f"
                db      000h, 076h, 0CCh, 07Ch, 00Ch, 078       ; 103   "g"
                db      0E0h, 06Ch, 076h, 066h, 0E6h, 000       ; 104   "h"
                db      000h, 038h, 018h, 018h, 03Ch, 000       ; 105   "i"
                db      000h, 01Ch, 00Ch, 00Ch, 0CCh, 078       ; 106   "j"
                db      0E0h, 06Eh, 078h, 06Ch, 0E6h, 000       ; 107   "k"
                db      038h, 018h, 018h, 018h, 03Ch, 000       ; 108   "l"
                db      000h, 0CCh, 0FEh, 0FEh, 0D6h, 000       ; 109   "m"
                db      000h, 0DCh, 066h, 066h, 066h, 000       ; 110   "n"
                db      000h, 03Ch, 066h, 066h, 03Ch, 000       ; 111   "o"
                db      000h, 0FCh, 066h, 076h, 06Ch, 060       ; 112   "p"
                db      000h, 07Eh, 0CCh, 0DCh, 06Ch, 00E       ; 113   "q"
                db      000h, 06Eh, 036h, 030h, 078h, 000       ; 114   "r"
                db      000h, 03Eh, 070h, 00Eh, 07Ch, 000       ; 115   "s"
                db      030h, 07Ch, 030h, 030h, 01Ch, 000       ; 116   "t"
                db      000h, 0CCh, 0CCh, 0CCh, 076h, 000       ; 117   "u"
                db      000h, 0E6h, 066h, 03Ch, 018h, 000       ; 118   "v"
                db      000h, 0C6h, 0D6h, 0FEh, 06Ch, 000       ; 119   "w"
                db      000h, 0E6h, 06Ch, 038h, 0EEh, 000       ; 120   "x"
                db      000h, 0E6h, 066h, 03Eh, 006h, 03C       ; 121   "y"
                db      000h, 07Ch, 018h, 030h, 07Ch, 000       ; 122   "z"
                db      00Eh, 018h, 070h, 018h, 00Eh, 000       ; 123   "{"
                db      018h, 018h, 008h, 010h, 018h, 018       ; 124   "|"
                db      070h, 018h, 00Eh, 018h, 070h, 000       ; 125   "}"
                db      076h, 0DCh, 000h, 000h, 000h, 000       ; 126   "~"
                db      010h, 038h, 06Ch, 0C6h, 0FEh, 000       ; 127   ""
                db      07Eh, 0C2h, 0C0h, 07Eh, 008h, 030       ; 128   ""
                db      0CCh, 000h, 0CCh, 0CCh, 076h, 000       ; 129   ""
                db      003h, 03Ch, 06Eh, 070h, 03Eh, 000       ; 130   ""
                db      07Eh, 0C3h, 03Eh, 066h, 03Bh, 000       ; 131   ""
                db      0CCh, 000h, 07Ch, 0CCh, 076h, 000       ; 132   ""
                db      0E0h, 000h, 07Ch, 0CCh, 076h, 000       ; 133   ""
                db      030h, 000h, 07Ch, 0CCh, 076h, 000       ; 134   ""
                db      000h, 03Eh, 060h, 03Eh, 008h, 018       ; 135   ""
                db      07Eh, 0C3h, 03Ch, 06Eh, 070h, 03E       ; 136   ""
                db      0C3h, 03Ch, 06Eh, 070h, 03Eh, 000       ; 137   ""
                db      0E0h, 03Ch, 06Eh, 070h, 03Eh, 000       ; 138   ""
                db      066h, 000h, 038h, 018h, 03Ch, 000       ; 139   ""
                db      07Ch, 0C6h, 038h, 018h, 03Ch, 000       ; 140   ""
                db      070h, 000h, 038h, 018h, 03Ch, 000       ; 141   ""
                db      0C6h, 038h, 06Ch, 0FEh, 0C6h, 000       ; 142   ""
                db      018h, 000h, 03Ch, 066h, 07Eh, 066       ; 143   ""
                db      01Eh, 0FCh, 060h, 078h, 060h, 0FC       ; 144   ""
                db      000h, 0EEh, 03Bh, 0DCh, 077h, 000       ; 145   ""
                db      03Eh, 06Ch, 0FEh, 0CCh, 0CEh, 000       ; 146   ""
                db      03Ch, 066h, 000h, 03Ch, 066h, 03C       ; 147   ""
                db      066h, 000h, 03Ch, 066h, 03Ch, 000       ; 148   ""
                db      070h, 000h, 03Ch, 066h, 03Ch, 000       ; 149   ""
                db      078h, 0CCh, 000h, 0CCh, 0CCh, 076       ; 150   ""
                db      0E0h, 000h, 0CCh, 0CCh, 076h, 000       ; 151   ""
                db      066h, 000h, 066h, 03Eh, 006h, 03C       ; 152   ""
                db      0C3h, 03Ch, 066h, 066h, 066h, 03C       ; 153   ""
                db      066h, 000h, 066h, 066h, 066h, 07E       ; 154   ""
                db      018h, 07Eh, 0C0h, 0C0h, 07Eh, 018       ; 155   ""
                db      03Ch, 066h, 0F0h, 062h, 0FEh, 000       ; 156   ""
                db      066h, 03Ch, 07Eh, 018h, 07Eh, 018       ; 157   ""
                db      0F8h, 0CCh, 0FAh, 0CFh, 0C6h, 0C7       ; 158   ""
                db      00Eh, 01Bh, 03Ch, 018h, 0D8h, 070       ; 159   ""
                db      01Eh, 000h, 07Ch, 0CCh, 076h, 000       ; 160   ""
                db      01Ch, 000h, 038h, 018h, 03Ch, 000       ; 161   ""
                db      00Eh, 000h, 03Ch, 066h, 03Ch, 000       ; 162   ""
                db      01Ch, 000h, 0CCh, 0CCh, 076h, 000       ; 163   ""
                db      07Ch, 000h, 0DCh, 066h, 066h, 000       ; 164   ""
                db      07Eh, 000h, 076h, 07Eh, 06Eh, 066       ; 165   ""
                db      03Ch, 06Ch, 036h, 000h, 07Eh, 000       ; 166   ""
                db      038h, 06Ch, 038h, 000h, 07Ch, 000       ; 167   ""
                db      030h, 000h, 070h, 0C6h, 07Ch, 000       ; 168   ""
                db      000h, 000h, 07Eh, 060h, 060h, 000       ; 169   ""
                db      000h, 000h, 07Eh, 006h, 006h, 000       ; 170   ""
                db      0C6h, 0CCh, 0DEh, 033h, 06Ch, 00F       ; 171   ""
                db      0C6h, 0CCh, 0DBh, 037h, 06Fh, 003       ; 172   ""
                db      018h, 000h, 018h, 018h, 018h, 000       ; 173   ""
                db      000h, 066h, 0CCh, 066h, 000h, 000       ; 174   ""
                db      000h, 0CCh, 066h, 0CCh, 000h, 000       ; 175   ""
                db      022h, 088h, 022h, 088h, 022h, 088       ; 176   ""
                db      055h, 0AAh, 055h, 0AAh, 055h, 0AA       ; 177   ""
                db      0DDh, 077h, 0DDh, 077h, 0DDh, 077       ; 178   ""
                db      018h, 018h, 018h, 018h, 018h, 018       ; 179   ""
                db      018h, 018h, 018h, 0F8h, 018h, 018       ; 180   ""
                db      018h, 0F8h, 018h, 0F8h, 018h, 018       ; 181   ""
                db      036h, 036h, 036h, 0F6h, 036h, 036       ; 182   ""
                db      000h, 000h, 000h, 0FEh, 036h, 036       ; 183   ""
                db      000h, 0F8h, 018h, 0F8h, 018h, 018       ; 184   ""
                db      036h, 0F6h, 006h, 0F6h, 036h, 036       ; 185   ""
                db      036h, 036h, 036h, 036h, 036h, 036       ; 186   ""
                db      000h, 0FEh, 006h, 0F6h, 036h, 036       ; 187   ""
                db      036h, 0F6h, 006h, 0FEh, 000h, 000       ; 188   ""
                db      036h, 036h, 036h, 0FEh, 000h, 000       ; 189   ""
                db      018h, 0F8h, 018h, 0F8h, 000h, 000       ; 190   ""
                db      000h, 000h, 000h, 0F8h, 018h, 018       ; 191   ""
                db      018h, 018h, 018h, 01Fh, 000h, 000       ; 192   ""
                db      018h, 018h, 018h, 0FFh, 000h, 000       ; 193   ""
                db      000h, 000h, 000h, 0FFh, 018h, 018       ; 194   ""
                db      018h, 018h, 018h, 01Fh, 018h, 018       ; 195   ""
                db      000h, 000h, 000h, 0FFh, 000h, 000       ; 196   ""
                db      018h, 018h, 018h, 0FFh, 018h, 018       ; 197   ""
                db      018h, 01Fh, 018h, 01Fh, 018h, 018       ; 198   ""
                db      036h, 036h, 036h, 037h, 036h, 036       ; 199   ""
                db      036h, 037h, 030h, 03Fh, 000h, 000       ; 200   ""
                db      000h, 03Fh, 030h, 037h, 036h, 036       ; 201   ""
                db      036h, 0F7h, 000h, 0FFh, 000h, 000       ; 202   ""
                db      000h, 0FFh, 000h, 0F7h, 036h, 036       ; 203   ""
                db      036h, 037h, 030h, 037h, 036h, 036       ; 204   ""
                db      000h, 0FFh, 000h, 0FFh, 000h, 000       ; 205   ""
                db      036h, 0F7h, 000h, 0F7h, 036h, 036       ; 206   ""
                db      018h, 0FFh, 000h, 0FFh, 000h, 000       ; 207   ""
                db      036h, 036h, 036h, 0FFh, 000h, 000       ; 208   ""
                db      000h, 0FFh, 000h, 0FFh, 018h, 018       ; 209   ""
                db      000h, 000h, 000h, 0FFh, 036h, 036       ; 210   ""
                db      036h, 036h, 036h, 03Fh, 000h, 000       ; 211   ""
                db      018h, 01Fh, 018h, 01Fh, 000h, 000       ; 212   ""
                db      000h, 01Fh, 018h, 01Fh, 018h, 018       ; 213   ""
                db      000h, 000h, 000h, 03Fh, 036h, 036       ; 214   ""
                db      036h, 036h, 036h, 0FFh, 036h, 036       ; 215   ""
                db      018h, 0FFh, 018h, 0FFh, 018h, 018       ; 216   ""
                db      018h, 018h, 018h, 0F8h, 000h, 000       ; 217   ""
                db      000h, 000h, 000h, 01Fh, 018h, 018       ; 218   ""
                db      0FFh, 0FFh, 0FFh, 0FFh, 0FFh, 0FF       ; 219   ""
                db      000h, 000h, 000h, 0FFh, 0FFh, 0FF       ; 220   ""
                db      0F0h, 0F0h, 0F0h, 0F0h, 0F0h, 0F0       ; 221   ""
                db      00Fh, 00Fh, 00Fh, 00Fh, 00Fh, 00F       ; 222   ""
                db      0FFh, 0FFh, 0FFh, 000h, 000h, 000       ; 223   ""
                db      000h, 076h, 0DCh, 0DCh, 076h, 000       ; 224   ""
                db      03Ch, 066h, 07Ch, 066h, 07Ch, 060       ; 225   ""
                db      07Eh, 032h, 030h, 030h, 078h, 000       ; 226   ""
                db      000h, 0FEh, 06Ch, 06Ch, 06Ch, 000       ; 227   ""
                db      07Eh, 030h, 018h, 030h, 07Eh, 000       ; 228   ""
                db      000h, 03Fh, 06Ch, 06Ch, 038h, 000       ; 229   ""
                db      000h, 066h, 066h, 066h, 07Bh, 0C0       ; 230   ""
                db      000h, 07Eh, 0D8h, 018h, 00Ch, 000       ; 231   ""
                db      018h, 07Eh, 0DBh, 0DBh, 07Eh, 018       ; 232   ""
                db      07Ch, 0C6h, 0FEh, 0C6h, 07Ch, 000       ; 233   ""
                db      07Ch, 0C6h, 0C6h, 06Ch, 0EEh, 000       ; 234   ""
                db      00Eh, 018h, 07Ch, 0C6h, 07Ch, 000       ; 235   ""
                db      000h, 06Eh, 0DBh, 0DBh, 076h, 000       ; 236   ""
                db      008h, 07Ch, 0D6h, 0D6h, 07Ch, 020       ; 237   ""
                db      03Ch, 060h, 07Ch, 060h, 03Ch, 000       ; 238   ""
                db      03Ch, 066h, 066h, 066h, 066h, 000       ; 239   ""
                db      07Eh, 000h, 07Eh, 000h, 07Eh, 000       ; 240   ""
                db      018h, 07Eh, 018h, 000h, 07Eh, 000       ; 241   ""
                db      030h, 018h, 00Ch, 07Eh, 000h, 07E       ; 242   ""
                db      00Ch, 018h, 030h, 07Eh, 000h, 07E       ; 243   ""
                db      00Eh, 01Bh, 018h, 018h, 018h, 018       ; 244   ""
                db      018h, 018h, 018h, 018h, 0D8h, 070       ; 245   ""
                db      018h, 000h, 07Eh, 000h, 018h, 000       ; 246   ""
                db      076h, 0DCh, 000h, 076h, 0DCh, 000       ; 247   ""
                db      038h, 06Ch, 038h, 000h, 000h, 000       ; 248   ""
                db      000h, 000h, 018h, 018h, 000h, 000       ; 249   ""
                db      000h, 000h, 000h, 018h, 000h, 000       ; 250   ""
                db      00Eh, 00Ch, 00Ch, 06Ch, 03Ch, 01C       ; 251   ""
                db      06Ch, 036h, 036h, 036h, 000h, 000       ; 252   ""
                db      038h, 00Ch, 018h, 03Ch, 000h, 000       ; 253   ""
                db      000h, 03Ch, 03Ch, 03Ch, 000h, 000       ; 254   ""
                db      000h, 000h, 000h, 000h, 000h, 000       ; 255
;
cseg    ends
        end     line58
