;MouCursG.Asm - Demonstrates the use of a graphic mouse cursor.
;
;This code assumes VGA hardware.  See below how to correct for others.
;
;Written August 21, 1991 by Keith Kim.
;Thanks to Rocco Valotta for mouse driver interface information.


.MODEL SMALL
.CODE
        ORG 100h

START:  JMP SHORT TOP

bModeSave       db ?

xHotCrossHair   dw 8
yHotCrossHair   dw 8
DataCrossHair:  ;screen mask
                dw 0ffffh
                dw 0fe3fh
                dw 0fe3fh
                dw 0fe3fh
                dw 0fe3fh
                dw 0fe3fh
                dw 0fe3fh
                dw 08000h
                dw 08000h
                dw 08000h
                dw 0fe3fh
                dw 0fe3fh
                dw 0fe3fh
                dw 0fe3fh
                dw 0fe3fh
                dw 0fe3fh
                ;cursor mask
                dw 00000h
                dw 00000h
                dw 00080h
                dw 00080h
                dw 00080h
                dw 00080h
                dw 00080h
                dw 00080h
                dw 03ffeh
                dw 00080h
                dw 00080h
                dw 00080h
                dw 00080h
                dw 00080h
                dw 00080h
                dw 00000h

TOP:    mov     ax, 0   ;initialize mouse
        int     33h

        mov     ax, 33  ;mouse driver software reset
        int     33h

        mov     ah, 15  ;get and save current video mode
        int     10h
        mov     bModeSave, al

;the following code will only work on a VGA card!!!
;for other cards, either remove this code, or
;correct the MODE, BUFFER address, and number of bytes written.
;
        mov     al, 12h ;switch to 640x480 16 colour VGA graphics mode
                        ;4 = 320x200 4 colour graphics mode
        mov     ah, 0   ;set video mode
        int     10h

        ;fill the first half of video RAM with white
        mov     ax, 0a000h  ;buffer address for VGA mode 12h
        mov     es, ax
        mov     di, 0
        mov     al, 0ffh
        cld
        mov     cx, 19200   ;640 * 480 / 8 (bits/byte) / 2
    rep stosb
;
;end of VGA specific code

        push    ds          ;move ds...
        pop     es          ;...into es

        ;define graphics cursor shape
        ;if you do not define a shape a default arrow shape is used

        mov     bx, xHotCrossHair  ;hot-spot location horizontal
        mov     cx, yHotCrossHair  ;hot-spot location vertical
        mov     dx, offset DataCrossHair  ;mouse cursor shape data

        mov     ax, 9
        int     33h

        MOV     AX,1  ;SHOW CURSOR
        INT     33H

        MOV     AH,7  ;WAIT FOR KEY
        INT     21H

        MOV     AX,2  ;TURN OFF MOUSE CHARACTER
        INT     33H

        mov     al, bModeSave   ;restore video mode
        mov     ah, 0
        int     10h

EXIT:
        INT     20H   ;TERMINATE PROGRAM

        END     START
