;From Anthony Williams
;Help for commandline parameters (took me a while).
;Commented lines are for A86 use (this one is MASM, or TASM acting like MASM)
;

; print_str macro #1
print_str macro variable                 ;macro to print a string
push dx                                  ;save registers being used
push ax
mov ah,9                                 ;function to print string
mov dx,offset variable
; mov dx,offset #1
int 21h                                  ;call DOS
pop ax                                   ;restore registers
pop dx
endm
; #em

Exit_prog macro                          ;Exit_program macro
mov ah,4Ch
int 21h
endm
; #em

CODE_SEG segment
ASSUME CS:CODE_SEG,DS:CODE_SEG
org 100h                                  ;.COM file


Start:
        mov si,83h                        ;ignores switches ('-' and '/')
        cmp byte ptr [si],'?'             ;check if asking for help
        jz Help                           ;jump to Help_screen
        cmp byte ptr [si],'o'             ;go to other screen?
        jz Other                          ;jump to Other_screen
        cmp byte ptr [si],'c'             ;Is it a C?
        jz Clear                          ;jump to Clear_screen
        mov si,81h                        ;see if carriage return was
        cmp byte ptr [si],13              ;entered (no params specified)
        jz None                           ;jump to None
        mov si,83h
        print_str Invalid                 ;if none of the above, then it is
        Exit_prog                         ; an invalid parameter

Help:
        print_str Help_screen             ;print the Help screen
        Exit_prog

Clear:
        mov ax,600h                       ; No idea...
        mov bx,7                          ; All I know is that it
        xor cx,cx                         ; clears the screen
        mov dx,184Fh                      ;
        int 10h                           ;call BIOS
        Exit_prog                         ;Exit

Other:
        print_str Other_screen            ;print the Other screen
        Exit_prog

None:
        print_str None_called             ;say none was chosen
        Exit_prog

Help_screen db 'Well...''/?'' will bring you here,',13,10
            db 'and ''/o'' will take you to the other screen,',13,10
            db 'and ''/c'' will clear the screen,',13,10
            db 'so anything else is not valid.$'
Other_screen db 'This is your generic other screen.$'
None_called db 'You didn''t specify anything!',13,10
            db 'Type ''params /?'' for options.',13,10
            db 'Or ''params -?'' if you want.$'
Invalid db 'That is not a valid parameter.$'

CODE_SEG ends
end Start
