 ;**********************************************************;
 ;* SET480 -- Small program to set 480-scanlines text mode *;
 ;*                     By Tenie Remmel                    *;
 ;**********************************************************;

 Ideal
 Model Tiny
 P186
 CodeSeg
 Org 100h

 Proc        Set480

             mov dx,03C4h           ;Sequencer Port
             mov ax,0100h           ;Synchronous reset
             out dx,ax              ;Send command
             mov dx,03CCh           ;Misc Output Read Port
             in al,dx               ;Read byte
             or al,0C0h             ;Set 480 scanlines
             mov dx,03C2h           ;Misc Output Write Port
             out dx,al              ;Send command
             mov dx,03D4h           ;CRT Controller Port
             mov si,offset CRTCdata ;Offset of CRTC data
             mov cx,9               ;9 words
             rep outsw              ;Send data
             mov dx,03C4h           ;Sequencer Port
             mov ax,0300h           ;Restart Sequencer
             out dx,ax              ;Send command
             xor ax,ax              ;Tell the BIOS
             mov ds,ax              ;about the new
             mov [byte 0484h],29    ;height (30)
             ret                    ;Return

 CRTCdata    dw 00C11h              ;De-protect regs
             dw 00B06h              ;Vertical Total
             dw 03E07h              ;Vertical Overflow 1
             dw 04F09h              ;Vertical Overflow 2
             dw 0EA10h              ;Vertical Retrace Start
             dw 08C11h              ;Vertical Retrace End & Re-protect
             dw 0DF12h              ;Vertical Displayed
             dw 0E715h              ;Vertical Blanking Start
             dw 00416h              ;Vertical Blanking End

 EndP        Set480

 End Set480
