    /* Sample C app using BCDASM routines */

#include <stdio.h>
#include "bcd.h"
#define  BCDSZ  10
#define  BUFSZ  256

int main(void)
{
    byte bnum[BCDSZ];                   /* BCD variable goes here */
    chrA buf[BUFSZ];                    /* String output buffer   */
    chrA nstr[] = "61728394506172839";

    bcdA2p(bnum, BCDSZ, nstr);          /* Convert nstr to BCD   */
    bcdAdd(bnum, bnum, BCDSZ);          /* Add to self           */
    bcdNeg(bnum, BCDSZ);                /* Reverse sign          */

    bcdFmt(buf, BUFSZ, bnum, BCDSZ,     /* Convert BCD to Asciiz */
           32,-1,-1,-1, -1,-1,-1,-1);
                                        /* Display Asciiz string */
    printf("Hello from BCDASM: %s\n", buf);
    return 0;
}