	title	BCDASM -- Copyright 1997, Morten Elling
	subttl	Compare a packed signed BCD number against zero

	include model.inc
	include modelt.inc
	include	bcd.ash

	@CODESEG

;//////////////////////////////////////////////////////////////////////
;//	Name	bcdCmpz
;//	Desc	Compare a packed signed BCD number against zero.
;//
;//
;//	Entry	Passed args
;//	Exit	Accumulator (and cf,zf,sf flags) determined:
;//		Acc = -1: Number is negative
;//		Acc =  0: Number is zero
;//		Acc = +1: Number is positive
;//
;//	Note	Disregards sign of zero.

bcdCmpz proc
arg	dstBCD	:dataptr, \	; Addr of BCD
	dstsz	:@uint		; Byte size of BCD
@uses	ds,rsi,rcx
;.
	@LDS  rsi, [dstBCD]
	mov   rcx, [dstsz]
	dec   rcx		; All but the sign byte
	sub   rax, rax		; Zero accumulator
	@alignn
@@nxt:	mov   al, [rsi]		; Get a BCD byte
	inc   rsi		; Step pointer
	or    ah, al		; OR into ah
	loopz @@nxt		; Keep going until non-zero byte
	jz sh @@ret		; Zero: return cf=0,zf=1,sf=0,acc=0
	add   rsi, rcx		; Point to sign byte
	or    rax, -1		; Assume negative
	test  @bptr [rsi], 80h	; Test sign, if negative
	jnz sh @@ret		;   return cf=0,zf=0,sf=1,acc=-1
	inc   rax		; Positive:
	inc   rax		;   return cf=0,zf=0,sf=0,acc=+1
@@ret:	RET
bcdCmpz endp

	END