	title	BCDASM -- Copyright 1997, Morten Elling
	subttl	Convert packed signed BCD to/from decimal Ascii

	include	model.inc
	include	modelt.inc
	include bcd.ash

	@CODESEG

;//////////////////////////////////////////////////////////////////////
;//	Name	bcdA2p
;//	Desc	Convert decimal Ascii string to packed signed BCD.
;//		String format: [whitespace][sign]digits
;//		Digit parsing stops at 1st non-digit.
;//
;//
;//	Entry	Passed args
;//	Exit	Packed signed BCD returned to destination.
;//		Acc = 0: error: bad digits/overflow (dest. = zero)
;//		Acc > 0: no errors

bcdA2p	proc
arg	dstBCD	:dataptr, \	; Addr of destination BCD
	dstsz	:@uint, \	; Byte size of destination
	pStr	:dataptr	; Addr of Ascii string
@uses	ds,es,rsi,rdi,rbx,rcx,rdx
;.
; ----- Load registers
	@cld			; String ops forward
	@LDS  rsi, [pStr]
	@LES  rdi, [dstBCD]
	mov   rbx, [dstsz]
	dec   rbx		; Handy constant

; ----- Skip leading whitespace
	dec   rsi
@@ch1:	inc   rsi
	mov   al, [rsi]
	cmp   al, 20h		; Space
	je    @@ch1
	cmp   al, 09h		; Tab
	je    @@ch1

; ----- Get sign
	mov   ah, 80h		; Assume number negative
	cmp   al, '-'
	je sh @@ch2
	mov   ah, 00h		; Else positive
	cmp   al, '+'
	je sh @@ch2
	dec   rsi

; ----- Parse Ascii digits
@@ch2:	inc   rsi
	cmp   @bptr [rsi], '0'  ; Skip leading '0's
	je    @@ch2
	dec   rsi
	mov   rcx, rsi		; rcx -> before 1st digit
@@ch3:  inc   rsi
	mov   al, [rsi]
	cmp   al, '0'
	jb sh @@ch4		; Stop at 1st non-digit
	cmp   al, '9'
	jbe   @@ch3
@@ch4:	dec   rsi		; rsi -> last digit

	; Too few or too many?
	neg   rcx
	add   rcx, rsi		; rcx = number of digits
	jz sh @@err		; Need at least one
	mov   rdx, rcx		; Destination 
	shr   rdx, 1		;  can hold max. 2
	adc   rdx, 0		;   BCD digits per byte
	cmp   rdx, rbx
	jbe sh @@stor

; ----- Return error
@@err:	lea   rcx, [rbx+1]	; Include sign byte
	sub   rax, rax		; Zero acc
	rep   stosb		; Wipe destination BCD
	jmp sh @@ret		; Error, return acc = 0


; ----- Convert and store number
;	ds:rsi -> last digit in pStr
;	rcx = no. of ascii digits in pStr (> 0)
;	ah = sign flag (00h or 80h)
;	es:rdi -> LSB in dstBCD
;	rbx = dstsz - 1
;	rdx = (rcx + 1) / 2

@@stor: mov   @ES [rdi+rbx], ah ; Set destination's sign
@@st1:	mov   al, [rsi]
	dec   rsi
	and   al, 0fh		; Strip Ascii
	dec   rcx
	jz sh @@st2
	mov   ah, al
	mov   al, [rsi]
	dec   rsi
	@shl  al, 4
	or    al, ah		; Pack 2 digits per byte
	dec   rcx
@@st2:	stosb			; Store al to destination
	jnz   @@st1
	mov   rcx, rbx		; Zero out rest of BCD
	sub   rcx, rdx
	sub   rax, rax
	rep   stosb
	inc   rax		; Return acc = 1
@@ret:	RET
bcdA2p	endp


;//////////////////////////////////////////////////////////////////////
;//	Name	bcdP2a
;//	Desc	Convert a packed signed BCD to (unformatted) decimal
;//		Ascii. Outputs a leading '+' or '-' and min. one digit.
;//
;//
;//	Entry	Passed args
;//	Exit	Zero-terminated Ascii string returned to destination.
;//		Acc = length of destination string (less trailing 0).
;//
;//	Note	Maximum output to the destination string (incl. the
;//		trailing zero) equals twice the BCD's byte size.

bcdP2a	proc
arg	pStr	:dataptr, \	; Addr of AsciiZ destination
	srcBCD	:dataptr, \	; Addr of source BCD
	srcsz	:@uint		; Byte size of source BCD
@uses	ds,es,rsi,rdi,rcx
;.
	@cld			; String ops forward
	@LDS  rsi, [srcBCD]
	@LES  rdi, [pStr]
	mov   rcx, [srcsz]
	dec   rcx
	add   rsi, rcx

; ----- Output sign prefix
	test  @bptr [rsi], 80h
	mov   al, '-'
	jnz sh @@pa0
	mov   al, '+'
@@pa0:	stosb

; ----- Skip insignificant zeros
@@pa1:	dec   rsi
	mov   al, [rsi]
	test  al, al
	loopz @@pa1
	inc   rcx		; Output at least one digit
	cmp   al, 10h		; Any high nibble?
	jb sh @@pa3		; No, jump into loop

; ----- Convert BCD
@@pa2:	mov   al, [rsi] 	; Get 2 packed BCD digits
	mov   ah, al		; Save both digits
	@shr  al, 4		; Isolate high digit
	or    al, '0'		; Convert to Ascii
	stosb			; Store al to destination
	mov   al, ah		; Get low digit
@@pa3:	and   al, 0fh		; Isolate it
	or    al, '0'           ; Convert to Ascii
	stosb			; Store al to destination
        dec   rsi               ; Decrement src. index
        loop  @@pa2             ; Loop until done

; ----- Zero-terminate string
;	and return its length
	sub   al, al
        stosb
	lea   rax, [rdi-1]
	sub   rax, @uiptr [pStr]
	RET
bcdP2a	endp

	END