;********* BCopy.Asm - copies a block of memory from here to there

;Copyright (c) 1988 Ethan Winer


;Syntax -
;
;   CALL BCopy(FromSeg%, FromAddr%, ToSeg%, ToAddr%, NumBytes%, Direction%)

;Where Direction% = 0 for forward, or anything else for backwards


.Model Medium
.Code
    Include Mixed.Inc

HProc BCopy, FromSeg:Ptr, FromAdr:Ptr, ToSeg:Ptr, ToAdr:Ptr, NumBytes:Ptr, Dir:Ptr

    Cld                    ;assume forward direction for now
    Mov  BX,Dir            ;get pointer to Direction%
    Cmp  Word Ptr [BX],0   ;is it indeed forward?
    Je   Continue          ;yes, skip over
    Std                    ;no, set the flag to backwards

Continue:
    Mov  BX,FromAdr        ;get pointer to FromAddr%
    Mov  SI,[BX]           ;put into SI
    Mov  BX,ToSeg          ;pointer to ToSeg%
    Mov  ES,[BX]           ;put it into ES
    Mov  BX,ToAdr          ;pointer to ToAddr%
    Mov  DI,[BX]           ;put it into DI
    Mov  BX,NumBytes       ;pointer to NumBytes%
    Mov  CX,[BX]           ;put it into CX
    Mov  BX,FromSeg        ;pointer to FromSeg%

    Push DS                ;save DS because it'll get trashed next
    Mov  DS,[BX]           ;put segment in DS
    Rep  Movsb             ;do the move: [DS:SI] ---> [ES:DI]
    Pop  DS                ;restore DS

    Cld                    ;a bug in QB 4.0 requires this
    HRet                   ;return to BASIC

HEndp
End
