;
; Assembly-language source code for CRLF
; a filter to copy the std input to the std output
; making sure that every carriage return is paired with a linefeed, 
; as with normal pc-dos files . Also a ctl-z (hex 1a)
;is added to mark the end of the file if none is present
;
;
CSEG	SEGMENT
	ASSUME  CS:CSEG,DS:CSEG
	ORG	100H	;COM files start at offset 100h
CRLF	PROC	FAR
	JMP	SHORT	READ_CHAR
;
; Equates and storage area
;
cr	equ	0dh	;carriage ret
lf	equ	0ah	;linefeed 
eof	equ	1ah	;ctl-z, end of file marker
tchar	db	?	; store char read from std input
linefeed	db	lf    ;store linefeed char
end_of_file	db	eof	;store eof char
;
; loop reads from std input then writes to
; std output making sure that each char ret is paired with a lf
;
READ_CHAR:
	CALL	READ1	;GET NEXT CHAR FROM STD INPUT
SAVE_CHAR:
	MOV	DX,OFFSET TCHAR		;POINTS TO CHAR JUST READ
	CALL	WRITE1			;write it to std output
	CMP	[TCHAR],CR	;COMPARE CHAR READ TO CARR RET
	JZ	HANDLE_CR	;if so make sure it is paired with lf
	JMP	SHORT READ_CHAR		;read next char
;
;	make sure carr ret is followed by a linefeed
;
HANDLE_CR:
	MOV	DX,OFFSET LINEFEED	;point to linefeed
	CALL 	WRITE1		;write a linefeed to go with carr ret
	CALL 	READ1		;get the next char to make sure that
;the carr ret was not already paired with a linefeed
	CMP	[TCHAR],LF	;is next char a linefeed
	JNZ	SAVE_CHAR	;if not a linefeed process normally
	JMP	SHORT	READ_CHAR	;if it is a lf read the next char
					; linefeed is discarded
CRLF	ENDP
;
; Read the next char checking wether std input has run out of text
;
;
READ1	PROC	NEAR
	SUB	BX,BX		;file handle for std input
	MOV	CX,1		;loads cx with number of char to be read
	MOV	DX,OFFSET  TCHAR	;points dx to store area for char
	MOV	AH,3FH		; dos fcn call 3F hex which reads char
	INT	21H		; invokes dos to read char
	AND	AX,AX		; is the std input out of text
	JZ	DONE		;if so then finish
	RET
; **********************************
;  All text transfered - add end of file marker if none exists
;
DONE:
	CMP	[TCHAR],EOF	;was the last char read an eof marker?
	JZ	EOF_SET	 	; if yes then done
; if no then add an end of file marker to std output
	MOV	DX,OFFSET  END_OF_FILE		;points dx to store area
					;for eof marker
	CALL	WRITE1		; write char
;
;  ********************************
;  End of file is set so ret to dos
;
EOF_SET:
	MOV	AH,4CH		;DOS fcn 4C hex to terminate
	INT	21H		; invoke  DOS to end program
READ1	ENDP
;
; Write char pointed to by dx to std output
;

WRITE1	PROC	NEAR
	MOV	BX,1		; file handle for std output
	MOV	CX,BX		; number of char to  be written
	MOV	AH,40H		;DOS fcn to write a char
	INT	21H		; invoke DOS to write char
	RET
WRITE1	ENDP
CSEG	ENDS
	END	CRLF
		
o	x וag v c|kn!%3A
o	xπbxPF6`%^Z~>
 m~K3x	ao"-