;*********************************************************************;
;*                              A T C L K                            *;
;*-------------------------------------------------------------------*;
;*    Task           : This program is a clock-driver which can be   *;
;*                     used by DOS for functions which access date   *;
;*                     and time on the battery powered clock         *;
;*                     of the AT.                                    *;
;*-------------------------------------------------------------------*;
;*    assembly      : MASM ATCLK;                                    *;
;*                    LINK ATCLK;                                    *;
;*                    EXE2BIN ATCLK ATCLK.SYS                        *;
;*-------------------------------------------------------------------*;
;*    Call         : Copy into root directory place the command      *;
;*                     DEVICE=ATCLK.SYS in the CONFIG.SYS file       *;
;*                     and then boot system.                         *;
;*********************************************************************;

code     segment

	 assume cs:code,ds:code,es:code,ss:code

	 org 0                   ;Program has no PSP, therefore
				 ;beginning at offset address 0

;== Constants ========================================================

cmd_fld  equ 2                   ;Offset command-field in data block
status   equ 3                   ;Offset status field in data block
end_adr  equ 14                  ;Offset driver end-adr. in data block
num_db   equ 18                  ;Offset number in data block
b_adr    equ 14                  ;Offset buffer-address in data block

;== Data ==============================================================

;-- Header of Device-Driver -------------------------------------------

	 dw -1,-1                ;Connection to next driver
	 dw 1000000000001000b    ;Driver attribute
	 dw offset strat         ;Pointer to strategy routine
	 dw offset intr          ;Pointer to interrupt routine
	 db "$CLOCK "            ;new clock driver

db_ptr   dw (?),(?)              ;address of data block passed

mon_tab  db 31                   ;Table with number of days in 
february db 28                  ;the months 
	 db 31,30,31,30,31,31,30,31,30,31

;== Routines and functions of the Driver ==============================

strat    proc far                ;Strategy routine

	 mov  cs:db_ptr,bx       ;Record address of the data block in
	 mov  cs:db_ptr+2,es     ;the variable DB_PTR 

	 ret                     ;back to caller 

strat    endp

;----------------------------------------------------------------------

intr     proc far                ;interrupt routine

	 push ax                 ;Store registers on the stack 
	 push bx
	 push cx
	 push dx
	 push di
	 push si
	 push bp
	 push ds
	 push es
	 pushf                   ;Store the flag register 

	 cld                     ;increment for string commands 

	 push cs                 ;Set data segment register 
	 pop  ds                 ;Code is identical with data here

	 les  di,dword ptr db_ptr;Address of data block to ES:DI
	 mov  bl,es:[di+cmd_fld] ;Get command-code 
	 cmp  bl,4               ;Should Time/Date be read?
	 je   ck_read            ;YES --> CK_READ
	 cmp  bl,8               ;Should Time/Date be written?
	 je   ck_write           ;YES --> CK_WRITE
	 or   bl,bl              ;should the driver be initialized ?
	 jne  unk_fkt            ;NO --> unknown function

	 jmp  init               ;initialize driver 

unk_fkt: mov  ax,8003h           ;Code for "unknown Command"

	 ;-- Function Execution completed ---------------------------

intr_end label near
	 or   ax,0100h           ;Set finished-bit 
	 mov  es:[di+status],ax  ;store everything in status field 

	 popf                    ;Restore flag register 
	 pop  es                 ;Restore other registers 
	 pop  ds
	 pop  bp
	 pop  si
	 pop  di
	 pop  dx
	 pop  cx
	 pop  bx
	 pop  ax

	 ret                     ;back to caller 

intr     endp

;-----------------------------------------------------------------------

ck_read  proc  near              ;Read Time/Date from the clock

	 mov  byte ptr es:[di+num_db],6 ;6 bytes are passed 
	 les  di,es:[di+b_adr]   ;ES:DI points to the DOS-buffer

	 mov  ah,4         
