;**********************************************************************;
;*                           E G A V G A C A                          *;
;*--------------------------------------------------------------------*;
;*    Task           : Generates a functions for custom designing     *;
;*                     characters.                                    *;
;*--------------------------------------------------------------------*;
;*    Assembly       : MASM EGAVGACA;                                 *;
;*                     ... Link with a C program whose memory model   *;
;*                         has been set to SMALL                      *;
;**********************************************************************;
                                                                        
;== Segment declarations for the C program =============================
                                                                        
IGROUP group _text                ;Addition to program segment
DGROUP group const,_bss,  _data   ;Addition to data segment
       assume CS:IGROUP, DS:DGROUP, ES:DGROUP, SS:DGROUP
                                                                        
CONST  segment word public 'CONST';This segment includes all read-only
CONST  ends                       ;constants
                                                                        
_BSS   segment word public 'BSS'  ;This segment includes all un-initial-
_BSS   ends                       ;ized static variables
                                                                        
_DATA  segment word public 'DATA' ;This segment includes all initialized
                                  ;global and static variables
_DATA  ends
                                                                        
;== Program ============================================================
                                                                        
_TEXT  segment byte public 'CODE' ;Program segment
                                                                        
public     _chardef
                                                                        
;-----------------------------------------------------------------------
;-- CHARDEF: Defines the appearance of a character ---------------------
;-- Call from C : void chardef( BYTE ascii, BYTE table, BYTE lines,
;--                             BYTE amount, BYTE far * buf);
;-- Return value: none
                                                                        
_chardef   proc near
                                                                        
sframe     struc                  ;Stack access structure
bptr       dw ?                   ;Take BP
ret_adr    dw ?                   ;Return address of calling program
ascii      dw ?                   ;ASCII code of character
table      dw ?                   ;Number of character table
lines     dw ?                    ;Character matrix height
amount     dw ?                   ;Number of characters to be defined
bufptr     dd ?                   ;FAR pointer to buffer
sframe     ends                   ;End of structure
                                                                        
frame      equ [ bp - bptr ]      ;Addresses elements of structure
                                                                        
           push bp                ;Push BP onto stack
           mov  bp,sp             ;Transfer SP to BP
                                                                        
                                                                        
           mov  ax,1100h          ;Function no. 11(h), sub-funct. 0
           mov  bh,byte ptr frame.lines   ;Character matrix height
           mov  bl,byte ptr frame.table    ;Number of character table
           mov  cl,byte ptr frame.amount   ;Number of characters
           xor  ch,ch
           mov  dl,byte ptr frame.ascii    ;Get ASCII code of character
           xor  dh,dh
           les  bp,frame.bufptr   ;Buffer address to ES:BP
           int  10h               ;Call EGA BIOS video interrupt
                                                                        
           pop  bp                ;Pop BP off of stack
           ret                    ;Return to C program
                                                                        
_chardef   endp
                                                                        
;-----------------------------------------------------------------------
                                                                        
_text      ends                   ;End of code segment
           end                    ;End of program
