;**********************************************************************;
;*                          H C 2 F I L E                             *;
;*--------------------------------------------------------------------*;
;*    Task           : Outputs the Hardcopy of an 80-column-text      *;
;*                     screen in a file instead of the printer.       *;
;*                     The file must have a three digit number        *;
;*                     as extension which is incremented after        *;
;*                     the output of the hard copy so that several    *;
;*                     hard copy files can be created in succession   *;
;*--------------------------------------------------------------------*;
;*    WARNING        : after installation of this program             *;
;*                     no hard copy may be called during              *;
;*                     a diskette or hard disk access.                *;
;*                     The system will crash since DOS is not         *;
;*                     reentrant!                                     *;
;*--------------------------------------------------------------------*;
;*    assembly       : MASM HC2FILE;                                  *;
;*                     LINK HC2FILE;                                  *;
;*                     EXE2BIN HC2FILE HC2FILE.COM                    *;
;*--------------------------------------------------------------------*;
;*    Call         : HC2FILE [(Dr:(Path)Filename.zzz]                *;
;**********************************************************************;

;== here starts the actual Program ==============================

code      segment para 'CODE'     ;definition of the CODE-segment

          org 100h

          assume cs:code, ds:code, es:code, ss:code

start:    jmp  hcinit             ;Call of the initialization-routine

;== Data (remain in storage) ========================================

alterint  equ this dword          ;old Interrupt vector 05(h)
intaltofs dw (?)                  ;offset address Interrupt vector 05(h)
intaltseg dw (?)                  ;segment address Interrupt vector 05(h)

print     db 0                    ;indicates if printing is in progress
handle    dw (?)                  ;key for access to File

hcerr     db "HC2FILE: Error on output of the hard copy",13,10,"$"

;== this is the new hard copy interrupt (remains in memory ) ==========

newint    proc far

          jmp  short newhc

          db "RL"                 ;Identification of the program

newhc:    sti                     ;interrupts are again permitted 
          cmp cs:print,0          ;printing in progress?
          je  dohc                ;NO --> print out 
          jmp newhcend            ;YES --> do not output hard copy 

dohc:     mov  cs:print,1         ;print now 
          push ax                 ;save all registers which are changed
          push bx                 
          push cx
          push dx
          push di
          push si
          push es
          push ds

          mov  ax,cs              ;bring CS to AX 
          mov  ds,ax              ;and then set DS and ES 
          mov  es,ax
          cld                     ;on string commands count up 

          mov  ah,15              ;read current display page 
          int  10h                ;call BIOS video-interrupt 
          mov  ah,3               ;read current cursor-position 
          int  10h                ;call BIOS video-interrupt 
          push dx                 ;store on the stack 

          mov  ah,3Ch             ;create function number for file 
          xor  cx,cx              ;should become normal file 
          mov  dx,130             ;filename at DS:130 
          int  21h                ;call DOS-interrupt 21(h) 
          jc   error              ;carry-flag set --> Error 

          mov  handle,ax          ;save handle of the file 

          mov  bl,-1              ;begin with line 0 
nextline: inc  bl                 ;increment line number 
          cmp  bl,25              ;all lines printed ?
          je   datclose           ;YES --> close file 
          call hcline             ;NO --> output a line 
          jnc  nextline           ;no error --> next line

          mov  ah,3Eh             ;close function nr. for file 
          mov  bx,handle          ;access-key 
          int  21h                ;call DOS-interrupt 21(h) 
          mov  ah,41h             ;erase function nr. for file 
          mov  dx,130             ;filename at DS:130 
          int  21h                ;call DOS-interrupt 21(h) 

error:   mov  dx,offset hcerr    ;offset address of error message 
          mov  ah,9               ;output function nr. for string 
          int  21h                ;call DOS-interrupt 21(h) 
          jmp  short restore

          ;-- all lines output successfully -----------------------

datclose: mov  ah,3Eh             ;close function nr. for file 
          mov  bx,handle          ;access-key 
          int  21h                ;call DOS-interrupt 21(h) 
          jc   error              ;not closed --> Error 

          mov  bx,128             ;address of number of command line 
          mov  bl,[bx]            ;number of characters in command line 
          add  bl,128             ;calculate end address of the character 
          xor  bh,bh              ;Hi-Byte of the address is 0
          inc  byte ptr [bx]      ;increment last number 
          cmp  byte ptr [bx],":"  ;reached ten ?
          jne  restore            ;NO --> RESTORE
          mov  byte ptr [bx],"0"  ;set one number back to 0
          inc  byte ptr [bx-1]    ;increment ten number 
          cmp  byte ptr [bx-1],":";has hundred been reached ?
          jne  restore            ;NO --> RESTORE
          mov  byte ptr [bx-1],"0";ten number set back to 0 
          inc  byte ptr [bx-2]    ;increment  number 
          cmp  byte ptr [bx-2],":";has one thousand been reached?
          jne  restore            ;NO --> RESTORE
          mov  byte ptr [bx-2],"0";whole number is again 0

restore:  pop  dx                 ;get old cursor-position 
          mov  ah,2               ;and set again 
          int  10h                ;call BIOS video-interrupt 

          mov  print,0            ;hard copy output finished 
          pop  ds                 ;restore all stored registers 
          pop  es                 
          pop  si
          pop  di
          pop  dx
          pop  cx
          pop  bx
          pop  ax
newhcend: iret                    ;back to keyboard routine

newint    endp

;-- HCLINE: Write a display line into the file ----------------
;-- Input    : BL = the number of the line
;--            BH = the number of the display page
;-- Output   : Carry-flag = 1 : Error 
;-- Register : AX, CX, DX, SI, DI and FLAGS are changed

hcline    proc near

          push bx                 ;store BX on the stack 

          xor  di,di              ;copy at start of PSP 
          xor  dl,dl              ;start with column 0 
          mov  si,80              ;process 80 columns 

getc:     mov  ah,2               ;set function number for cursor 
          mov  dh,bl              ;display line to DH
          int  10h                ;call BIOS video-interrupt 
          mov  ah,8               ;read function number for character 
          int  10h                ;call BIOS video-interrupt 
          stosb                   ;store character in the buffer 
          inc  dl                 ;increment column 
          dec  si                 ;all column processed ?
          jne  getc               ;NO --> get next character 

          mov  ah,40h             ;function nr. for writing 
          mov  bx,handle          ;access key 
          mov  cx,80              ;every line has 80 bytes
          xor  dx,dx              ;offset address of the buffer is 0
          int  21h                ;call DOS-interrupt 21(h) 

          pop  bx                 ;restore BX 
          ret                     ;back to caller 

hcline   endp


instend   equ this byte           ;if HC2FILE is installed, the memory 
                                  ;can be released starting here

;== Data (can be overwritten by DOS) ========================

installm  db 13,10,"HC2FILE (c) 1987 by Michael Tischer",13,10,10
          db "HC2FILE was installed and can be ",13,10
          db "be deactivated with a new call (without parameter) ",13,10
          db "A new call with parameters changes the ",13,10
          db "Name of the file into which hard copy is output.",13,10,"$"
entfernt  db "HC2FILE was deactivated",13,10,"$"
ninstall  db "HC2FILE was not yet installed",13,10,"$"
newnam    db "HC2FILE was already installed, only filename "
          db "was changed",13,10,"$"

;== Program (can be overwritten by DOS) =======================

;-- Start and Initialization-Routine ---------------------------------

hcinit    proc near

          mov  si,128             ;address of the command line in PSP
          cmp  byte ptr [si],0    ;was parameter passed 
          mov  ax,3505h           ;get content of the interrupt vector 5 
          int  21h                ;call DOS-function (flags remain)
          jne  install            ;NO --> install program 

          ;-- HC2FILE deactivate again ------------------------------

          cmp  word ptr es:[bx+2],"LR" ;test if HC2FILE
          je   away               ;YES --> remove again 

          mov  dx,offset ninstall ;was not yet installed 
          mov  al,1               ;end-code: error 
          jmp  short hcfend1      ;terminate program 

away:     mov  dx,es:intaltofs    ;offset address of interrupt 5
          mov  ax,es:intaltseg    ;segment address of interrupt 5
          mov  ds,ax              ;to DS
          mov  ax,2505h           ;set content of the interrupt  
          int  21h                ;vector 5 to old routine again 

          mov  ah,49h             ;release the memory of old 
          int  21h                ;HC2FILE again 

          push cs                 ;store CS on the stack 
          pop  ds                 ;restore DS 
          mov  dx,offset entfernt ;message: program removed 
hcfend:   xor  al,al              ;end-code: everything o.k.
hcfend1:  mov  ah,9               ;output function number for string 
          int  21h                ;call DOS-function 
          mov  ah,4Ch             ;function nr. for prg.termination 
          int  21h                ;end program with end-code 

          ;-- install HC2FILE  -------------------------------------

install:  cmp  word ptr es:[bx+2],"LR" ;test if HC2FILE
          jne  newinst            ;NO --> first installation

          ;-- was already installed, change only filename -------------

          mov  cl,[si]            ;number of characters in the command line
          inc  cl                 ;also the number of characters 
          xor  ch,ch              ;erase HI-Byte 
          mov  di,128             ;also ES:DI, but in old HC2FILE
          cld                     ;on string commands count up 
          rep  movsb              ;copy filename in PSP 
                                  ;of the old HC2FILE 
          xor  al,al              ;NUL terminates the filename
          stosb                   ;store in PSP of the old HC2FILE 
          mov  dx,offset newnam   ;offset address of the message 
          jmp  short hcfend       ;terminate program 

newinst:  mov  intaltseg,es       ;store segment and offset  
          mov  intaltofs,bx       ;address of the interrupt vector 05(h) 

          mov  bl,[si]            ;number of the characters in the command line 
          add  bl,129             ;calculate end address of the character 
          xor  bh,bh              ;Hi-Byte of the address is 0
          mov  byte ptr [bx],0    ;set NUL behind the file name 

          mov  dx,offset newint   ;offset address new interrupt-routine
          mov  ax,2505h           ;deflect content of the interrupt 
          int  21h                ;vector 5 to user routine 

          mov  dx,offset installm ;message: program installed 
          mov  ah,9               ;output function number for string 
          int  21h                ;call DOS-function 

          ;-- only the PSP, the new interrupt-routine and the ----------
          ;-- Data pertaining to it must remain resident.

          mov  dx,offset instend  ;calculate number of paragraphs 
          mov  cl,4               ;(each 16 Bytes) available to  
          shr  dx,cl              ;the Program 
          inc  dx
          mov  ax,3100h           ;terminate program with end-code 0 (o.k) 
          int  21h                ;but remain resident 

hcinit    endp

;== End ===============================================================

code      ends                    ;End of the CODE-segment
          end  start
