;*********************************************************************;
;*                               M A C R O                           *;
;*-------------------------------------------------------------------*;
;*    Task          : in this Program a Macro is used for output     *;
;*                    of a String with Function 9 of Interrupt 21(h) *;
;*-------------------------------------------------------------------*;
;*    assembly      : MASM MACRO;                                    *;
;*                  : LINK MACRO;                                    *;
;*-------------------------------------------------------------------*;
;*    Call:         : MACRO                                          *;
;*********************************************************************;

;== Macro =============================================================

Print     macro String            ;this is the macro

          mov ah,9                ;load function number 
          mov dx,offset String    ;load offset address of text
          int 21h                 ;call DOS interrupt

          endm                    ;End of macro

;== Constants =========================================================

CR        equ 13                  ;ASCII-Code of carriage return
LF        equ 10                  ;ASCII-Code of linefeed
TEND      equ "$"                 ;End of a character string 

;== Data ==============================================================

Data segment

Text      db CR,LF,"This is how MACROS are used",CR,LF,TEND

Data ends

;== stack =============================================================

stack segment STACK

          dw 64 dup (?)

stack ends

;== Code ==============================================================

Program  segment

          assume CS:Program, DS: Data, SS:stack

Start     proc far              ;program starts here 

          mov  ax,Data          ;set data segment register 
          mov  ds,ax

          Print Text            ;Macro inserted here 

          mov  ax,4C00h         ;Program terminated with call of a  
          int  21h              ;DOS function with return of error-code 0

Start     endp                  ;End of procedure 

;======================================================================

Program  ends
          end Start             ;begin with START 
