;*********************************************************************;
;*                                M O V E A                          *;
;*-------------------------------------------------------------------*;
;*    Task           : copies data between RAM below 1 MB and        *;
;*                     above 1 MB                                    *;
;*-------------------------------------------------------------------*;
;*    assembly       : MASM MOVEA;                                   *;
;*                     LINK MOVEA;                                   *;
;*                     EXE2BIN MOVEA MOVEA.COM                       *;
;*-------------------------------------------------------------------*;
;*    Call            : MOVEA                                        *;
;*********************************************************************;

;== BIOS-segment ======================================================

bios      segment at 0F000h       ;used for Addressing of the 
				  ;Device-Codes

	  org 0FFFEh              ;Address of the Device-Codes in BIOS
gercode   equ this byte

bios      ends                    ;End of the BIOS-segments

;== Code-segment ======================================================

code      segment para 'CODE'     ;Definition of the CODE-segment

	  org 100h                ;it begins at Address 100(h)
				  ;directly after the PSP

	  assume cs:code, ds:code, es:bios, ss:code

;== Program ===========================================================

movea     proc near

	  ;-- Output Initiation Message ------------------------------

	  mov  dx,offset initm    ;Offset address of the Init message 
	  mov  ah,9               ;output Function number for String 
	  int  21h                ;Call DOS-Interrupt 

	  mov  ax,0F000h          ;segment address of BIOS
	  mov  es,ax              ;to ES
	  cmp  es:gercode,0FCh    ;is the device an AT
	  je   isat               ;YES --> continue to execute Program 

	  ;-- Device is PC or XT, Program does not run  ---------------

	  mov  dx,offset sorrym   ;Offset address of Text 
	  jmp  short pcxt         ;Output message and terminate program  

	  ;-- User must activate a key to start the program

isat:     mov  dx,offset dom      ;Offset address of the Text
	  mov  ah,9               ;output function number for String 
	  int  21h                ;call DOS-Interrupt 

	  xor  ah,ah              ;read a character from the keyboard 
	  int  16h                ;call BIOS-Keyboard-Interrupt 

	  ;-- Move Video-RAM to 1 MB --------------------------

	  call getvseg            ;Get segment address of Video-RAM 
	  mov  di,ax              ;and move to DI 
	  xor  si,si              ;copy starting at Offset address 0 

	  xor  bx,bx              ;copy after 1MB + 0000:0000 
	  mov  es,bx
	  mov  ch,1               ;from below 1 MB to above 1 MB
	  mov  ax,2000            ;move 2000 
	  call move               ;Words 
	  jc   error             ;on error terminate

	  ;-- Fill Video-RAM with characters --------------------------

	  call getvseg            ;Get segment address of the Video-RAM 
	  mov  es,ax              ;and move to ES 
	  xor  di,di              ;start at Offset address 0 
	  mov  cx,2000            ;fill the complete Video-RAM with 
	  mov  ax,87FEh           ;blinking Block-Character 
	  rep  stosw              

	  ;-- User must activate a key --------------------------

	  mov  dx,offset userm    ;Offset address of the Text
	  mov  ah,9               ;output function number for String 
	  int  21h                ;call DOS-Interrupt 

	  xor  ah,ah              ;read a character from the keyboard 
	  int  16h                ;call BIOS-Keyboard-Interrupt 

	  ;-- Restore Video-RAM again --------------------------

	  xor  di,di              ;restore 1 MB + 0000:0000 
	  xor  si,si
	  xor  bx,bx
	  mov  ch,10b             ;from beyond 1 MB to below 1 MB
	  mov  ax,2000            ;move 2000 
	  call move               ;Words 
	  jc   error             ;terminate on error 

	  mov  ax,4C00h           ;terminate Program with call of a DOS 
	  int  21h                ;function on return of Error-Code 0

error:   mov  dx,offset errm      ;Offset address of  error message 
pcxt:     mov  ah,9               ;output function number for String 
	  int  21h                ;call DOS-Interrupt 
	  mov  ax,4C01h           ;terminate Program with call of a DOS 
	  int  21h                ;function on return of Error-Code 1

movea     endp

;-- GETVSEG: returns the segment address of the Video-RAM ------------
;-- Input  : none
;-- Output  : AX = segment address of the Video-RAM
;-- Register : AX, BH and FLAGS are changed 

getvseg   proc near

	  mov  ah,0FH              ;get function number for Video  
	  int  10h                 ;call BIOS-Video-Interrupt 
	  cmp  al,7                ;is a Mono-Card installed?
	  jne  colvideo            ;NO --> Color-Card

	  mov  ax,0B000h           ;segment addr. of the mono Video-RAM
	  ret                      ;back to caller 

colvideo: mov  ax,0B800h           ;segment addr. of color Video-RAM
	  ret                      ;back to caller 

getvseg   endp

;-- MOVE: Moves Data between Storage above and below 1 MB -------
;-- Input  : DI:SI = Sourceaddress (if above 1 MB as Offset to 1 MB)
;--            ES:BX = Dest. address (if above 1 MB as Offset to 1 MB)
;--            CH    = move ... from --> to 
;--                    00b = from below 1 MB --> to below 1 MB
;--                    01b = from below 1 MB --> to above 1 MB
;--                    10b = from above 1 MB  --> to below 1 MB
;--                    11b = from above 1 MB  --> to above 1 MB
;--            AX    = Number of words to be moved  (max. 08000h)
;-- Output  : Carry-Flag = 1 : Error
;-- Register : AX, BX, DL, CL, SI, ES and FLAG are changed 
;-- Info     : this function should not be used for moving 
;--            from RAM below the 1 MB limit 

move      proc near

	  push ax                  ;record number of Words on the Stack 
	  mov  ax,es               ;Destination segment address to AX
	  test ch,1                ;is Destination above 1 MB?
	  call calc_adr            ;form 24 bit Address 
	  mov  da_hi,dl            ;store result 
	  mov  da_lo,ax
	  mov  ax,di               ;Source segment address to AX
	  mov  bx,si               ;Source Offset address to BX
	  test ch,2                ;is Source above 1 MB?
	  call calc_adr            ;form 24 bit Address 
	  mov  sa_hi,dl            ;store result 
	  mov  sa_lo,ax
	  mov  ah,087h             ;Parameter for the Function call 
	  push ds                  ;load 
	  pop  es                  ;set ES to DS 
	  pop  cx                  ;read number of Words from Stack 
	  mov  si,offset GDT       ;load Offset address of GDT 
	  int  15h                 ;call RAM move function 
	  ret                      ;back to caller 

;-- Variables and Data of the MOVE-Function ---------------------------

GDT       equ this word

	  ;-- THIS IS THE GDT (GLOBAL DESCRIPTOR TABLE) ---------------
	  dw 4 dup (?)             ;segment Descs. for Dummy-segment
	  ;-- this segment Descriptor describes the GDT itself ------
	  dw 4 dup (?)
	  ;-- segment Descriptor of the Source-Area -------------------
	  dw 0ffffh                   ;segment length = 64 KB
sa_lo     dw (?)                      ;Lo-Word of the 24 bit-Address
sa_hi     db 010h                     ;Hi-Byte of the 24 bit-Address
	  db 10010010b                ;Data segment in storage with 
				      ;highest Priority, Writeable
	  dw 00000h                   ;Compatibility Word for 80386
	  ;-- segment Descriptor of the Destination-Area --------------
	  dw 0ffffh                   ;segment length = 64 KB
da_lo     dw (?)                      ;Lo-Word of the 24 bit-Address
da_hi     db (?)                      ;Hi-Byte of the 24 bit-Address
	  db 10010010b                ;Data segment in storage with 
				      ;highest Priority, Writeable
	  dw 00000h                   ;Compatibility Word for 80386
	  ;-- this segment Descriptor describes the BIOS-Code-segment
	  dw 4 dup (?)
          ;-- this segment Descriptor describes the Stack segment ----
	  dw 4 dup (?)
	  ;-- END OF THE GDT -----------------------------------------

move      endp

;-- CALC_ADR: calculates 24 bit (physical) Address ------------------
;-- Input  : AX:BX = Buffer address to be converted
;--            Zero Flag = 1 : Buffer address above 1 MB
;-- Output  : DL = HI-Byte of the Buffer address (bit 16-23)
;--          : BX = Lo-Word of the Buffer address (bit 0-15)
;-- Register : AX, BX, DL, CL and FLAGS are changed 

calc_adr  proc near

	  mov  dl,ah                ;Hi-Byte of the segment address to DL
	  mov  cl,4                 ;Hi-Nibble of the segment address
	  shr  dl,cl                ;shifted to Lo-Nibble 
	  jne  under_1mb            ;test if above 1 MB

	  or   dl,010h              ;lies above 1 MB

under_1mb:shl  ax,cl                ;segment address times 16
	  add  ax,bx                ;add Offset address 
	  jnc  no_more             ;test for overflow 

	  inc  dl                   ;yes 

no_more: ret                       ;back to caller 

calc_adr  endp

;== Data  ============================================================

initm     db 13,10,"MOVE (c) 1987 by Michael Tischer",13,10,13,10
	  db "This Program uses the Function 87(h) of Interrupt "
	  db "15(h) to copy memory blocks",13,10,"between 'normal' "
	  db "RAM and RAM above the 1-Megabyte boundary.",13,10,"$"

dom       db "The Program copies first the current display "
	  db "content directly",13,10,"after the 1-MB-boundary and "
	  db "the fills the screen with characters.",13,10
	  db "After a key has been activated, the old "
	  db "display content ",13,10,"is restored and the Pro"
	  db "gram terminated.",13,10,"Please press a key, to "
	  db "start the Program ...$"

sorrym    db "Since this computer is not an AT, "
	  db "but a PC or",13,10,"XT, and these "
	  db "PCs can not have storage beyond the 1-MB limit,"
	  db 13,10,"this program can not be started! "
	  db "Sorry...",13,10,"$"

userm     db 13,10,"                            Please press a  "
	  db "key $"

errm      db "WARNING ! Error on access to RAM above 1 MB"
	  db 13,10,"$"

;== End ===============================================================

code      ends                    ;End of the CODE-segment
	  end movea               ;End of the Assembler-Program.
