;*********************************************************************;
;*                               M O V E B A                         *;
;*-------------------------------------------------------------------*;
;*    Task   : Makes the functions for moving of                     *;
;*             memory blocks beyond the 1MB memory limit             *;
;*             available in BASIC for linking                        *;
;*-------------------------------------------------------------------*;
;*    Info: the Code is fully relocatable so that the                *;
;*          Routine can be poked to any place within the             *;
;*          BASIC segment                                            *;
;*-------------------------------------------------------------------*;
;*    assembly  : MASM MOVEBA;                                       *;
;*                LINK MOVEBA;                                       *;
;*                EXE2BIN MOVEBA MOVEBA.COM                            *;
;*********************************************************************;

code      segment

          assume cs:code,ds:code,es:code,ss:code

;-- MOVE: Copy storage blocks beyond the 1MB limit --------------------
;-- Call from BASIC: CALL ADR(Sourcesegment, StartOffset, Destsegment,
;--                           DestOffset, Size, Direction);
;-- Info  : - after the call Variables are in the following 
;--                    Positions on the Stack:
;--                      Startsegment = SP + 16
;--                      StartOffset  = SP + 14
;--                      Destsegment  = SP + 12
;--                      DestOffset   = SP + 10
;--                      Size         = SP + 8
;--                      Direction    = SP + 6
;--        - for Direction the following Codes are accepted
;--                  0 = from below 1 MB --> to below 1 MB
;--                  1 = from below 1 MB --> to over 1 MB
;--                  2 = from above 1 MB  --> to below 1 MB
;--                  3 = from above 1 MB  --> to above 1 MB
;--                  - the number concerns words not 
;--               bytes, and can not be larger than 8000(h) 

move      proc far            ;GW expects during CALL Far-Procedure

          call get_adr        ;the Address of the Routine 

;-- The Global Descriptor Table ---------------------------------------
GDT       equ this word

          dw 4 dup (?)        ;segment Descriptors for Dummy-segment
          dw 4 dup (?)

      ;-- segment Descriptors of the Source-Area ----------------------
          dw 0ffffh          ;segment length = 64 KB
sa_lo     dw (?)             ;Lo-Word of the 24 bit-Address
sa_hi     db 010h            ;Hi-Byte of the 24 bit-Address
          db 10010010b       ;Data segment in memory with 
                             ;highest priority, Writeable
          dw 00000h          ;Compatibility Word for 80386

      ;-- segment Descriptors of the Destination-Area -----------------
          dw 0ffffh          ;segment length = 64 KB
da_lo     dw (?)             ;Lo-Word of the 24 bit-Address
da_hi     db (?)             ;Hi-Byte of the 24 bit-Address
          db 10010010b       ;Data segment in memory with 
                             ;highest priority, Writeable
          dw 00000h          ;Compatibility Word for 80386

          dw 4 dup (?)       ;segment Descriptors BIOS-Code-segment
          dw 4 dup (?)       ;segment Descriptors Stack-segment

;-- the Code of the MOVE-Routine --------------------------------------

move1:    push bp             ;store GW Basepointer 
          mov  bp,sp          ;move SP to BP 

          mov  di,[bp+6]      ;get Address of the direction Variable 
          mov  ch,[di]        ;move direction to CH 
          mov  di,[bp+12]     ;get Address of Destsegment-Variable 
          mov  ax,[di]        ;move destination segment address to AX
          mov  di,[bp+10]     ;get address of DestOffset-Variable 
          mov  bx,[di]        ;move destination Offset address to BX
          test ch,1           ;Destination beyond 1 MB?
          call calc_adr       ;form 24 bit Address 

          mov  [si+da_hi-gdt],dl   ;store result 
          mov  [si+da_lo-gdt],ax

          mov  di,[bp+16]        ;get address of the Startsegment-Variable
          mov  ax,[di]           ;move Source segment address to mov     
          mov  di,[bp+14]        ;get Address of StartOffset-Variable 
          mov  bx,[di]           ;Source Offset address to BX
          test ch,2              ;is Source beyond 1 MB?
          call calc_adr          ;form 24 bit Address 
          mov  [si+sa_hi-gdt],dl ;store result 
          mov  [si+sa_lo-gdt],ax
          mov  ah,087h           ;Parameter for the Function call 
          mov  di,[bp+8]         ;get Address of the Size-Variables 
          mov  cx,[di]           ;get number of words 
          int  15h               ;call RAM-displacement function 

          mov  sp,bp             ;restore Stackpointer 
          pop  bp                ;return BP from the Stack 
          ret  12                ;Addresses of the Variables on the Stack
                                 ;are no longer required 

Move      endp

;-- GET_ADR:   returns the Offset address of the GDT ------------------
;-- Input  :   none
;-- Output  :  SI = Offset address of the GDT
;-- Register : SI is changed 

get_adr   proc near

          pop  si            ;get Address of GDT from Stack 
          jmp  short move1   ;jump to actual Routine 

get_adr   endp

;-- CALC_ADR:  calculates the 24 bit (physical) Address ---------------
;-- Input    : AX:BX = Buffer address to be converted 
;--            Zero Flag = 1 : Buffer address beyond 1 MB
;-- Output   : DL = HI-Byte of Buffer address  (bit 16-23)
;--          : BX = Lo-Word of Buffer address (bit 0-15)
;-- Register : AX, BX, DL, CL and FLAGS are changed 

calc_adr  proc near

          mov  dl,ah      ;Hi-Byte of the segment address to DL
          mov  cl,4       ;move Hi-Nibble of the segment 
          shr  dl,cl      ;address to the Lo-Nibble 
          jne  under_1mb  ;test if beyond 1 MB

          or   dl,010h    ;is beyond 1 MB

under_1mb:shl  ax,cl      ;segment address times 16
          add  ax,bx      ;add Offset address 
          jnc  no_more    ;test if excess 

          inc  dl         ;yes 

no_more: ret              ;back to caller 

calc_adr  endp

;======================================================================

code      ends
          end

