;*********************************************************************;
;*                            M O V E C A                            *;
;*-------------------------------------------------------------------*;
;*    Task  : Makes the Functions for moving of                      *;
;*            Storage blocks beyond the 1MB memory limit             *;
;*            available for inclusion in C                           *;
;*-------------------------------------------------------------------*;
;*    assembly     : MASM MOVECA;                                    *;
;*********************************************************************;

IGROUP group _text                   ;Grouping of Program-segments 
DGROUP group const,_bss,  _data      ;Grouping of Data-segments
       assume CS:IGROUP, DS:DGROUP, ES:DGROUP, SS:DGROUP

       public _AdMove ;Functions become accessible to other 
                                    ;programs 

CONST  segment word public 'CONST'  ;this segment accepts all 
CONST  ends                         ;readable Constants 

_BSS   segment word public 'BSS'    ;this segment accepts not all 
_BSS   ends                         ;initialized static Variables 

_DATA  segment word public 'DATA'   ;all initialized global and
                                    ;static Variables are stored in this 
                                    ;segment 

GDT       equ this word             ;the Global Descriptor Table

          dw 4 dup (?)              ;segment Desc. for Dummy-segment
          dw 4 dup (?)

       ;-- segment Descriptors of the Source-Area ------------------
          dw 0ffffh          ;segment length = 64 KB
sa_lo     dw (?)             ;Lo-Word of the 24 bit-Address
sa_hi     db 010h            ;Hi-Byte of the 24 bit-Address
          db 10010010b       ;Data segment in storage with 
                             ;highest Priority, Writeable
          dw 00000h          ;Compatibility word for 80386

      ;-- segment Descriptors of the Destination-Area --------------
          dw 0ffffh          ;segment length = 64 KB
da_lo     dw (?)             ;Lo-Word of the 24-bit-Address
da_hi     db (?)             ;Hi-Byte of the 24-bit-Address
          db 10010010b       ;Data segment in storage with 
                             ;highest Priority, Writeable
          dw 00000h          ;Compatibility word for 80386

          dw 4 dup (?)       ;segment Desc. BIOS-Code-segment
          dw 4 dup (?)       ;segment Descriptors Stack-segment

_DATA  ends

_TEXT  segment byte public 'CODE' ;the Program segment

;- ADMOVE: Copy Storage Blocks beyond the 1MB limit -------------
;- Call of C: AdMove(Startsegment, StartOffset, Destsegment,
;--                      DestOffset, Size, Direction);
;-- Info : - for DIRECTION the following Codes are accepted:
;--                  0 = from below 1 MB --> to below 1 MB
;--                  1 = from below 1 MB --> to above 1 MB
;--                  2 = from above 1 MB  --> to below 1 MB
;--                  3 = from above 1 MB  --> to above 1 MB
;--               - the number relates to words, not Bytes
;--                 and can not be larger than 8000(h) 
;--               - for moving of RAM below the 1-MB border 
;--                 the Functions MOVEDATA or MEMCPY should 
;--                 be called 

_AdMove   proc near

          push bp                   ;store BP on the Stack 
          mov  bp,sp                ;move SP to BP 
          push si                   ;C expects unchanged SI
          mov  ch,[bp+14]           ;move Direction to CH 
          mov  ax,[bp+8]            ;Destination segment address to AX
          mov  bx,[bp+10]           ;Destination Offset address to BX
          test ch,1                 ;is Destination beyond 1 MB?
          call calc_adr             ;form 24 bit Address 
          mov  da_hi,dl             ;store result 
          mov  da_lo,ax
          mov  ax,[bp+4]            ;Source segment address to AX
          mov  bx,[bp+6]            ;Source Offset address to BX
          test ch,2                 ;is Source beyond 1 MB?
          call calc_adr             ;form 24 bit Address 
          mov  sa_hi,dl             ;store result 
          mov  sa_lo,ax 
          mov  ah,087h              ;Parameter for the Function call 
          push ds                   ;load 
          pop  es                   ;st ES to DS 
          mov  cx,[bp+12]           ;get number of Words 
          mov  si,offset DGROUP:GDT ;load Offset address of GDT 
          int  15h                  ;call RAM moving functions

          pop  si                   ;restore old SI from Stack 
          mov  sp,bp                ;restore Stackpointer 
          pop  bp                   ;get BP from Stack 
          ret                       ;Return to calling C-Program

_AdMove  endp

;-- CALC_ADR: calculates 24 bit (physical) Address -----------------
;-- Input  : AX:BX = Buffer address to be converted
;--            Zero Flag = 1 : Buffer address beyond 1 MB
;-- Output : DL = HI-Byte of the Buffer address (bit 16-23)
;--        : BX = Lo-Word of the Buffer address (bit 0-15)
;-- Register : AX, BX, DL, CL and FLAGS are changed 

calc_adr  proc near

          mov  dl,ah                ;Hi-Byte of segment address to DL
          mov  cl,4                 ;move Hi-Nibble of segment address
          shr  dl,cl                ;into the Lo-Nibble 
          jne  under_1mb            ;test if beyond 1 MB

          or   dl,010h              ;beyond 1 MB

under_1mb:shl  ax,cl                ;segment address times 16
          add  ax,bx                ;add Offset address 
          jnc  no_more              ;test if overflow 

          inc  dl                   ;yes 

no_more: ret                        ;back to caller 

calc_adr  endp

;----------------------------------------------------------------

_text    ends                      ;End of the Program-segment
         end                       ;End of the Assembler-Source

