;*********************************************************************;
;*                           M O V E P A                             *;
;*-------------------------------------------------------------------*;
;*    Task  : copies data between the RAM below 1 MB and             *;
;*            above 1 MB                                             *;
;*            CAUTION! This is the version for linking               *;
;*                     in a Pascal program with INLINE-              *;
;*                     commands                                      *;
;*-------------------------------------------------------------------*;
;*    Assembly     : MASM MOVEPA;                                    *;
;*                   LINK MOVEPA;                                    *;
;*                   convert to INLINEs and add to Turbo Pascal      *;
;*********************************************************************;

;== Code-segment ======================================================

code   segment para 'CODE'  ;Definition of the CODE-segment

          org 100h          ;it begins at Address 100(h)
                            ;directly behind the PSP

          assume cs:code, ds:code, es:code, ss:code

;== Program ===========================================================

;--Call:  HiMoves(StartSeg,
;--               StartOfs,
;--               DestSeg,
;--               DestOfs,
;--               NumWords,
;--               Direction : word);
;-- This routine is designed as a FAR call model

movepa    proc near

sframe    struc             ;Access structure on stack
bptr      dw ?              ;Taken by BP
ret_adr   dd ?              ;Return address (FAR)
directn   dw ?              ;Copy direction
numwords  dw ?              ;Number of words being copied
destofs   dw ?              ;Destination buffer's offset address
destseg   dw ?              ;Destination buffer's segment address
startofs  dw ?              ;Starting buffer's offset address
startseg  dw ?              ;Starting buffer's segment address
sframe    ends              ;End of structure

frame     equ [ bp - bptr ] ;For stack addressing

          push bp            ;Store BP on the Stack 
          mov  bp,sp         ;Move SP to BP 

          mov  di,frame.startseg ;Get source segment from stack 
          mov  si,frame.startofs ;Get source offset from stack 
          mov  ax,frame.destseg  ;Get destination segment from stack 
          mov  es,ax             ;and move to ES 
          mov  bx,frame.destseg  ;Get destination offset from stack 
          mov  ax,frame.numwords ;Get numwords from stack 
          mov  cx,frame.directn  ;Get direction from stack 
          mov  ch,cl            ;and send to CH 
          push bp               ;Mark BP
          call getgdt          ;Determine address of GDT 

;-- Variables and Data of the MOVE-Function ---------------------------

GDT       equ this word

    ;-- THIS IS THE GDT (GLOBAL DESCRIPTOR TABLE) ---------------------
          dw 4 dup (?)     ;segment Desc. for Dummy-segment
          ;-- this segment Descriptor describes the GDT itself --------
          dw 4 dup (?)
          ;-- segment Descriptor of the Source-Area -------------------
          dw 0ffffh          ;segment length  = 64 KB
sa_lo     dw (?)             ;Lo-Word of the 24 bit-Address
sa_hi     db 010h            ;Hi-Byte of the 24 bit-Address
          db 10010010b       ;Data segment in storage with 
                             ;highest Priority, Writeable
          dw 00000h          ;Compatibility Word for 80386
          ;-- segment Descriptor of the Destination-Area --------------
          dw 0ffffh          ;segment length = 64 KB
da_lo     dw (?)             ;Lo-Word of the 24 bit-Address
da_hi     db (?)             ;Hi-Byte of the 24 bit-Address
          db 10010010b       ;Data segment in storage with
             ;highest Priority, Writeable
          dw 00000h          ;Compatibility Word for 80386
          ;-- this segment Descriptor describes the BIOS-Code-segment
          dw 4 dup (?)
          ;-- this segment Descriptor describes the Stacksegment ------
          dw 4 dup (?)
          ;-- END OF THE GDT ------------------------------------------

;-- MOVE: Moves Data between memory above and below 1 MB --------------
;-- Input : DI:SI = Source address (if above 1 MB as Offset to 1 MB)
;-- ES:BX = Dest. address (if above 1 MB as Offset to 1 MB)
;--            CH    = move ... from --> to 
;--                 00b = from below 1 MB --> to below 1 MB
;--                 01b = from below 1 MB --> to above 1 MB
;--                 10b = from above 1 MB  --> to below 1 MB
;--                 11b = from above 1 MB  --> to above 1 MB
;--                 AX  = Number of words to be moved (max. 08000h)
;-- Output  : Carry-Flag = 1 : Error 
;-- Register : AX, BX, DL, CL, SI, ES and FLAG are changed 
;-- Info : This function should not be used to move RAM below the
;              1-MB boundary
move:     push ax             ;Store number of words on the Stack 
          mov  ax,es          ;Destination segment address to AX
          test ch,1           ;is destination above 1 MB?
          call calc_adr       ;form 24 bit Address 
          mov  cs:[bp+28],dl  ;store result 
          mov  cs:[bp+26],ax
          mov  ax,di          ;Source segment address to AX
          mov  bx,si          ;Source Offset address to BX
          test ch,2           ;is Source above 1 MB?
          call calc_adr       ;form 24 bit Address 
          mov  cs:[bp+20],dl  ;store result 
          mov  cs:[bp+18],ax
          mov  ah,087h        ;load Parameter for function call 
          push cs                  
          pop  es             ;set ES to CS 
          pop  cx             ;Get number of Words from Stack 
          mov  si,bp          ;load Offset address of GDT 
          int  15h            ;call RAM moving function 
          jmp short ende      ;back to Turbo


movepa   endp

;-- GETGDT: Get Address of the GDT and jump to MOVE -------------------
;-- Input  : none
;-- Output  : CS:BP = Address of the GDT
;-- Register : only BP is changed
;-- Info : this Routine can only be used in the environment
;--            of this Program

getgdt    proc near

          pop  bp             ;Get Address of GDT from the Stack 
          jmp  short move     ;Jump to MOVE-Routine 

getgdt    endp

;-- CALC_ADR: calculates 24 bit (physical) Address --------------------
;-- Input    : AX:BX = Buffer address to be converted
;--            Zero Flag = 1 : Buffer address beyond 1 MB
;-- Output : DL = HI-Byte of the Buffer address (bit 16-23)
;--        : BX = Lo-Word of the Buffer address (bit 0-15)
;-- Register : AX, BX, DL, CL and FLAGS are changed 

calc_adr  proc near

          mov  dl,ah      ;Hi-Byte of segment address to DL
          mov  cl,4       ;shift Hi-Nibble of segment 
          shr  dl,cl      ;address into Lo-Nibble 
          jne  under_1mb  ;test if above 1 MB

          or   dl,010h    ;is above 1 MB

under_1mb:shl  ax,cl      ;segment address times 16
          add  ax,bx      ;add Offset address to it 
          jnc  no_more    ;test if overflow 

          inc  dl         ;yes 

no_more: ret              ;back to caller 

calc_adr  endp

ende      label near       ;Code stops here 
          pop bp           ;Restore BP from atack 


;== End ===================================================================

code      ends              ;End of the CODE segment
          end  movepa       ;End of the assembler program


