;*********************************************************************;
;*                               P E P O                             *;
;*-------------------------------------------------------------------*;
;*    Task        : Makes the PEEKB and POKEB function available for *;
;*                  inclusion in a C program                         *;
;*-------------------------------------------------------------------*;
;*    assemble    : MASM PEPO;                                       *;
;*********************************************************************;

IGROUP group _text                  ;Grouping of program segments
DGROUP group const,_bss,  _data     ;Grouping of data segments
       assume CS:IGROUP, DS:DGROUP, ES:DGROUP, SS:DGROUP

       public _PeekB                ;Functions become accessible to
       public _PokeB                ;other programs

CONST  segment word public 'CONST'  ;this segment accepts all constants
CONST  ends                         ;which are readable

_BSS   segment word public 'BSS'    ;this segment accepts all non-
_BSS   ends                         ;initialized static variables

_DATA  segment word public 'DATA'   ;all initialized global and
_DATA  ends                         ;static variables are stored in this
                                    ;segment

_TEXT  segment byte public 'CODE'   ;the Program segment

;-- PEEKB: read a byte from memory -----------------------------
;-- call of C: int = PeekB(int Segment, int Offset)

_PeekB   proc near

         push bp                    ;store BP on the stack
         mov  bp,sp                 ;transmit SP to BP
         push ds                    ;store data segment register
         mov  ax,[bp]+4             ;get first argument (Segment)
         mov  ds,ax                 ;set as data segment
         mov  bx,[bp]+6             ;get second argument (Offset)
         mov  al,[bx]               ;read memory location
         xor  ah,ah                 ;HI-byte of INT to 0
         jmp  short fctend          ;terminate function

_PeekB   endp

;-- POKEB: write a byte into memory --------------------------
;-- Call C: PokeB(int Segment, int Offset, short int Wert)

_PokeB   proc near

         push bp                    ;store BP on the stack
         mov  bp,sp                 ;transmit SP to BP
         push ds                    ;store data segment register
         mov  ax,[bp]+4             ;Get first argument (Segment)
         mov  ds,ax                 ;Set as data segment
         mov  bx,[bp]+6             ;Get second argument (Offset)
         mov  al,[bp]+8             ;Get third argument (Value)
         mov  [bx],al               ;write into memory location
fctend:  pop  ds                    ;Return data segment register
         mov  sp,bp                 ;Restore stack pointer
         pop  bp                    ;Get BP from stack
         ret                        ;Return to calling C program

_PokeB   endp

;----------------------------------------------------------------------

_text    ends                       ;End of the program segment
         end                        ;End of the assembler source
