;********************************************************************;
;*                             P E R M C L K                        *;
;*------------------------------------------------------------------*;
;*    Task           : displays the current time on the             *;
;*                     display Screen                               *;
;*------------------------------------------------------------------*;
;*    assembly       : MASM PERMCLK;                                *;
;*                     LINK PERMCLK;                                *;
;*                     EXE2BIN PERMCLK PERUMCLK.COM                 *;
;*------------------------------------------------------------------*;
;*    Call            : PERMCLK                                     *;
;********************************************************************;

;== Constants =========================================================

    CLKCOLUMN = 72                ;line and column in which the time
    CLKLINE   = 0                 ;is displayed 
    CLKNUM    = 6                 ;after how many 1/18 S. is the clock displayed
    CLKCOLOR  = 70h               ;color of the clock: inverted

;== here starts the actual Program ==============================

code      segment para 'CODE'     ;Definition of the CODE-segment

	  org 100h

	  assume cs:code, ds:code, es:code, ss:code

start:    jmp  perminit           ;Call of the initialization routine

;== Data (remain in memory ) ========================================

alterint  equ this dword          ;old interrupt vector 1C(h)
intaltofs dw (?)                  ;offset address interrupt vector 1C(h)
intaltseg dw (?)                  ;segment address interrupt vector 1C(h)

time      equ this byte           ;accepts the current time
tenhours  db (?)                  ;10 hours as ASCII
onehour   db (?)                  ;one hours as ASCII
	  db ":"
tenmint   db (?)                  ;ten minutes as ASCII
onemin    db (?)                  ;one minutes as ASCII
	  db ":"
tensecs   db (?)                  ;ten seconds as ASCII
onesec    db (?)                  ;one seconds as ASCII

tcount    db 18                   ;decremented on every timer-call
numcount  db CLKNUM               ;display counter for clock 
count1    db 5                    ;correction counter 1
count2    db 31                   ;correction counter 2


;== this is the new keyboard-interrupt (remains in memory ) ==========

newint    proc far

	  jmp  short newtimer

	  db "JS"                 ;Identification of the program

newtimer: push ax                 ;record all registers which are changed
	  push bx                 ;by the program 
	  push cx
	  push dx
	  push di
	  push si
	  push es
	  push ds

	  push cs                ;store CS on the stack 
	  pop  ds                ;return as DS 


	  dec  numcount          ;decrement counter for display 
	  jne  nonum             ;not yet zero 

	  mov  numcount,CLKNUM   ;set to original value 

nonum:    dec tcount             ;already called 18 times ?
	  je  nextsec            ;YES --> one Second passed
	  cmp numcount,255       ;display clock now ?
	  jne st1                ;NO --> output
	  jmp restore            ;YES --> back 

nextsec:  mov tcount,18          ;set Call-counter new 
	  dec count1             ;correction-counter1 dec. 5 times ?
	  jne settime            ;NO --> increment ASCII-time 
	  mov count1,5           ;YES --> set to 5 again 
	  inc tcount             ;increment Call-counter 
	  dec count2             ;correction-counter2 decremented 31 times?
	  jne settime            ;NO --> increment ASCII-time 
	  mov count2,31          ;YES --> set again to 31 
	  inc tcount             ;increment Call-counter 

settime:  inc onesec             ;increment one second (ASCII)
	  cmp onesec,":"         ;one second = 10?
st1:      jne output             ;NO --> output time 
	  mov onesec,"0"         ;set one second to zero
	  inc tensecs            ;increment ten second (ASCII) 
	  cmp tensecs,"6"        ;ten second = 6 (60 Seconds)?
	  jne output             ;NO --> output time 
	  mov tensecs,"0"        ;set ten seconds to zero
	  inc onemin             ;increment one minute (ASCII) 
	  cmp onemin,":"         ;one minute = 10?
	  jne output             ;NO --> output time 
	  mov onemin,"0"         ;set one minute to zero 
	  inc tenmint            ;increment ten minute (ASCII) 
	  cmp tenmint,"6"        ;ten minute = 6 (60 Minutes)
	  jne output             ;NO --> output time 
	  mov tenmint,"0"        ;set ten minute to zero 
	  inc onehour            ;increment one hour (ASCII) 
	  cmp onehour,":"        ;one hour = 10?
	  jne test24             ;NO --> test 24 hour  
	  mov onehour,"0"        ;YES --> set one hour to zero 
	  inc tenhours           ;increment ten hour (ASCII) 
	  jmp short output

test24:   cmp onehour,"4"        ;one hour = 4?
	  jne output             ;NO --> output time 
	  cmp tenhours,"2"       ;YES --> ten hour = 2?
	  jne output             ;NO --> output time 
	  mov tenhours,"0"       ;a new day started 
	  mov onehour,"0"

output:  mov  ah,15              ;read current display page 
	  int  10h               ;call BIOS video-interrupt 
	  mov  ah,3              ;read current cursor-position 
	  int  10h               ;call BIOS video-interrupt 
	  push dx                ;store on stack 

	  mov  si,offset time    ;offset address of the time-string
	  mov  cx,1              ;write each character once 
	  mov  dx,CLKLINE shl 8 + CLKCOLUMN ;cursor-position for time
	  mov  bl,CLKCOLOR       ;color of the clock
	  mov  di,8              ;8 characters are output
pritime:  mov  ah,2              ;set cursor-position 
	  int  10h               ;call BIOS video-interrupt 
	  mov  dh,CLKLINE shl 8  ;repeat line 
	  inc  dl                ;increase column for next character 
	  mov  ah,9              ;output a character 
	  lodsb                  ;get character from the string 
	  int  10h               ;call BIOS video-interrupt 
	  dec  di                ;all characters processed ?
	  jne pritime            ;NO --> output next character 

	  pop  dx                ;get old cursor-position 
	  mov  ah,2              ;and set again 
	  int  10h               ;call BIOS video-interrupt 

restore:  pop  ds                ;restore all recorded registers 
	  pop  es                ;again 
	  pop  si
	  pop  di
	  pop  dx
	  pop  cx
	  pop  bx
	  pop  ax
	  jmp  cs:[alterint]     ;jump to old timer-Interrupt 

newint    endp

instend   equ this byte           ;if SHOWCL is installed, memory 
				  ;can be released from here on 

;== Data (can be overwritten by DOS ========================

installm  db 13,10,"PERMCLK (c) 1987 by Michael Tischer",13,10,13,10
	  db "PERMCLK was installed and can be deactivated ",13,10
	  db "through a new Call",13,10,"$"

entfernt  db "PERMCLK was deactivated ",13,10,"$"

;== Program (can be overwritten by DOS) =======================

;-- Start and Initialization Routine -----------------------------

perminit  proc near

	  mov  ax,351Ch           ;get content of the interrupt vector 1C 
	  int  21h                ;call DOS-function 
	  cmp  word ptr es:[bx+2],"SJ" ;test if PERMCLK
	  jne  install            ;not yet installed  --> install 

	  ;-- PERMCLK deactivated again ---------------------------

	  mov  dx,es:intaltofs    ;offset address of the interrupt 1C(h)
	  mov  ax,es:intaltseg    ;segment address of the interrupt 1C(h)
	  mov  ds,ax              ;to DS
	  mov  ax,251Ch           ;return content of the interrupt 
	  int  21h                ;vector 1C(h) to old routine 

	  mov  ah,49h             ;release the storage of old 
	  int  21h                ;PERMCLK again 

	  push cs                 ;store CS on the stack 
	  pop  ds                 ;return as DS 

	  mov  dx,offset entfernt ;message: program removed 
	  mov  ah,9               ;output function number for string 
	  int  21h                ;call DOS function 

	  mov  ax,4C00h           ;code for program executed correctly 
	  int  21h                ;end program with end-code 

	  ;-- Install PERMCLK ------------------------------------

install:  mov  intaltseg,es       ;segment and offset address of the 
	  mov  intaltofs,bx       ;interrupt vector 1C(h) 

	  mov ah,02Ch             ;read function number for time 
	  int 021h                ;call DOS interrupt 21(h) 
	  mov al,cl               ;transmit minute to AL 
	  mov di,offset tenmint   ;ASCII result to TENMINT
	  call binascii           ;convert 2 numbers to ASCII 
	  mov al,ch               ;transmit hour to AL 
	  mov di,offset tenhours  ;ASCII result to TENHOURS
	  call binascii           ;convert 2 numbers to ASCII 
	  mov al,dh               ;transmit seconds to AL 
	  mov di,offset tensecs   ;ASCII result to TENSECS
	  call binascii           ;convert 2 numbers to ASCII 

	  mov  dx,offset newint   ;offset address new interrupt-routine
	  mov  ax,251Ch           ;point content of the interrupt
	  int  21h                ;vector 1C to user routine 

	  mov  dx,offset installm ;message: program installed 
	  mov  ah,9               ;output function number for string 
	  int  21h                ;call DOS-function 

	  ;-- only the PSP, the new interrupt-routine and the ----------
	  ;-- Data for it, must remain resident

	  mov  dx,offset instend  ;calculate the number of 
	  mov  cl,4               ;paragraphs (each 16 Bytes) which  
	  shr  dx,cl              ;the program has available 
	  inc  dx
	  mov  ax,3100h           ;terminate program with end-code 0 (o.k)
	  int  21h                ;but remain resident 

perminit  endp

;-- BINASCII : convert binary-value into 2-digit ASCII ------------------
;-- Input    : AL = the binary-value to be converted
;--            DI = the offset address for the 2 ASCII numbers
;-- Output   : none
;-- Register : AX, CL and FLAGS are changed

binascii  proc near

	  xor ah,ah               ;HI-Byte for division = 0
	  mov cl,10               ;decimal system is used  
	  div cl                  ;divide value by 10 
	  or  ax,03030H           ;convert result into ASCII 
	  mov [di],ax             ;and store 
	  ret                     ;back to caller 

binascii endp

;== End ===============================================================

code      ends                    ;end of the CODE-segment
	  end  start
