;**********************************************************************;
;*                             P R O C B A                            *;
;*--------------------------------------------------------------------*;
;*    Task:          : Determines the type of processor installed in  *;
;*                     a PC                                           *;
;*                     This BASIC version of the program converts     *;
;*                     DATA statements into machine language, and     *;
;*                     executes this code in the BASIC program        *;
;*--------------------------------------------------------------------*;
;*    assembly       : MASM PROCBA;                                   *;
;*                     LINK PROCBA;                                   *;
;*                     EXE2BIN PROCBA PROCBA.BIN                      *;
;*                         convert to DATA statements and add to      *;
;*                         a BASIC program                            *;
;**********************************************************************;
                                                                        
;== Constants ==========================================================
                                                                        
p_80386   equ   7                 ;Codes for different processor   
p_80286   equ   6                 ;types
p_80186   equ   5
p_80188   equ   4
p_v30     equ   3
p_v20     equ   2
p_8086    equ   1
p_8088    equ   0
                                                                        
;== Code ===============================================================
                                                                        
code      segment para 'CODE'     ;Definition of CODE segment
                                                                        
          org  100h
                                                                        
          assume cs:code, ds:code, ss:code, es:code
                                                                        
getproc   proc far                ;GW-BASIC waits for CALL FAR procedure
                                                                        
                                                                        
          push  bp                ;Push BP onto stack
          mov   bp,sp             ;Move SP after BP
          pushf                   ;Save contents of flag registers
          push es                 ;Mark ES
                                                                        
          ;-- test for 80386/80286 - -----------------------------------
                                                                        
          xor  ax,ax              ;Set AX to 0 and
          push ax                 ;push onto stack
          popf                    ;Get as flag register from stack
          pushf                   ;Put on stack again and
          pop  ax                 ;return to AX
          and  ax,0f000h          ;Don't clear the top 4 bits
          cmp  ax,0f000h          ;Are bits 12-15 all equal to 1?
          je   not_a_386          ;YES-> Not an 80386 or 80286
                                                                        
          ;-- Test to see if it should be handled as 80386 or 80286 ----
                                                                        
          mov  dl,p_80286         ;This narrows it down to one of the
          mov  ax,07000h          ;two processors
          push ax                 ;Push value 07000(h) onto the stack
          popf                    ;Return as flag register
          pushf                   ;and push back onto stack
          pop  ax                 ;Pop off and return to AX register
          and  ax,07000h          ;Do not mask bits 12-14
          je   pende              ;Are bits 12-14 equal to 0?
                                  ;YES-> Treat it as an 80286
                                                                        
          inc  dl                 ;NO-> Treat it as an 80386
          jmp  pende              ;Test ended
                                                                        
          ;-- Test for 80186 or 80188 ----------------------------------
                                                                        
not_a_386 label near
                                                                        
          mov  dl,p_80188         ;Load code for 80188
          mov  al,0ffh            ;Set all bits in AL register to 
          mov  cl,021h            ;Number of shift operations after CL
          shr  al,cl              ;Shift AL CL times to the right
          jne  t88_86             ;If AL<>0 then it must be handled as
                                  ;80188 or 80186
                                                                        
          ;-- Test for NEC V20 or V30 --- ------------------------------
                                                                        
          mov  dl,p_v20           ;Load code for NEC V20
          sti                     ;Interrupts should be enabled starting
          mov  si,0               ;with the first byte in ES
          mov  cx,0ffffh          ;Read a complete segment
          rep  lods byte ptr es:[si]      ;REP with segment override
                                  ;works only with NEC V20/V30 chips
          or   cx,cx              ;Has the complete segment been read?
          je   t88_86             ;YES--> it's a V20 or V30
                                                                        
          mov  dl,p_8088          ;NO--> must be an 8088 or 8086
                                                                        
          ;-- Test for ...88 or ...86 / V20 or V30 ---------------------
                                                                        
t88_86    label near
                                                                        
          push cs                 ;Push CS onto the stack
          pop  es                 ;and pop off to ES
          std                     ;Using string inst. count backwards
          mov  al,0fbh            ;Code for "STI"
          mov  cx,3               ;Execute string instruction 3 times
          call get_di             ;Call starting address DI
t86_1:    cli                     ;Suppress interrupts
          rep  stosb
          cld                     ;Using string inst. ocunt backwards
          nop                     ;Fill queue with dummy command
          nop
          nop
                                                                        
          inc  dx                 ;Increment processor code
          nop
q_end:    sti                     ;Re-enable interrupts
                                                                        
          ;-------------------------------------------------------------
                                                                        
pende     label near              ;End processor test
                                                                        
          xor  dh,dh              ;Set high byte or processor code to 0
          mov  di,[bp+6]          ;Get addr. of processor code variables
          mov  [di],dx            ;Place processor code in this variable
          pop  es                 ;Pop off stack and place in ES
          popf                    ;Pop flag register off of stack and
          pop  bp                 ;Return BP
          ret  2                  ;FAR return takes us back to GW-BASIC
                                  ;Remove parameters from stack
                                                                        
getproc   endp                    ;End of PROG procedure
                                                                        
;-- GET_DI Check with DI for 88/86 Test --------------------------------
                                                                        
get_di    proc near
                                                                        
          pop  di                 ;Pop return address off of stack      
          add  di,9               ;Remove starting 9 bytes from it      
          jmp  t86_1              ;Return to the test routine           
                                                                        
get_di    endp
                                                                        
;== End ================================================================
                                                                        
code      ends                    ;End of CODE segment
          end  getproc

