;*********************************************************************;
;*                              P R U M                              *;
;*-------------------------------------------------------------------*;
;*    Task        :   Points the BIOS printer interrupt to its own   *;
;*                     Routine and makes it possible for example     *;
;*                     to convert IBM-ASCII to EPSON.                *;
;*                     The program is deactivated again on the       *;
;*                     second call and removed from memory.          *;
;*-------------------------------------------------------------------*;
;*    assembly       : MASM PRUM;                                    *;
;*                     LINK PRUM;                                    *;
;*                     EXE2BIN PRUM PRUM.COM                         *;
;*-------------------------------------------------------------------*;
;*    Call         : PRUM                                            *;
;*********************************************************************;

;== Actual program starts here ==================================

code      segment para 'CODE'     ;Definition of the CODE segment

          org 100h

          assume cs:code, ds:code, es:code, ss:code

start:    jmp prumini             ;the first executable command 

;== Data (remain in memory) ========================================

alterint  equ this dword        ;Old interrupt vector 17(h)
intaltofs dw (?)                ;Offset address Interrupt vector 17(h)
intaltseg dw (?)                ;Segment address Interrupt vector 17(h)

          ;-- The following table contains the new  -----------
          ;-- code followed by the old code -------------------

codetab   db   64, 21             ; Paragraph --- > '@'
          db  125,129             ; '' ----------> '}'
          db  123,132             ; '' ----------> '{'
          db   91,142             ; '' ----------> '['
          db  124,148             ; '' ----------> '|'
          db   92,153             ; '' ----------> '\'
          db   93,154             ; '' ----------> ']'
          db  126,225             ; '' ----------> '~'
          db  0                   ;End of the table 

;== this is the new printer interrupt (remains in memory) ===========

newpri    proc far

          jmp  short newpri_1

          db "CW"                 ;Identification of the program

newpri_1: or   ah,ah              ;print character (function 0)?
          jne  aint               ;NO --> call old interrupt 

          pushf                   ;all registers changed in the program 
          push bx                 ;must be stored 
          push si
          push ds

          push cs                 ;save CS on the stack 
          pop  ds                 ;get DS from stack 

          ;-- Does code have to be converted ? ------------------------

          cld                     ;on string commands count up 
          mov  si,offset codetab  ;address of the code table 
          mov  bl,al              ;store code in BL 
testcode: lodsw                   ;load old (AH) and new code (AL) 
          or   al,al              ;Reached end of table ?
          je   notfound           ;YES --> Code not found 
          cmp  ah,bl              ;Is it the code for conversion
          jne  testcode           ;NO --> continue to search table 
          jmp  short nreset     ;it was a code for conversion 

notfound: mov  al,bl              ;move old code to AL again 
nreset:   xor  ah,ah              ;set function number 0 again 
          pop  ds                 ;restore registers 
          pop  si
          pop  bx
          popf

aint:     jmp  cs:[alterint]      ;to old printer routine

newpri    endp

instend   equ this byte           ;up to this mem location everything must 
                                  ;remain resident 

;== Data (can be overwritten by DOS) ========================

installm  db 13,10,"PRUM (c) 1987 by Michael Tischer",13,10,13,10
          db "PRUM was installed and can be deactivated with ",13,10
          db "a new call",13,10,"$"

removeit  db "PRUM was deactivated$",13,10

;== Program (can be overwritten by DOS) =======================
;-- Start and Initialization Routine ---------------------------------

prumini   label near

          mov  ax,3517h           ;get content of interrupt vector 17(h) 
          int  21h                ;call DOS function 
          cmp  word ptr es:[bx+2],"WC" ;test if PRUM program
          jne  install            ;SHOWCL not installed --> INSTALL

          ;-- PRUM was deactivated ------------------------------------

          mov  dx,es:intaltofs    ;Offset address of interrupt 17(h)
          mov  ax,es:intaltseg    ;Segment address of interrupt 17(h)
          mov  ds,ax              ;to DS
          mov  ax,2517h           ;deflect content of the interrupt 
          int  21h                ;vector 17(h) to old routine 

          mov  ah,49h             ;release storage of old PRUM
          int  21h                ;again 

          push cs                 ;store CS on stack 
          pop  ds                 ;restore DS 

          mov  dx,offset removeit ;Message: Program removed 
          mov  ah,9               ;write function number for atring 
          int  21h                ;call DOS function 

          mov  ax,4C00h           ;terminate program 
          int  21h                ;call function program termination 

          ;-- install PRUM ------------------------------------

install   label near

          mov  ax,3517h           ;get content of interrupt vector 17 
          int  21h                ;call DOS function 
          mov  intaltseg,es       ;save segment- and offset address
          mov  intaltofs,bx       ; of the interrupt vector 17(h) 

          mov  dx,offset newpri   ;Offset address new interrupt routine
          mov  ax,2517h           ;deflect content of interrupt 
          int  21h                ; vector 17 to user routine 

          mov  dx,offset installm ;Message: Program installed 
          mov  ah,9               ;output function number for string 
          int  21h                ;call DOS function 

          ;-- only the PSP, the new interrupt routine and the ---------
          ;-- data pertaining to it must remain resident.    ----------

          mov  dx,offset instend  ;calculate the number of 
          mov  cl,4               ;paragraphs (each 16 bytes) available
          shr  dx,cl              ; to the program 
          inc  dx
          mov  ax,3100h           ;end program with end code 0 (o.k) 
          int  21h                ;but remain resident 

;== End ===============================================================

code      ends                    ;End of the CODE segment
          end  start

