;*********************************************************************;
;*                           S H O W C L O C K                       *;
;*-------------------------------------------------------------------*;
;*    Task           : Outputs the time on the display after pressing*;
;*                     a key which generates an extended key code    *;
;*                     stops when another key is pressed             *;
;*-------------------------------------------------------------------*;
;*    assembly       : MASM SHOWCLK                                  *;
;*                     LINK SHOWCLK                                  *;
;*                     EXE2BIN SHOWCLK SHOWCLK.COM                   *;
;*-------------------------------------------------------------------*;
;*    Call         : SHOWCLK [Key-code] [/lLine] [/cColumn]          *;
;*********************************************************************;

;== Constants ========================================================

      TAB    equ 9
      LF     equ 10
      CR     equ 13

;== here starts the actual Program ==============================

code      segment para 'CODE'     ;Definition of the CODE-Segment

          org 100h

          assume cs:code, ds:code, es:code, ss:code

start:    jmp  showinit           ;Call of the Initialization-Routine

;== Data (remain in memory) ========================================

alterint  equ this dword        ;old interrupt vector 16(h)
intaltofs dw (?)                ;Offset address interrupt vector 16(h)
intaltseg dw (?)                ;Segment address interrupt vector 16(h)

extkey   db (1)                 ;extended keyboard-code, on which 
keycode  db (?)                 ;the program is called 

linepos  equ this word
column   db 75                 ;Line and column in which the time 
line     db 0                  ;is output 

buffer    dw 5 dup (?)         ;stores the characters from the clock 

;== this is the new kyboard-interrupt (remains in memory) ==========

newint    proc far

          jmp  short newi_1

          db "MT"                 ;Identification of the program

newi_1:   or   ah,ah              ;read character (Function 0)?
          je   newi_2             ;YES --> get character and test 
          jmp  aint               ;NO --> call old interrupt 

newi_2:   pushf                   ;for smulation of an interrupt call 
          call cs:[alterint]      ;call old interrupt 
          cmp  ax,cs:word ptr extkey ;was it the specified key?
          je   showtime           ;YES --> display clock 
          jmp  aiend              ;NO --> back 

          ;-- the specified key was activated ----------------------

showtime: pushf                   ;all registers which are changed 
          push ax                 ; must be stored 
          push bx
          push cx
          push dx
          push di
          push si
          push es
          push ds

          cld                     ;on sring commands count up 
          mov  ah,15              ;read current display page 
          int  10h                ;call BIOS video-interrupt 
          mov  ah,3               ;read current cursor position 
          int  10h                ;call BIOS video-interrupt 
          push dx                 ;store on the stack 
          push cs                 ;Code-sgment to the stack
          pop  ds                 ;return as DS 
          mov  dx,linepos         ;set cursor position 
          mov  ah,2               ;for the time 
          int  10h                ;call BIOS video-interrupt 
          push cs                 ;Code-segment to the stack
          pop  es                 ;return as ES 
          mov  cx,5               ;read 5 characters 
          mov  di,offset buffer   ;Address of the character-buffer
getz:     mov  ah,8               ;read 1 character 
          int  10h                ;call BIOS video-interrupt 
          stosw                   ;store character in the buffer 
          inc  dl                 ;next display column 
          mov  ah,2               ;set cursor position 
          int  10h                ;call BIOS video-interrupt 
          loop getz               ;get next character 
          mov  dx,linepos         ;set cursor position 
          mov  ah,2               ;for the time 
          int  10h                ;call BIOS video-interrupt 
          mov  ah,2CH             ;get time from DOS 
          int  21h                ;call DOS-interrupt 
          mov  bl,70h             ;color of clock: inverted
          push cx                 ;record minutes 
          mov  al,ch              ;change hours to ASCII 
          call bia                ;and output 
          mov  al,":"             ;output colon 
          call prz
          pop  ax                 ;get minutes 
          call bia                ;and output 

          mov  dx,linepos         ;set cursor position  
          mov  ah,2               ;for time 
          int  10h                ;cll BIOS video-interrupt 
          xor  ah,ah              ;wai for key 
          pushf                   ;for simulation of an interrupt call 
          call cs:[alterint]      ;call old interrupt 

          mov  cx,1               ;always output 1 character 
          mov  di,5               ;output a total of 5 characters 
          mov  si,offset buffer   ;address of the character-buffer
          mov  dx,linepos         ;cursor position for time 
storz:    lodsw                   ;get character and color from buffer 
          mov  bl,9               ;function number for character output 
          xchg bl,ah              ;exchange AH and BL 
          int  10h                ;call BIOS video-interrupt 
          inc  dl                 ;next column 
          mov  ah,2               ;set cursor position 
          int  10h                ;call BIOS video-interrupt 
          dec  di                 ;output another character ?
          jne  storz              ;YES --> STORZ
          pop  dx                 ;get old cursor position 
          mov  ah,2               ;and set again 
          int  10h                ;call BIOS video-interrupt 

          pop  ds                 ;restore all stored registers 
          pop  es                 
          pop  si
          pop  di
          pop  dx
          pop  cx
          pop  bx
          pop  ax
          popf
          xor   ah,ah
          jmp   newi_2

aint:     pushf                   ;simulate interrupt-routine 
          call cs:[alterint]      ;call next keyboard-routine 
aiend:    ret  2                  ;flag-register 

newint    endp

;-- BIA: change binary to ASCII and output -------------------------
;-- Input  : AL = the number to be converted 
;-- Output : none
;-- Register : CX, AX, DL and FLAGS are changed 

bia       proc near

          mov  cl,10              ;we work in the decimal system
          xor  ah,ah              ;prepare 16 bit division 
          div  cl                 ;divide AX by CL 
          or   ax,3030h           ;change result to ASCII 
          push ax                 ;store number 
          call prz                ;output character and advance cursor 
          pop  ax                 ;read number 
          mov  al,ah              ;move character to AL 
          call prz                ;output character and advance cursor 
          ret                     ;back to caller 

bia       endp

;-- PRZ: output character and increment cursor position ------------
;-- Input    : BH = Display page for Output
;--            AL = the character for output
;--            BL = Attribute (color) of the character
;-- Output  : none
;-- Register : CX, AH, DL and FLAGS are changed 

prz       proc near

          mov  ah,9               ;function number for character output
          mov  cx,1               ;output character only once 
          int  10h                ;call BIOS video-interrupt 
          mov  ah,3               ;read current cursor position 
          int  10h                ;call BIOS video-interrupt 
          inc  dl                 ;increment cursor column 
          mov  ah,2               ;set
          int  10h                ;call BIOS video-interrupt 
          ret                     ;back to caller 

prz       endp

instend   equ this byte           ;if SHOWCLK installed, memory can be
                                  ;released starting at this location 

;== Data (can be overwritten by DOS) ========================

badp      db "Invalid Parameter",CR,LF,"$"
installm  db "SHOWCLK (c) 1987 by Michael Tischer",13,10,13,10
          db "SHOWCLK was installed and can be deactivated ",13,10
          db "with a new call  ",13,10
          db "(but without Parameters)",CR,LF,"$"

deactivm  db "SHOWCLK was deactivated",CR,LF,"$"
allinm    db "SHOWCL is already installed",CR,LF,"$"
noinstm   db "no SHOWCLK installed",CR,LF,"$"

partab    dw 63 dup (?)           ;Address of command line parameter

;== program (can be overwritten by DOS) =======================

deactivate label near              ;turn SHOWCL off 

          mov  ax,3516h           ;get content of interrupt vector 16 
          int  21h                ;call DOS-Function 
          cmp  word ptr es:[bx+2],"TM" ;test if SHOWCL-program
          jne  noinst             ;SHOWCLK not  installed --> End

          mov  dx,es:intaltofs    ;Offset address of interrupt 16(h)
          mov  ax,es:intaltseg    ;Segment address of interrupt 16(h)
          mov  ds,ax              ;to DS
          mov  ax,2516h           ;reset content of 
          int  21h                ;interrupt vector 16(h) old routine 

          mov  ah,49h             ;release storage 
          int  21h                ;of old SHOWCLK again 

          push cs                 ;store CS on the Stack 
          pop  ds                 ;restore DS 

entfe:    mov  dx,offset deactivm ;Message: program removed 
          xor  al,al              ;program performed correctly 
          jmp  showend            ;to end of program 

noinst:   mov  dx,offset noinstm  ;Error-Message: no SHOWCLK installed
          jmp  short noinerr      ;output Error-Message and terminate 

;-- Start and Initialization-Routine ---------------------------------

showinit  proc near

          cld                     ;on String commands count up 
          mov  di,offset partab   ;Address of Parameter-Table 
          call parmtest           ;count Parameter/determine Address 
          or   dl,dl              ;if no Parameter indicated 
          je   deactivate          ;YES --> remove last SHOWCL 

          ;evaluate Parameter -----------------------------------------

          mov  bx,offset partab   ;Address of the Parameter-Table 
paraout:  mov  si,[bx]            ;get Address of a Parameter 
          lodsw                   ;get first two chars of parameter
          and  ah,11011111b       ;lower case letters --> upper case 
          cmp  ax,"L/"            ;is it line indication ?
          je   getline            ;YES --> GETLINE
          cmp  ax,"C/"            ;is it column indication?
          je   getcolumn          ;YES --> GETCOLUMN

          ;-- Parameter must be Key code ------------------------

          cmp  extkey,0          ;Key code discovered?
          je   badpara            ;YES --> Error

          push bx                 ;save Pointer in PARTAB 
          push dx                 ;save remaining number of Parameters 
          sub  si,2               ;set SI to beginning of number 
          call asciibin           ;convert Code to binary 
          pop  dx                 ;get remaining number of Parameters 
          pop  bx                 ;get Pointer in PARTAB 

          jc   badpara            ;no number found  --> Error
          or   ah,ah              ;number larger than 255?
          jne  badpara            ;YES --> wrong number 
          mov  keycode,al        ;number o.k. record it
          mov  extkey,0          ;announce Key code discovery 

nextpara: add  bx,2               ;Address of the next PARTAB-Element
          dec  dl                 ;decrease Parameter counter 
          jne  paraout            ;last Parameter? NO --> continue 
          jmp  short install      ;Parameter o.k. --> install program  

getline:  mov  di,offset line     ;Address of Line-Variable
          mov  dh,24              ;Maximum value for Line 
          jmp  pareval            ;evaluate Parameter 

getcolumn:mov  di,offset column   ;Address of the Column-Variable
          mov  dh,75              ;Maximum value for column 

pareval:  push bx                 ;store Pointer in PARTAB 
          push dx                 ;store remaining number of Parameters 
          call asciibin           ;convert Code to binary 
          pop  dx                 ;get remaining number of Parameters 
          pop  bx                 ;get Pointer in PARTAB 

          jc   badpara            ;no number found --> Error 
          or   ah,ah              ;Number larger than 255?
          jne  badpara            ;YES --> wrong number
          cmp  al,dh              ;Number larger than permitted?
          ja   badpara            ;YES --> wrong number
          mov  [di],al            ;Number o.k. therefore store 
          jmp  short nextpara     ;evaluate next prameter 

allinst:  mov  dx,offset allinm   ;Error-Message: already installed 
          jmp  short noinerr      ;output Error-Message and terminate 

badpara:  mov  dx,offset badp     ;Error-Message: invalid parameter
noinerr:  mov  al,1               ;Error-Code
          jmp  showend            ;terminate program

install:  cmp  extkey,0          ;Key-code discovered?
          jne  badpara            ;NO --> Error
          mov  ax,3516h           ;get content of interrupt vector 16 
          int  21h                ;call DOS-function 

          cmp  word ptr es:[bx+2],"TM" ;test if already installed 
          je   allinst            ;YES --> Error

          mov  intaltseg,es       ;segment and offset address of the
          mov  intaltofs,bx       ;stored-interrupt vector 16(h) 

          mov  dx,offset newint   ;Offset address new interrupt routine
          mov  ax,2516h           ;change content interrupt vector 16 
          int  21h                ;to user routine 

          mov  dx,offset installm ;Message: program installed 
          mov  ah,9               ;output function number for string 
          int  21h                ;call DOS-function 

          ;-- only the PSP, the new interrupt-Routine and the ----------
          ;-- Data must remain resident.

          mov  dx,offset instend  ;calculate number of paragraphs
          mov  cl,4               ; (each 16 Bytes) at the disposal 
          shr  dx,cl              ; of the program 
          inc  dx
          mov  ax,3100h           ;terminate program with End-Code 0 
          int  21h                ;remain resident 

showend:  mov  ah,9               ;output string 
          int  21h                ;call DOS-function 
          mov  ah,4Ch             ;function number for program 
          int  21h                ;terminate program with End-Code 

showinit  endp                    ;End of PROG-procedure 

;-- ASCIIBIN: convert ASCII number to binary (max. 16 Bit) ------------
;-- Input    : DS:SI = Address of Number as ASCII-string
;-- Output   : AX = the converted Number
;--            Carry-Flag = 1 : Number too large 
;-- Register : AX, BX, CX, SI and FLAGS are changed 
;-- Info     : the ASCII-string must be ended with Code 0 

asciibin  proc near

          xor  bh,bh              ;Hi-Byte of every position 
          mov  cx,10              ;we use decimal system
          xor  ax,ax              ;preliminary result 
nx_num:   mov  bl,[si]            ;get next number 
          or   bl,bl              ;NUL-Code (End)?
          je   ab_ende            ;YES --> number converted 
          cmp  bl,"0"             ;test if number 
          jb   ab_ret             ;NO --> Error
          cmp  bl,"9"             ;test if number 
          ja   ab_err             ;NO --> Error
          mul  cx                 ;preliminary Number * 10
          jc   ab_ret             ;Number > 65535 --> Error
          and  bl,1111b           ;convert number to binary 
          add  ax,bx              ;add to preliminary Number 
          inc  si                 ;process next number 
          jmp  short nx_num

ab_ende:  clc                     ;no Error
          ret                     ;back to caller 

ab_err:   stc                     ;Error
ab_ret:   ret                     ;back to caller 

asciibin  endp

;-- PARMTEST: capture Parameter in the Command Line ------------------
;-- Input    : DS:0000 = Address of PSP
;-- Output   : DL = number of parameters found 
;-- Register : AX, CX, DX, SI and FLAGS are changed 
;-- Info     : Address of every parameter is stored in Array-PARTAB as
;--            Offset address to DS. In addition behind every 
;--            parameter an ASCII-Code 0 is stored.

parmtest  proc near

          cld                     ;on string commands count up 
          xor  dx,dx              ;number of parameters found
          mov  si,80h             ;address where number of characters
                                  ;of the command line is stored in PSP 
          mov  cl,byte ptr [si]   ;get number of character 
          or   cl,cl              ;have parameters been passed?
          je   parmtend           ;NO --> End

          inc  si                 ;SI points to start of command line 
          xor  ch,ch              ;in CX is the number of characters
getez:    lodsb                   ;move next character to AL 
          cmp  al," "             ;is it a space ?
          je   space              ;YES --> SPACE
          cmp  al,TAB             ;is it a Tab-character?
          je   space              ;YES --> SPACE

          ;-- no Space or Tabulator --------------------------

          or   dh,dh              ;was last character space ?
          jne  nextz              ;NO --> process next character 

          inc  dl                 ;increment number parameters found 
          not  dh                 ;indicates no " " or TAB
          mov  ax,si              ;calculate address of 
          dec  ax                 ;parameter 
          stosw                   ;store in parameter-Table 

nextz:    loop getez              ;get next character 
          mov  byte ptr [si],0    ;NUL-character as parameter-End 

parmtend: ret                     ;back to caller 

space:    or   dh,dh              ;was last character space character?
          je   nextz              ;YES --> process next character 

          ;-- found next parameter ------------------------------

          xor  dh,dh              ;this character was a space 
          mov  byte ptr [si-1],0  ;NUL-character as parameter-End 
          jmp  short nextz        ;process next character 

parmtest  endp

;== End ===============================================================

code      ends                    ;End of CODE-Segment
          end  start

