Comment $

 Intel 80x86 and 80x87 instruction opcode definitions.

 copyright (c) 1996, Adam Seychell.


$


opcode_mask_vlaues LABEL Byte

;see Intel data book for the TTTTTTT ,ect  definitions

        TTTTTTTT                EQU       180
db      11111111b
        TTTTTTTw                EQU       181
db      11111110b
        TTTTTTdw                EQU       182
db      11111100b
        TTTTTTsw                EQU       183
db      11111100b
        TTTTTreg                EQU       184
db      11111000b
        TTTTTTsT                EQU       185
db      11111101b
        TTTTwreg                EQU       186
db      11110000b
        TTT_sreg2_TTT           EQU       187
db      11100111b
        TT_sreg3_TTT            EQU       188
db      11000111b
        TTTTTTdT                EQU       189
db      11111101b
        TT_CR0_reg              EQU       190
db      11000000b
        TT_DR0_reg              EQU       191
db      11000000b
        TT_TR0_reg              EQU       192
db      11000000b
        mod_TTT_rm              EQU       193
db      00111000b
        TTTTT_st                EQU       194
db      11111000b
        TTTTTdTT                EQU       195
db      11111011b

the_last_T                      EQU       196


  NoOp                  EQU       99
  Symbol                EQU       100
  NULLER                EQU       102

immediate_data          EQU       110
unsigned_full_offset    EQU       112
offset_selector         EQU       113
mod_zxreg_rm            EQU       114
REG_EAX                 EQU       115
port_DX_IN              EQU       116
port_number_IN          EQU       117
port_DX_OUT             EQU       118
port_number_OUT         EQU       119

mod_reg_rm              EQU       120
mod_sreg3_rm            EQU       121
mod_sreg2_rm            EQU       122

REG_CL                  EQU       150
immediate_8bit          EQU       151
SetEndCharTo_W          EQU       152
full_displacement       EQU       153
Short_displacement      EQU       154
full_offset_selector    EQU       155
immediate_16bit         EQU       156
REP_prefix              EQU       157
set_direc               EQU       158




DS_overide              EQU       200
ES_overide              EQU       201
FS_overide              EQU       202
GS_overide              EQU       203
SS_overide              EQU       204
CS_overide              EQU       205



FPU_000                 EQU       11011000b
FPU_001                 EQU       11011001b
FPU_010                 EQU       11011010b
FPU_011                 EQU       11011011b
FPU_100                 EQU       11011100b
FPU_101                 EQU       11011101b
FPU_110                 EQU       11011110b
FPU_111                 EQU       11011111b

__000___                EQU       00000000b
__001___                EQU       00001000b
__010___                EQU       00010000b
__011___                EQU       00011000b
__100___                EQU       00100000b
__101___                EQU       00101000b
__110___                EQU       00110000b
__111___                EQU       00111000b



                 The_CPU_Instruction_Table             LABEL BYTE
;
; I havn't check to make sure all of these intruction formats are correct,
; but  I was very carful when I typed them in.  It took me bloody days!
;

db     Symbol, 'mov    '
db     TTTTTTdw,  mod_reg_rm                            ,NULLER,NULLER
db     10001000b                                        ,NoOp,NoOp
db     TTTTTTTw,  mod_TTT_rm,  immediate_data           ,NULLER
db     11000110b,   00000000b                           ,NoOp
db     TTTTwreg,   immediate_data                       ,NULLER,NULLER
db     10110000b                                        ,NoOp,NoOp
db     TTTTTTTw,  REG_EAX,  unsigned_full_offset        ,NULLER
db     10100000b                                        ,NoOp,NoOp
db     TTTTTTTw,  unsigned_full_offset, REG_EAX         ,NULLER
db     10100010b                                        ,NoOp,NoOp
db     TTTTTTdT,  mod_sreg3_rm                          ,NULLER,NULLER
db     10001100b                                        ,NoOp,NoOp
db     TTTTTTTT , TTTTTTdT ,TT_CR0_reg                     ,NULLER
db     00001111b, 00100000b,11000000b
db     TTTTTTTT , TTTTTTdT ,TT_DR0_reg                     ,NULLER
db     00001111b, 00100001b,11000000b
db     TTTTTTTT , TTTTTTdT ,TT_TR0_reg                     ,NULLER
db     00001111b, 00100100b,11000000b



db     Symbol, 'movsx  '
db     TTTTTTTT,  TTTTTTTw, mod_zxreg_rm               ,NULLER
db     00001111b, 10111110b                             ,NoOp

db     Symbol, 'movzx  '
db     TTTTTTTT,  TTTTTTTw,  mod_zxreg_rm              ,NULLER
db     00001111b, 10110110b                             ,NoOp

db     Symbol, 'push   '
db     TTTTTTTT,  mod_TTT_rm                           ,NULLER,NULLER
db     11111111b,   00110000b                           ,NoOp
db     TTTTTreg                                        ,NULLER,NULLER,NULLER
db     01010000b                                        ,NoOp,NoOp
db     TTT_sreg2_TTT                                   ,NULLER,NULLER,NULLER
db     00000110b                                        ,NoOp,NoOp
db     TTTTTTTT,  TT_sreg3_TTT                         ,NULLER,NULLER
db     00001111b,  10000000b                            ,NoOp
db     TTTTTTsT,  immediate_data                       ,NULLER,NULLER
db     01101000b                                        ,NoOp,NoOp



db     Symbol, 'pushad '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     01100000b                                        ,NoOp,NoOp

db     Symbol, 'pop    '
db     TTTTTTTT,  mod_TTT_rm                           ,NULLER,NULLER
db     10001111b,   00000000b                           ,NoOp
db     TTTTTreg                                        ,NULLER,NULLER,NULLER
db     01011000b                                        ,NoOp,NoOp
db     TTT_sreg2_TTT                                   ,NULLER,NULLER,NULLER
db     00000111b                                        ,NoOp,NoOp
db     TTTTTTTT,  TT_sreg3_TTT                         ,NULLER,NULLER
db     00001111b,  10000001b                            ,NoOp


db     Symbol, 'popad  '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     01100001b                                        ,NoOp,NoOp


db     Symbol, 'in     '
db     TTTTTTTw,  port_number_IN                       ,NULLER,NULLER
db     11100100b                                        ,NoOp,NoOp
db     TTTTTTTw,  port_DX_IN                           ,NULLER,NULLER
db     11101100b                                        ,NoOp,NoOp

db     Symbol, 'out    '
db     TTTTTTTw,  port_number_OUT                      ,NULLER,NULLER
db     11100110b                                        ,NoOp,NoOp
db     TTTTTTTw,  port_DX_OUT                          ,NULLER,NULLER
db     11101110b                                        ,NoOp,NoOp


db     Symbol, 'lea    '
db     TTTTTTTT, set_direc,  mod_reg_rm               ,NULLER
db     10001101b                                        ,NoOp,NoOp

db     Symbol, 'lds    '
db     TTTTTTTT, set_direc,  mod_reg_rm               ,NULLER
db     11000101b                                        ,NoOp,NoOp
db     Symbol, 'les    '
db     TTTTTTTT, set_direc,  mod_reg_rm               ,NULLER
db     11000100b                                        ,NoOp,NoOp
db     Symbol, 'lfs    '
db     TTTTTTTT,  TTTTTTTT, set_direc, mod_reg_rm
db     00001111b, 10110100b                             ,NoOp
db     Symbol, 'lgs    '
db     TTTTTTTT,  TTTTTTTT, set_direc, mod_reg_rm
db     00001111b, 10110101b                             ,NoOp
db     Symbol, 'lss    '
db     TTTTTTTT,  TTTTTTTT, set_direc, mod_reg_rm
db     00001111b, 10110010b                             ,NoOp

db     Symbol, 'clc    '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     11111000b                                        ,NoOp,NoOp
db     Symbol, 'cld    '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     11111100b                                        ,NoOp,NoOp
db     Symbol, 'cli    '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     11111010b                                        ,NoOp,NoOp
db     Symbol, 'clts   '
db     TTTTTTTT, TTTTTTTT                              ,NULLER ,NULLER
db     00001111b,00000110b                              ,NoOp
db     Symbol, 'cmc    '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     11110101b                                        ,NoOp,NoOp
db     Symbol, 'lahf   '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     10011111b                                        ,NoOp,NoOp
db     Symbol, 'popf   '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     10011101b                                        ,NoOp,NoOp
db     Symbol, 'pushf  '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     10011100b                                        ,NoOp,NoOp
db     Symbol, 'sahf   '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     10011110b                                        ,NoOp,NoOp
db     Symbol, 'stc    '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     11111001b                                        ,NoOp,NoOp
db     Symbol, 'std    '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     11111101b                                        ,NoOp,NoOp
db     Symbol, 'sti    '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     11111011b                                        ,NoOp,NoOp

db     Symbol, 'add    '
db     TTTTTTdw,  mod_reg_rm                           ,NULLER,NULLER
db     00000000b                                        ,NoOp,NoOp
db     TTTTTTsw,  mod_TTT_rm ,  immediate_data         ,NULLER
db     10000000b,   00000000b                          ,NoOp
db     TTTTTTTw, REG_EAX,  immediate_data              ,NULLER
db     00000100b                                       ,NoOp,NoOp

db     Symbol, 'adc    '
db     TTTTTTdw,  mod_reg_rm                           ,NULLER,NULLER
db     00010000b                                       ,NoOp,NoOp
db     TTTTTTsw,  mod_TTT_rm ,  immediate_data         ,NULLER
db     10000000b,   00010000b                          ,NoOp
db     TTTTTTTw, REG_EAX,  immediate_data              ,NULLER
db     00010100b                                       ,NoOp,NoOp

db     Symbol, 'inc    '
db     TTTTTTTw,  mod_TTT_rm                           ,NULLER,NULLER
db     11111110b,   00000000b                          ,NoOp
db     TTTTTreg                                        ,NULLER,NULLER,NULLER
db     01000000b                                       ,NoOp,NoOp

db     Symbol, 'dec    '
db     TTTTTTTw,  mod_TTT_rm                           ,NULLER,NULLER
db     11111110b,   00001000b                          ,NoOp
db     TTTTTreg                                        ,NULLER,NULLER,NULLER
db     01001000b                                       ,NoOp,NoOp

db     Symbol, 'sub    '
db     TTTTTTdw,  mod_reg_rm                           ,NULLER,NULLER
db     00101000b                                       ,NoOp,NoOp
db     TTTTTTsw,  mod_TTT_rm ,  immediate_data         ,NULLER
db     10000000b,   00101000b                          ,NoOp
db     TTTTTTTw, REG_EAX,  immediate_data              ,NULLER
db     00101100b                                       ,NoOp,NoOp

db     Symbol, 'sbb    '
db     TTTTTTdw,  mod_reg_rm                           ,NULLER,NULLER
db     00011000b                                       ,NoOp,NoOp
db     TTTTTTsw,  mod_TTT_rm ,  immediate_data         ,NULLER
db     10000000b,   00011000b                          ,NoOp
db     TTTTTTTw, REG_EAX,  immediate_data              ,NULLER
db     00011100b                                       ,NoOp,NoOp

db     Symbol, 'cmp    '
db     TTTTTTdw,  mod_reg_rm                           ,NULLER,NULLER
db     00111000b                                       ,NoOp,NoOp
db     TTTTTTsw,  mod_TTT_rm ,  immediate_data         ,NULLER
db     10000000b,   00111000b                          ,NoOp
db     TTTTTTTw, REG_EAX,  immediate_data              ,NULLER
db     00111100b                                       ,NoOp,NoOp

db     Symbol, 'neg    '
db     TTTTTTTw,   mod_TTT_rm                          ,NULLER,NULLER
db     11110110b,    00011000b                         ,NoOp

db     Symbol, 'aaa    '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     00110111b                                       ,NoOp,NoOp

db     Symbol, 'aas    '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     00111111b                                       ,NoOp,NoOp

db     Symbol, 'daa    '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     00100111b                                       ,NoOp,NoOp

db     Symbol, 'das    '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     00101111b                                       ,NoOp,NoOp

db     Symbol, 'mul    '
db     TTTTTTTw, mod_TTT_rm                            ,NULLER,NULLER
db     11110110b,  00100000b                           ,NoOp

db     Symbol, 'imul   '
db     TTTTTTTw, mod_TTT_rm                            ,NULLER,NULLER
db     11110110b,  00101000b                           ,NoOp
db     TTTTTTTT,   TTTTTTTT, set_direc,  mod_reg_rm
db     00001111b,  10101111b                           ,NoOp
db     TTTTTTsT,  set_direc,   mod_reg_rm ,immediate_data
db     01101001b                                        ,NoOp,NoOp


db     Symbol, 'div    '
db     TTTTTTTw, mod_TTT_rm                            ,NULLER,NULLER
db     11110110b,  00110000b                           ,NoOp

db     Symbol, 'idiv   '
db     TTTTTTTw, mod_TTT_rm                            ,NULLER,NULLER
db     11110110b,  00111000b                           ,NoOp

db     Symbol, 'aad    '
db     TTTTTTTT,   TTTTTTTT                            ,NULLER,NULLER
db     11010101b,  00001010b                           ,NoOp

db     Symbol, 'aam    '
db     TTTTTTTT,   TTTTTTTT                            ,NULLER,NULLER
db     11010100b,  00001010b                           ,NoOp

db     Symbol, 'cwde   '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     10011000b                                       ,NoOp,NoOp

db     Symbol, 'cdq    '
db     TTTTTTTT                                        ,NULLER,NULLER,NULLER
db     10011001b                                       ,NoOp,NoOp

db     Symbol, 'rol    '
db     TTTTTTTw,   mod_TTT_rm                           ,NULLER,NULLER
db     11010000b,    00000000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , REG_CL                  ,NULLER
db     11010010b,    00000000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , immediate_8bit          ,NULLER
db     11000000b,    00000000b                         ,NoOp

db     Symbol, 'ror    '
db     TTTTTTTw,   mod_TTT_rm                           ,NULLER,NULLER
db     11010000b,    00001000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , REG_CL                  ,NULLER
db     11010010b,    00001000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , immediate_8bit          ,NULLER
db     11000000b,    00001000b                         ,NoOp

db     Symbol, 'rcl    '
db     TTTTTTTw,   mod_TTT_rm                           ,NULLER,NULLER
db     11010000b,    00010000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , REG_CL                  ,NULLER
db     11010010b,    00010000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , immediate_8bit          ,NULLER
db     11000000b,    00010000b                         ,NoOp

db     Symbol, 'rcr    '
db     TTTTTTTw,   mod_TTT_rm                           ,NULLER,NULLER
db     11010000b,    00011000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , REG_CL                  ,NULLER
db     11010010b,    00011000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , immediate_8bit          ,NULLER
db     11000000b,    00011000b                         ,NoOp

db     Symbol, 'shl    '
db     TTTTTTTw,   mod_TTT_rm                           ,NULLER,NULLER
db     11010000b,    00100000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , REG_CL                  ,NULLER
db     11010010b,    00100000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , immediate_8bit          ,NULLER
db     11000000b,    00100000b                         ,NoOp

db     Symbol, 'shr    '
db     TTTTTTTw,   mod_TTT_rm                           ,NULLER,NULLER
db     11010000b,    00101000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , REG_CL                  ,NULLER
db     11010010b,    00101000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , immediate_8bit          ,NULLER
db     11000000b,    00101000b                         ,NoOp

db     Symbol, 'sal    '
db     TTTTTTTw,   mod_TTT_rm                           ,NULLER,NULLER
db     11010000b,    00110000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , REG_CL                  ,NULLER
db     11010010b,    00110000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , immediate_8bit          ,NULLER
db     11000000b,    00110000b                         ,NoOp

db     Symbol, 'sar    '
db     TTTTTTTw,   mod_TTT_rm                           ,NULLER,NULLER
db     11010000b,    00111000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , REG_CL                  ,NULLER
db     11010010b,    00111000b                         ,NoOp
db     TTTTTTTw,   mod_TTT_rm , immediate_8bit          ,NULLER
db     11000000b,    00111000b                         ,NoOp

db     Symbol, 'shld   '
db     TTTTTTTT,  TTTTTTTT, mod_reg_rm, immediate_8bit
db     00001111b, 10100100b                            ,NoOp
db     TTTTTTTT,  TTTTTTTT,  mod_reg_rm ,REG_CL
db     00001111b, 10100101b                            ,NoOp

db     Symbol, 'shrd   '
db     TTTTTTTT,  TTTTTTTT,  mod_reg_rm, immediate_8bit
db     00001111b, 10101100b                            ,NoOp
db     TTTTTTTT,  TTTTTTTT,  mod_reg_rm ,REG_CL
db     00001111b, 10101101b                            ,NoOp

db     Symbol, 'test   '
db     TTTTTTTw,  mod_reg_rm                            ,NULLER ,NULLER
db     10000100b                                       ,NoOp,NoOp
db     TTTTTTTw,  mod_TTT_rm ,immediate_data             ,NULLER
db     11110110b,   00000000b                          ,NoOp
db     TTTTTTTw,  REG_EAX    ,immediate_data             ,NULLER
db     10101000b                                       ,NoOp,NoOp

db     Symbol, 'and    '
db     TTTTTTdw,  mod_reg_rm                             ,NULLER,NULLER
db     00100000b                                       ,NoOp,NoOp
db     TTTTTTsw,  mod_TTT_rm ,immediate_data             ,NULLER
db     10000000b,   00100000b                          ,NoOp
db     TTTTTTTw,  REG_EAX    ,immediate_data             ,NULLER
db     00100100b                                       ,NoOp,NoOp


db     Symbol, 'or     '
db     TTTTTTdw,  mod_reg_rm                             ,NULLER,NULLER
db     00001000b                                       ,NoOp,NoOp
db     TTTTTTsw,  mod_TTT_rm ,immediate_data             ,NULLER
db     10000000b,   00001000b                          ,NoOp
db     TTTTTTTw,  REG_EAX    ,immediate_data             ,NULLER
db     00001100b                                       ,NoOp,NoOp

db     Symbol, 'xor    '
db     TTTTTTdw,  mod_reg_rm                             ,NULLER,NULLER
db     00110000b                                       ,NoOp,NoOp
db     TTTTTTsw,  mod_TTT_rm ,immediate_data             ,NULLER
db     10000000b,   00110000b                          ,NoOp
db     TTTTTTTw,  REG_EAX    ,immediate_data             ,NULLER
db     00110100b                                       ,NoOp,NoOp

db     Symbol, 'not    '
db     TTTTTTTw,  mod_TTT_rm                             ,NULLER,NULLER
db     11110110b,   00010000b                          ,NoOp

db     Symbol, 'cmps   '
db     TTTTTTTw  ,SetEndCharTo_W                          ,NULLER,NULLER
db     10100110b                                       ,NoOp,NoOp

db     Symbol, 'ins    '
db     TTTTTTTw  ,SetEndCharTo_W                          ,NULLER,NULLER
db     01101100b                                       ,NoOp,NoOp

db     Symbol, 'lods   '
db     TTTTTTTw  ,SetEndCharTo_W                          ,NULLER,NULLER
db     10101100b                                       ,NoOp,NoOp

db     Symbol, 'movs   '
db     TTTTTTTw  ,SetEndCharTo_W                          ,NULLER,NULLER
db     10100100b                                       ,NoOp,NoOp

db     Symbol, 'outs   '
db     TTTTTTTw  ,SetEndCharTo_W                          ,NULLER,NULLER
db     01101110b                                       ,NoOp,NoOp

db     Symbol, 'scas   '
db     TTTTTTTw  ,SetEndCharTo_W                          ,NULLER,NULLER
db     10101110b                                       ,NoOp,NoOp

db     Symbol, 'stos   '
db     TTTTTTTw  ,SetEndCharTo_W                          ,NULLER,NULLER
db     10101010b                                       ,NoOp,NoOp

db     Symbol, 'xlat   '
db     TTTTTTTT                                           ,NULLER,NULLER,NULLER
db     11010111b                                       ,NoOp,NoOp

;  -----------------  Bit manipulation ------------------------
db     Symbol, 'bsf    '
db     TTTTTTTT , TTTTTTTT, set_direc,  mod_reg_rm
db     00001111b, 10111100b                            ,NoOp

db     Symbol, 'bsr    '
db     TTTTTTTT , TTTTTTTT, set_direc,  mod_reg_rm
db     00001111b, 10111101b                            ,NoOp

db     Symbol, 'bt     '
db     TTTTTTTT , TTTTTTTT,   mod_TTT_rm, immediate_8bit
db     00001111b, 10111010b,    00100000b
db     TTTTTTTT , TTTTTTTT,   mod_reg_rm                  ,NULLER
db     00001111b, 10100011b                             ,NoOp

db     Symbol, 'btc    '
db     TTTTTTTT , TTTTTTTT,   mod_TTT_rm, immediate_8bit
db     00001111b, 10111010b,    00111000b
db     TTTTTTTT , TTTTTTTT,   mod_reg_rm                  ,NULLER
db     00001111b, 10111011b                             ,NoOp

db     Symbol, 'btr    '
db     TTTTTTTT , TTTTTTTT,   mod_TTT_rm, immediate_8bit
db     00001111b, 10111010b,    00110000b
db     TTTTTTTT , TTTTTTTT,   mod_reg_rm                  ,NULLER
db     00001111b, 10110011b                              ,NoOp

db     Symbol, 'bts    '
db     TTTTTTTT , TTTTTTTT,   mod_TTT_rm, immediate_8bit
db     00001111b, 10111010b,    00101000b
db     TTTTTTTT , TTTTTTTT,   mod_reg_rm                  ,NULLER
db     00001111b, 10101011b                              ,NoOp


;  -----------------  Controll Transfer ------------------------
db     Symbol, 'call   '
db     TTTTTTTT , full_displacement                       ,NULLER,NULLER
db     11101000b                                       ,NoOp,NoOp
db     TTTTTTTT , mod_TTT_rm                              ,NULLER,NULLER
db     11111111b,   00010000b                          ,NoOp
db     TTTTTTTT , full_offset_selector                    ,NULLER,NULLER
db     10011010b                                       ,NoOp,NoOp

db     Symbol, 'call  f'
db     TTTTTTTT ,  mod_TTT_rm                             ,NULLER,NULLER
db     11111111b,    00011000b                         ,NoOp


db     Symbol, 'jmp    '
db     TTTTTTTT , Short_displacement                      ,NULLER,NULLER
db     11101011b                                       ,NoOp,NoOp
db     TTTTTTTT , full_displacement                       ,NULLER,NULLER
db     11101001b                                       ,NoOp,NoOp
db     TTTTTTTT , mod_TTT_rm                              ,NULLER,NULLER
db     11111111b,   00100000b                          ,NoOp
db     TTTTTTTT , full_offset_selector                    ,NULLER,NULLER
db     11101010b                                       ,NoOp,NoOp

db     Symbol, 'jmp   f'
db     TTTTTTTT ,  mod_TTT_rm                             ,NULLER,NULLER
db     11111111b,    00101000b                         ,NoOp

db     Symbol, 'ret    '
db     TTTTTTTT                                           ,NULLER,NULLER,NULLER
db     11000011b                                       ,NoOp,NoOp
db     TTTTTTTT ,  immediate_16bit                        ,NULLER,NULLER
db     11000010b                                       ,NoOp,NoOp

db     Symbol, 'ret   f'
db     TTTTTTTT                                           ,NULLER,NULLER,NULLER
db     11001011b                                       ,NoOp,NoOp
db     TTTTTTTT ,  immediate_16bit                        ,NULLER,NULLER
db     11001010b                                       ,NoOp,NoOp


db     Symbol, 'jo     '
db     TTTTTTTT ,   Short_displacement                    ,NULLER,NULLER
db     01110000b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10000000b                            ,NoOp
db     Symbol, 'jno    '
db     TTTTTTTT ,   Short_displacement                    ,NULLER,NULLER
db     01110001b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement            ,NULLER
db     00001111b, 10000001b                            ,NoOp


db     Symbol, 'jb     '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01110010b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10000010b                            ,NoOp
db     Symbol, 'jae    '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01110011b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10000011b                            ,NoOp



db     Symbol, 'jz     '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01110100b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10000100b                            ,NoOp
db     Symbol, 'jnz    '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01110101b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10000101b                            ,NoOp


db     Symbol, 'jbe    '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01110110b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10000110b                            ,NoOp
db     Symbol, 'ja     '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01110111b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10000111b                            ,NoOp


db     Symbol, 'js     '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01111000b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10001000b                            ,NoOp
db     Symbol, 'jns    '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01111001b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10001001b                            ,NoOp

db     Symbol, 'jpe    '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01111010b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10001010b                            ,NoOp
db     Symbol, 'jno    '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01111011b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10001011b                            ,NoOp

db     Symbol, 'jl     '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01111100b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10001100b                            ,NoOp
db     Symbol, 'jge    '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01111101b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10001101b                            ,NoOp

db     Symbol, 'jle    '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01111110b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10001110b                            ,NoOp
db     Symbol, 'jg     '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     01111111b                                       ,NoOp,NoOp
db     TTTTTTTT , TTTTTTTT,  full_displacement             ,NULLER
db     00001111b, 10001111b                            ,NoOp

db     Symbol, 'jecxz  '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     11100011b                                       ,NoOp,NoOp

db     Symbol, 'loopnz '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     11100000b                                       ,NoOp,NoOp
db     Symbol, 'loop   '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     11100010b                                       ,NoOp,NoOp
db     Symbol, 'loopz  '
db     TTTTTTTT ,   Short_displacement                     ,NULLER,NULLER
db     11100001b                                       ,NoOp,NoOp


;-------------- conditional byte set ------------------------
db     Symbol, 'seto   '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10010000b,   00000000b
db     Symbol, 'setno  '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10010001b,   00000000b
db     Symbol, 'setb   '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10010010b,   00000000b
db     Symbol, 'setae  '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10010011b,   00000000b
db     Symbol, 'setz   '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10010100b,   00000000b
db     Symbol, 'setnz  '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10010101b,   00000000b
db     Symbol, 'setbe  '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10010110b,   00000000b
db     Symbol, 'seta   '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10010111b,   00000000b
db     Symbol, 'sets   '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10011000b,   00000000b
db     Symbol, 'setns  '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10011001b,   00000000b
db     Symbol, 'setpe  '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10011010b,   00000000b
db     Symbol, 'setpo  '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10011011b,   00000000b
db     Symbol, 'setl   '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10011100b,   00000000b
db     Symbol, 'setge  '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10011101b,   00000000b
db     Symbol, 'setle  '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10011110b,   00000000b
db     Symbol, 'setg   '
db     TTTTTTTT , TTTTTTTT,  mod_TTT_rm                    ,NULLER
db     00001111b, 10011111b,   00000000b

db     Symbol, 'enter  '
db     TTTTTTTT , immediate_16bit ,immediate_8bit          ,NULLER
db     11001000b                                        ,NoOp,NoOp

db     Symbol, 'leave  '
db     TTTTTTTT                                            ,NULLER,NULLER,NULLER
db     11001001b                                        ,NoOp,NoOp

db     Symbol, 'int    '
db     TTTTTTTT , immediate_8bit                           ,NULLER,NULLER
db     11001101b                                        ,NoOp,NoOp
db     Symbol, 'INT3  '
db     TTTTTTTT                                            ,NULLER,NULLER,NULLER
db     11001100b                                        ,NoOp,NoOp
db     Symbol, 'into   '
db     TTTTTTTT                                            ,NULLER,NULLER,NULLER
db     11001110b                                        ,NoOp,NoOp
db     Symbol, 'bound  '
db     TTTTTTTT    , set_direc,  mod_reg_rm                ,NULLER
db     01100010b                                        ,NoOp,NoOp

db     Symbol, 'iret   '
db     TTTTTTTT    , SetEndCharTo_W                        ,NULLER,NULLER
db     11001111b                                        ,NoOp,NoOp

db     Symbol, 'hlt    '
db     TTTTTTTT                                            ,NULLER,NULLER,NULLER
db     11110100b                                        ,NoOp,NoOp

db     Symbol, 'nop    '
db     TTTTTTTT                                            ,NULLER,NULLER,NULLER
db     10010000b                                        ,NoOp,NoOp

db     Symbol, 'wait   '
db     TTTTTTTT                                            ,NULLER,NULLER,NULLER
db     10011011b                                        ,NoOp,NoOp

db     Symbol, 'arpl   '
db     TTTTTTTT , mod_reg_rm                               ,NULLER,NULLER
db     01100011b                                        ,NoOp,NoOp
db     Symbol, 'lar    '
db     TTTTTTTT , TTTTTTTT ,set_direc,  mod_reg_rm
db     00001111b, 00000010b                             ,NoOp
db     Symbol, 'lgdt   '
db     TTTTTTTT , TTTTTTTT ,mod_TTT_rm                     ,NULLER
db     00001111b, 00000001b,  00010000b
db     Symbol, 'lidt   '
db     TTTTTTTT , TTTTTTTT ,mod_TTT_rm                     ,NULLER
db     00001111b, 00000001b,  00011000b
db     Symbol, 'lldt   '
db     TTTTTTTT , TTTTTTTT ,mod_TTT_rm                     ,NULLER
db     00001111b, 00000000b,  00010000b
db     Symbol, 'lmsw   '
db     TTTTTTTT , TTTTTTTT ,mod_TTT_rm                     ,NULLER
db     00001111b, 00000001b,  00110000b
db     Symbol, 'lsl    '
db     TTTTTTTT , TTTTTTTT ,set_direc,  mod_reg_rm
db     00001111b, 00000011b                             ,NoOp
db     Symbol, 'ltr    '
db     TTTTTTTT , TTTTTTTT ,mod_TTT_rm                     ,NULLER
db     00001111b, 00000000b,  00011000b
db     Symbol, 'sgdt   '
db     TTTTTTTT , TTTTTTTT ,mod_TTT_rm                     ,NULLER
db     00001111b, 00000001b,  00000000b
db     Symbol, 'sidt   '
db     TTTTTTTT , TTTTTTTT ,mod_TTT_rm                     ,NULLER
db     00001111b, 00000001b,  00001000b
db     Symbol, 'sldt   '
db     TTTTTTTT , TTTTTTTT ,mod_TTT_rm                     ,NULLER
db     00001111b, 00000000b,  00000000b
db     Symbol, 'smsw   '
db     TTTTTTTT , TTTTTTTT ,mod_TTT_rm                     ,NULLER
db     00001111b, 00000001b,  00100000b
db     Symbol, 'str    '
db     TTTTTTTT , TTTTTTTT ,mod_TTT_rm                     ,NULLER
db     00001111b, 00000000b,  00001000b
db     Symbol, 'verr   '
db     TTTTTTTT , TTTTTTTT ,mod_TTT_rm                     ,NULLER
db     00001111b, 00000000b,  00100000b
db     Symbol, 'verw   '
db     TTTTTTTT , TTTTTTTT ,mod_TTT_rm                     ,NULLER
db     00001111b, 00000000b,  00101000b

db     Symbol, 'xchg   '
db     TTTTTTTw,  mod_reg_rm                           ,NULLER,NULLER
db     10000110b                                        ,NoOp,NoOp
db     TTTTTreg,   REG_EAX                             ,NULLER,NULLER
db     10010000b                                        ,NoOp,NoOp




;------------- 486 instuctions -----------------------
db     Symbol, 'bswap  '
db     TTTTTTTT, TTTTTreg                              ,NULLER,NULLER
db     00001111b,11001000b                              ,NoOp

db     Symbol, 'xadd   '
db     TTTTTTTT,  TTTTTTTw,  mod_reg_rm                 ,NULLER
db     00001111b, 11000000b                             ,NoOp

db     Symbol, 'cmpxch '
db     TTTTTTTT,  TTTTTTTw,  mod_reg_rm                 ,NULLER
db     00001111b, 10110000b                             ,NoOp

db     Symbol, 'invd   '
db     TTTTTTTT,  TTTTTTTw                              ,NULLER,NULLER
db     00001111b, 00001000b                             ,NoOp

db     Symbol, 'wbinvd '
db     TTTTTTTT,  TTTTTTTw                              ,NULLER,NULLER
db     00001111b, 00001001b                             ,NoOp

db     Symbol, 'invlpg '
db     TTTTTTTT , TTTTTTTT ,mod_TTT_rm                  ,NULLER
db     00001111b, 00000001b,  00111000b

;--------------- Pentium(tm) instructions -----------------------------

; I don't know of any !





CPU_Instruction_Definitions_End             EQU   $



;--------------- Floting Point Processor Instuctions ----------------
comment ~


 All FPU instructions will begin with the TTTTTTTT type opcode.
 use the macros FPU_??? for the first opcode. where ??? is  bits
 0..2 of the first opcode byte.
 The second byte will either be mod_TTT_rm or TTTTT_st where the T
 represents the bits significant of opcode bits.


  Adam

  (23-April-96)




~

                 The_FPU_Instruction_Table             LABEL BYTE

;-------------------- no operation
db     Symbol, 'fnop   '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db      FPU_001,    11010000b                       ,NoOp


;------------------- Real Load to ST(0)
db     Symbol, 'fld    '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db     FPU_001,   11000000b                         ,NoOp
db     TTTTTTTT,  mod_TTT_rm,  		Real_mem80      ,NULLER
db     FPU_011,     00101000b						,NoOp
db     TTTTTTTT,  mod_TTT_rm, 		Real_mem64      ,NULLER
db     FPU_101,     00000000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Real_mem32      ,NULLER
db     FPU_001,     00000000b                       ,NoOp

;------------------- Integer Load to ST(0)
db     Symbol, 'fild   '
db     TTTTTTTT,  mod_TTT_rm,  		Int_mem64      ,NULLER
db     FPU_111,     00101000b						,NoOp
db     TTTTTTTT,  mod_TTT_rm, 		Int_mem32      ,NULLER
db     FPU_011,     00000000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Int_mem16      ,NULLER
db     FPU_111,     00000000b                       ,NoOp


;------------------- BCD Load to ST(0)
db     Symbol, 'fbld   '
db     TTTTTTTT,  mod_TTT_rm,       BCD_mem80      ,NULLER
db     FPU_111,     00100000b                       ,NoOp

;------------------- Store Real From ST(0)
db     Symbol, 'fst    '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db     FPU_101,   11010000b                         ,NoOp
db     TTTTTTTT,  mod_TTT_rm, 		Real_mem64      ,NULLER
db     FPU_101,     00010000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Real_mem32      ,NULLER
db     FPU_001,     00010000b                       ,NoOp

;------------------- Store Real From ST(0) and POP
db     Symbol, 'fstp   '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db     FPU_101,   11011000b                         ,NoOp
db     TTTTTTTT,  mod_TTT_rm,  		Real_mem80      ,NULLER
db     FPU_011,     00111000b						,NoOp
db     TTTTTTTT,  mod_TTT_rm, 		Real_mem64      ,NULLER
db     FPU_101,     00011000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Real_mem32      ,NULLER
db     FPU_011,     00011000b                       ,NoOp


;------------------- Store integer From ST(0)
db     Symbol, 'fist   '
db     TTTTTTTT,  mod_TTT_rm, 		Int_mem32      ,NULLER
db     FPU_011,     00010000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Int_mem16      ,NULLER
db     FPU_111,     00010000b                       ,NoOp

;------------------- Store integer From ST(0) and  POP
db     Symbol, 'fistp  '
db     TTTTTTTT,  mod_TTT_rm, 		Int_mem64      ,NULLER
db     FPU_111,     00111000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm, 		Int_mem32      ,NULLER
db     FPU_011,     00011000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Int_mem16      ,NULLER
db     FPU_111,     00011000b                       ,NoOp

;------------------- Store BCD From ST(0) and  POP
db     Symbol, 'fbstp  '
db     TTTTTTTT,  mod_TTT_rm,       BCD_mem80      ,NULLER
db     FPU_111,     00110000b                       ,NoOp

;------------------- exchange ST(0) and ST(i)
db     Symbol, 'fxch   '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db     FPU_001,   11001000b                         ,NoOp


    ;****** comparason instructions ******************

;------------------- Compare ST(0) with real
db     Symbol, 'fcom   '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db     FPU_000,   11010000b                         ,NoOp
db     TTTTTTTT,  mod_TTT_rm, 		Real_mem64      ,NULLER
db     FPU_100,     00010000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Real_mem32      ,NULLER
db     FPU_000,     00010000b                       ,NoOp


;------------------- Compare ST(0) with real and POP
db     Symbol, 'fcomp  '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db     FPU_000,   11011000b                         ,NoOp
db     TTTTTTTT,  mod_TTT_rm, 		Real_mem64      ,NULLER
db     FPU_100,     00011000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Real_mem32      ,NULLER
db     FPU_000,     00011000b                       ,NoOp

;------------------- Compare ST(0) with ST(1) and POP twice
db     Symbol, 'fcompp '
db     TTTTTTTT,  TTTTTTTT                          ,NULLER ,NULLER
db     FPU_110,   11011001b                         ,NoOp

;------------------- Compare ST(0) with integer
db     Symbol, 'ficom  '
db     TTTTTTTT,  mod_TTT_rm, 		Int_mem32      ,NULLER
db     FPU_010,     00010000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Int_mem16      ,NULLER
db     FPU_110,     00010000b                       ,NoOp

;------------------- Compare ST(0) with integer and POP
db     Symbol, 'ficomp '
db     TTTTTTTT,  mod_TTT_rm, 		Int_mem32      ,NULLER
db     FPU_010,     00011000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Int_mem16      ,NULLER
db     FPU_110,     00011000b                       ,NoOp

;------------------- Compare ST(0) with 0
db     Symbol, 'ftst   '
db     TTTTTTTT,  TTTTTTTT                          ,NULLER ,NULLER
db     FPU_001,   11100100b                         ,NoOp

;                    Unordered compare;
;--------------------Compare ST(0) with ST(i)
db     Symbol, 'fucom  '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db     FPU_101,   11100000b                         ,NoOp

;                    Unordered compare;
;--------------------Compare ST(0) with ST(i) and POP once
db     Symbol, 'fucomp '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db     FPU_101,   11101000b                         ,NoOp

;------------------- Unordered compare;
;                    Compare ST(0) with ST(1) and POP twice
db     Symbol, 'fucompp'
db     TTTTTTTT,  TTTTTTTT                          ,NULLER ,NULLER
db     FPU_101,   11101001b                         ,NoOp


;--------------------Examine ST(0)
db     Symbol, 'fxam   '
db     TTTTTTTT,  TTTTTTTT                          ,NULLER ,NULLER
db     FPU_001,   11100101b                         ,NoOp


 ;********* CONSTANTS **************

;-------------------- Load +0.0 into ST(0)
db     Symbol, 'fldz   '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11101110b                       ,NoOp

;-------------------- Load +1.0 into ST(0)
db     Symbol, 'fld1   '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11101000b                       ,NoOp

;-------------------- Load  into ST(0)
db     Symbol, 'fld   '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11101011b                       ,NoOp

;-------------------- Load  log2(10) into ST(0)
db     Symbol, 'fldl2t '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11101001b                       ,NoOp

;-------------------- Load  log2(e) into ST(0)
db     Symbol, 'fldl2e '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11101010b                       ,NoOp

;-------------------- Load  log10(2) into ST(0)
db     Symbol, 'fldlg2 '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11101100b                       ,NoOp

;-------------------- Load  ln(2) into ST(0)
db     Symbol, 'fldln2 '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11101101b                       ,NoOp


	;***** ARETHMENTIC *******

;-------------------- Add real to ST(0)
db     Symbol, 'fadd   '
db     TTTTTdTT,  TTTTT_st                          ,NULLER ,NULLER
db      FPU_000,  11000000b                         ,NoOp
db     TTTTTTTT,  mod_TTT_rm, 		Real_mem64      ,NULLER
db      FPU_100,    00000000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Real_mem32      ,NULLER
db      FPU_000,    00000000b                       ,NoOp


;-------------------- Add ST(i) with ST(0) and POP
db     Symbol, 'faddp  '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db      FPU_110,  11000000b                         ,NoOp


;-------------------- subract (st = st - real)
db     Symbol, 'fsub   '
db     TTTTTdTT,  TTTTT_st                          ,NULLER ,NULLER
db      FPU_000,  11101000b                         ,NoOp
db     TTTTTTTT,  mod_TTT_rm, 		Real_mem64      ,NULLER
db      FPU_100,    00100000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Real_mem32      ,NULLER
db      FPU_000,    00100000b                       ,NoOp


;-------------------- subtract ST(i) with ST(0) and POP
db     Symbol, 'fsubp  '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db      FPU_110,  11101000b                         ,NoOp

;-------------------- subract (st =  real - st)
db     Symbol, 'fsubr  '
db     TTTTTdTT,  TTTTT_st                          ,NULLER ,NULLER
db      FPU_000,  11100000b                         ,NoOp
db     TTTTTTTT,  mod_TTT_rm, 		Real_mem64      ,NULLER
db      FPU_100,    00101000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Real_mem32      ,NULLER
db      FPU_000,    00101000b                       ,NoOp


;-------------------- subtract ST(i) = ST(i) - ST and POP
db     Symbol, 'fsubrp '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db      FPU_110,  11100000b                         ,NoOp


;-------------------- multiply;  (st =  st * real)
db     Symbol, 'fmul   '
db     TTTTTdTT,  TTTTT_st                          ,NULLER ,NULLER
db      FPU_000,  11001000b                         ,NoOp
db     TTTTTTTT,  mod_TTT_rm, 		Real_mem64      ,NULLER
db      FPU_100,    00001000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Real_mem32      ,NULLER
db      FPU_000,    00001000b                       ,NoOp

;-------------------- multiply;    st(i) =  st(i) * st(0) and POP
db     Symbol, 'fmulp  '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db      FPU_110,  11001000b                         ,NoOp

;-------------------- divide;  (st(0) =  st(0) / real)
db     Symbol, 'fdiv   '
db     TTTTTdTT,  TTTTT_st                          ,NULLER ,NULLER
db      FPU_000,  11111000b                         ,NoOp
db     TTTTTTTT,  mod_TTT_rm, 		Real_mem64      ,NULLER
db      FPU_100,    00110000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Real_mem32      ,NULLER
db      FPU_000,    00110000b                       ,NoOp

;-------------------- Divide;    st(i) =  st(0) / st(i) and POP
db     Symbol, 'fdivp  '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db      FPU_110,  11111000b                         ,NoOp

;-------------------- Divide Reversed;  st(0) =   real / st(0)
db     Symbol, 'fdivr  '
db     TTTTTdTT,  TTTTT_st                          ,NULLER ,NULLER
db      FPU_000,  11110000b                         ,NoOp
db     TTTTTTTT,  mod_TTT_rm, 		Real_mem64      ,NULLER
db      FPU_100,    00111000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Real_mem32      ,NULLER
db      FPU_000,    00111000b                       ,NoOp

;-------------------- Divide Reverced;    st(i) =   st(i) / st(0) and POP
db     Symbol, 'fdivrp '
db     TTTTTTTT,  TTTTT_st                          ,NULLER ,NULLER
db      FPU_110,  11110000b                         ,NoOp

;--------------------- Integer addition;  st(0) = st(0) + x
db     Symbol, 'fiadd  '
db     TTTTTTTT,  mod_TTT_rm, 		Int_mem32      ,NULLER
db      FPU_010,    00000000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Int_mem16      ,NULLER
db      FPU_110,    00000000b                       ,NoOp

;--------------------- Integer subtraction;  st(0) = st(0) - x
db     Symbol, 'fisub  '
db     TTTTTTTT,  mod_TTT_rm, 		Int_mem32      ,NULLER
db      FPU_010,    00100000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Int_mem16      ,NULLER
db      FPU_110,    00100000b                       ,NoOp

;--------------------- Integer reverse subtraction;  st(0) = x - st(0)
db     Symbol, 'fisubr '
db     TTTTTTTT,  mod_TTT_rm, 		Int_mem32      ,NULLER
db      FPU_010,    00101000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Int_mem16      ,NULLER
db      FPU_110,    00101000b                       ,NoOp

;--------------------- Integer Multiply ;  st(0) = st(0) * x
db     Symbol, 'fimul  '
db     TTTTTTTT,  mod_TTT_rm, 		Int_mem32      ,NULLER
db      FPU_010,    00001000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Int_mem16      ,NULLER
db      FPU_110,    00001000b                       ,NoOp

;--------------------- Integer Divide ;  st(0) = st(0) / x
db     Symbol, 'fidiv  '
db     TTTTTTTT,  mod_TTT_rm, 		Int_mem32      ,NULLER
db      FPU_010,    00110000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Int_mem16      ,NULLER
db      FPU_110,    00110000b                       ,NoOp

;--------------------- Integer Divide  Reversed;  st(0) = x / st(0)
db     Symbol, 'fidivr '
db     TTTTTTTT,  mod_TTT_rm, 		Int_mem32      ,NULLER
db      FPU_010,    00111000b                       ,NoOp
db     TTTTTTTT,  mod_TTT_rm,       Int_mem16      ,NULLER
db      FPU_110,    00111000b                       ,NoOp


;-------------------- Square Root
db     Symbol, 'fsqrt  '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11111010b                       ,NoOp

;-------------------- Scale st(0) by st(1)
db     Symbol, 'fscale '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11111101b                       ,NoOp

;-------------------- Extract exponents of st(0)
db     Symbol, 'fxtract'
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11110100b                       ,NoOp

;-------------------- Partial Remainder  of st(0)
db     Symbol, 'fprem  '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11111000b                       ,NoOp

;-------------------- Partial Remainder  (IEEE)
db     Symbol, 'fprem1 '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11110101b                       ,NoOp

;-------------------- Round st(0) to integer
db     Symbol, 'frndint'
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11111100b                       ,NoOp

;-------------------- Absolute Value of st(0)
db     Symbol, 'fabs   '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11100001b                       ,NoOp

;-------------------- Change sign of ST
db     Symbol, 'fchs   '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11100000b                       ,NoOp

;           ************ TRANSCENDENTAL *********

;-------------------- Cosine of ST(0)
db     Symbol, 'fcos   '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11111111b                       ,NoOp

;-------------------- Partial Tangent of st(0)
db     Symbol, 'fptan  '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11110010b                       ,NoOp

;-------------------- Partial arctan
db     Symbol, 'fpatan '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11110011b                       ,NoOp

;-------------------- sine of ST(0)
db     Symbol, 'fsin   '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11111110b                       ,NoOp

;-------------------- Sine and Cosine of ST(0)
db     Symbol, 'fsincos'
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11111011b                       ,NoOp

;-------------------- 2^st - 1
db     Symbol, 'f2xm1  '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11110000b                       ,NoOp

;-------------------- ST(1) = ST(1) * log2(ST(0))
db     Symbol, 'fyl2x  '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11110001b                       ,NoOp

;-------------------- ST(1) = ST(1) * log2(ST(0) + 1.0)
db     Symbol, 'fyl2xp1'
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11111001b                       ,NoOp


	;*********** PROCESSOR CONTROL ************

db     Symbol, 'finit  '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_011,     11100011b                       ,NoOp

db     Symbol, 'fstswAX'
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_111,     11100000b                       ,NoOp

db     Symbol, 'fstsw  '
db     TTTTTTTT,  mod_TTT_rm  	                   ,NULLER,NULLER
db      FPU_101,    00111000b                       ,NoOp

db     Symbol, 'fldcw  '
db     TTTTTTTT,  mod_TTT_rm  	                   ,NULLER,NULLER
db      FPU_001,    00101000b                       ,NoOp

db     Symbol, 'fstcw  '
db     TTTTTTTT,  mod_TTT_rm  	                   ,NULLER,NULLER
db      FPU_001,    00111000b                       ,NoOp

db     Symbol, 'fclex  '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_011,     11100010b                       ,NoOp

db     Symbol, 'fstenv '
db     TTTTTTTT,  mod_TTT_rm  	                   ,NULLER,NULLER
db      FPU_001,    00110000b                       ,NoOp

db     Symbol, 'fldenv '
db     TTTTTTTT,  mod_TTT_rm  	                   ,NULLER,NULLER
db      FPU_001,    00100000b                       ,NoOp

db     Symbol, 'fsave  '
db     TTTTTTTT,  mod_TTT_rm  	                   ,NULLER,NULLER
db      FPU_101,    00110000b                       ,NoOp

db     Symbol, 'frstor '
db     TTTTTTTT,  mod_TTT_rm  	                   ,NULLER,NULLER
db      FPU_101,    00100000b                       ,NoOp

db     Symbol, 'fincstp'
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11110111b                       ,NoOp

db     Symbol, 'fdecstp'
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db     FPU_001,     11110110b                       ,NoOp

db     Symbol, 'ffree  '
db     TTTTTTTT,    TTTTT_st                        ,NULLER ,NULLER
db      FPU_101,    11000000b                       ,NoOp

;#### 80287 only, instuction treated as FNOP on 387+  ######

db     Symbol, 'fsetpm '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db      FPU_011,    11100100b                       ,NoOp

db     Symbol, 'frstpm '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db      FPU_011,    11110100b                       ,NoOp

;#### 8087 only, instuction treated as FNOP on 287+  ######
db     Symbol, 'fdisi  '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db      FPU_011,    11100001b                       ,NoOp
db     Symbol, 'feni   '
db     TTTTTTTT,    TTTTTTTT                        ,NULLER ,NULLER
db      FPU_011,    11100000b                       ,NoOp



FPU_Instruction_Definitions_End             EQU   $



