;**************************************************************************
;  SHELL.ASM
;
; This program hooks the timer interrupt, IRQ 0, and then
; executes command line interpreter ( e.g command.com, 4dos.com, ect )
;
;
; DOS32 Assembly language example program
;**************************************************************************
.386
.model  flat
.stack 200h
.code


align 4

timer_IRQ_vector        DF ?
comspec_ptr             dd ?
dummy_cmd_tail  	    db 1,' '
meag_v86        	    db ' Exiting program ',10,13,36
mesg_pmode      	    db ' Hooking timer interrupt hand incrementing physical address B8000h.',10,13
                	    db  10,'Press any key to load and execute DOS-shell',10,13,36



Start32:                ; 32 bit code entry point.



      ; *****************  print a message *****************

        mov edx,offset mesg_pmode
        mov ah,9
        int 21h                     ; print string



    ;********** Hook Timer inerrupt ( IRQ 0 ) just for fun ****************

        mov     bl,8                        ;Save IRQ 0 interrupt vector
        mov     ax,204h
        int     31h
        mov     dword ptr timer_IRQ_vector , edx
        mov     word ptr timer_IRQ_vector[4] , cx

        mov     bl,8                      ; Set the new IRQ 0 vector
        mov     edx,offset  timer_int     ; See below
        mov     cx,cs                     ; CS:EDX = selector:offset
        mov     ax,205h
        int     31h


        mov     ah,0                    ; wait for key
        int     16h


;************** LOAD AND EXECUTE A PROGRAM ( command.com ) *****************

;
; search for the "COMSPEC=" environemnt varibles
;

        mov     ax,0EE02h            ; Get DOS32 address information
        int     31h                  ; Returns EDI -> environment address
get_str_loop:
        cmp     dword ptr [edi],'SMOC'          ; cmp the string "COMSPEC="
        jne not_string
        cmp     dword ptr [edi+4],'=CEP'
        je got_string                           ; if equal exit loop
not_string:
        mov     al,0                            ; Scan environment for a zero
        mov     ecx,20000                       ; and get next varible
        repne   scasb
        jmp  get_str_loop                       ; loop around again

got_string:
        add     edi,8
        mov     comspec_ptr,edi                 ; save address of the envir


;
; Call the 32bit version of the "load and execute" DOS service
;

        mov     ah,4Bh
        mov     al,0
        mov     edi,00000                       ; DS:EDI -> envrironment
        mov     esi,Offset dummy_cmd_tail       ; DS:ESI -> command tail
        mov     edx,comspec_ptr         	    ; DS:EDX -> ASCIIZ string
        Int     21h


;******* restore origonal vector of the timrer interrupt ********************

        mov     edx,dword ptr timer_IRQ_vector
        mov     cx,word ptr timer_IRQ_vector[4]
        mov     bl,8
        mov     ax,205h
        int     31h


; *****************  print another message *****************
        mov edx,offset meag_v86
        mov ah,9
        int 21h

exit:
        mov   ax,4c00h            ; Terminate program
        int   21h


;
; *****************  IRQ 0  interrupt  handler *****************
;
timer_int:
        push  ds                        ; must save all registers used
        push  eax
        mov   ax,_TEXT
        mov   ds,ax                     ; Load DS with data selector

        inc word ptr ds:[0B8000h]          ; increment character on the screen
                                        ; just to show it's doing something
        pop   eax
        pop   ds
        jmp   cs:timer_IRQ_vector       ; continue on interrupt chain.
                                        ; must use CS because DS is unknown


END Start32
