;                  library file for DOS32 32bit DOS extender
;        Writen by Adam Seychell


.386
.Model flat, C

Public Random
Public Randomize
Public Random_Number

.CODE

comment $
ͻ
 Returns EAX with a random number with CL bits in size.                
                                                                       
   The algorithem was from an article in Doctor Dobbs Journal          
   issue date  MAY 1991                                                
                                                                       
  NOTE: the initial random number is taken from the CMOS clock         
ͼ$
Random PROC
        push edx
        push ebx
        xor eax,eax
        mov bl,byte ptr Random_Number
        and bl,1

Gen_bit:	; make n bit numbers
        shl eax,1

	mov edx,Random_Number

        shr edx,9       ; shift arbitary 9 bits
        xor bl,dl

        shr edx,5       ; shift another arbitary 5 bits
        xor bl,dl

    	bt ebx,1
	rcr Random_Number,1
        setc bl
	or  al,bl

	dec cl
        jnz Gen_bit
        pop ebx
        pop edx
	ret
Random  Endp

align 4
Random_Number     DD 0


;ͻ
; Get inital random number from CMOS time				
;ͼ
Randomize PROC

        mov     al,0                    ; Get seconds
        out     70h,al
        in      al,71h
        shl     eax,8
        mov     al,2                    ; Get minute
        out     70h,al
        in      al,71h
        shl     eax,8
        xor     eax,[046Ch]             ; throw in number of ticks
        not     eax
        mov     Random_Number,eax
        ret

Randomize ENDP

;

        End
