#ifndef _EOS_H
#define _EOS_H


#define Off 0
#define On  1


#ifdef __cplusplus
extern "C"
{
#endif


//ͻ
//                                                                          
// EOS Functions                                                            
//                                                                          
//ͼ


//ͻ
//                                                                          
//                                System                                    
//                                                                          
//ͼ


//Ŀ
//Exit Error   Restore initial Video mode , interrupts , free all reserved  
//             memory ,stop music if played and exit (with error code 1)    
//             with a error message                                         
//                                                                          
//
void Exit_Error(char *Msg_Error);
#pragma aux Exit_Error "_*" parm [edx] modify [eax]


//Ŀ
//Use Int 08   Use Int 08 (IRQ 0) to count frame rate and have a stable     
//             vertical retrace                                             
//                                                                          
//
void Use_Int_08();
#pragma aux Use_Int_08 "_*" modify [eax]


//Ŀ
//Change Synchro Int 08   Change frequency for Interupt 08                  
//                        Defaults frequency is 70Hz                        
//                                                                          
//
void Change_Synchro_Int_08(short Value);
#pragma aux Change_Synchro_Int_08 "_*" modify [eax] parm [bx]


//Ŀ
//Restore Video Mode   Restore the inital video which is be active at the   
//                     start of the program                                 
//                                                                          
//
void Restore_Video_Mode();
#pragma aux Restore_Video_Mode "_*" modify [eax]

//Ŀ
//Detect Windows       Detect If Windows is running                         
//                                                                          
//Other Registers Change : None                                             
//                                                                          
//
#define Windows_3x           3
#define Windows_95           4
unsigned char Detect_Windows();
#pragma aux Detect_Windows "_*" modify [eax] value [al]


//Ŀ
//Direct Send          Write a text directly to video ram . Color allowed   
//                                                                          
//Command : 0,0      = end                                                  
//          0,1..255 = color                                                
//          13       = first colonne                                        
//          10       = next ligne                                           
//                                                                          
//
void Direct_Send(char *Msg);
#pragma aux Direct_Send "_*" modify [eax edx] parm [edx]


//ͻ
//                                                                          
//                                 Files                                    
//                                                                          
//ͼ


//Ŀ
//Load Internal file   Load a file which is link with LLINK                 
//                     if the file is not present the program stop and      
//                     display a error message                              
//                                                                          
//
char *Load_Internal_File(char *File_Name,long *Size_File);
#pragma aux Load_Internal_File "_*" modify [eax ecx edx esi edi] value [eax] parm [edx] [ecx]


//Ŀ
//Load Internal file Handle  Load a file which is link with LLINK           
//                           if the file is not present the program stop    
//                           and display a error message                    
//                                                                          
//
char *Load_Internal_File_Handle(char *File_Name,long *Size_File,long *Handle_File);
#pragma aux Load_Internal_File_Handle "_*" modify [eax ecx edx esi edi] value [eax] parm [edx] [ecx] [edi]


//Ŀ
//Load External file   Load a external file and uncompress it if it has     
//                     been compress with Diet 1.44                         
//                                                                          
//
char *Load_External_File(char *File_Name,long *Size_File);
#pragma aux Load_External_File "_*" modify [eax ecx edx esi edi] value [eax] parm [edx] [ecx]


//Ŀ
//Load External file Handle  Load a external file and uncompress it if it   
//                           has been compress with Diet 1.44               
//                                                                          
//
char *Load_External_File_Handle(char *File_Name,long *Size_File,long *Handle_File);
#pragma aux Load_External_File_Handle "_*" modify [eax ecx edx esi edi] value [eax] parm [edx] [ecx] [edi]


//Ŀ
//Write External File  Save a File on a Disk                                
//                                                                          
//
long Write_External_File(char *File_Name,long *Addr_File,long *Size_File);
#pragma aux Write_External_File "_*" modify [eax ebx ecx edx esi edi] value [eax] parm [edx] [esi] [ecx]

//ͻ
//                                                                          
//                           Memory Allocation                              
//                                                                          
//ͼ

//Ŀ
//DeAllocate Memory Handle  Free the allocate memory with this handle       
//                                                                          
//
void DeAllocate_Memory_Handle(long Handle_Memory);
#pragma aux DeAllocate_Memory_Handle "_*" modify [eax edi] parm [edi]

//Ŀ
//Allocate Selector   Create a new selector                                 
//                                                                          
//
long Allocate_Selector(char *VRAM_Addr, long VRAM_Size);
#pragma aux Allocate_Selector "_*" modify [eax esi edi] parm [esi edi] value [eax]

//Ŀ
//DeAllocate Selector       Free a selector                                 
//                                                                          
//
long DeAllocate_Selector(long Handle_selector);
#pragma aux DeAllocate_Selector "_*" modify [eax ebx] parm [ebx]


//ͻ
//                                                                          
//                              Synchronization                             
//                                                                          
//ͼ


//Ŀ
//Wait Vbl   Wait the vertical retrace                                      
//                                                                          
//
long Wait_Vbl();
#pragma aux Wait_Vbl "_*" modify [eax] value [eax]


//ͻ
//                                                                          
//                              Diamond Player                              
//                                                                          
//ͼ
#define  No_Card    0
#define  Sb_10      01h
#define  Sb_15      02h
#define  Sb_20      03h
#define  Sb_Pro     04h
#define  Sb_16      05h
#define  Sb_Awe     06h
#define  Gravis     10h
#define  Gravis_Max 11h
#define  Gravis_Ace 12h
#define  Gravis_Pnp 13h
#define  WSS        20h

//Ŀ
//Detect Sound Card   Detect with the environment variable the sound        
//                    card installed                                        
//                                                                          
//
int Detect_Sound_Card(int Display,int *Port,int *Irq,int *Dma,int *Infos);
#pragma aux Detect_Sound_Card "_*"  modify [eax ebx ecx edx esi edi] parm [ecx] [ebx] [edx] [esi] [edi]


//Ŀ
//Load Module   Load a module & initialize into the memory                  
//                                                                          
//
long Load_Module(char *File_Name,unsigned char type,int Replay,int Sfx_Channel);
#pragma aux Load_Module "_*" modify [eax ebx ecx edx esi edi] value [eax] parm [edx] [eax] [ebx] [ecx]


//Ŀ
//Play Module   Start playing the module                                    
//                                                                          
//
void Play_Module();
#pragma aux Play_Module "_*" modify [eax]


//Ŀ
//Stop Module   Stop playing the module                                     
//                                                                          
//
void Stop_Module();
#pragma aux Stop_Module "_*" modify [eax]


//Ŀ
//Clear Module   Unload the module from memory                              
//                                                                          
//
void Clear_Module();
#pragma aux Clear_Module "_*" modify [eax]


//Ŀ
//Set Volume   Set the master volume of the module                          
//                                                                          
//
void Set_Volume(unsigned char Volume,unsigned char Sfx_Volume);
#pragma aux Set_Volume "_*" modify [eax ecx edx] parm [cl] [dl]

//Ŀ
//Play Sample   Play a sample include into the module                       
//                                                                          
//
void Play_Sample(int Num_Sample,int Frequence,int Voice);
#pragma aux Play_Sample "_*" modify [eax ebx ecx edx] parm [ebx] [ecx] [edx]


//Ŀ
//Get Info   Get information about the module when playing                  
//                                                                          
//
void Get_Info(unsigned char *Position,unsigned char *Pattern,unsigned char *Note,unsigned char *Volume,unsigned char *Sfx_Volume);
#pragma aux Get_Info "_*" modify [eax ebx ecx edx esi] parm [eax] [ebx] [ecx] [edx] [esi]


//Ŀ
//Set Pattern  Set the current position of the playing module               
//                                                                          
//
void Set_Pattern(int Position,int Note);
#pragma aux Set_Pattern "_*" parm [ebx] [ecx] modify [eax ecx edx]


//ͻ
//                                                                          
// Monochrome display                                                       
//                                                                          
//ͼ

//Ŀ
//Set Mono   Force On/Off the display of all the Monochrome Function        
//                                                                          
//
void Set_Mono(unsigned char Value);
#pragma aux Set_Mono "_*" parm [ebx] modify [eax]


//Ŀ
//Set String Mono   Display a string on the Monochrome adapter              
//                                                                          
//
void Set_String_Mono(char *Msg,int X,int Y);
#pragma aux Set_String_Mono "_*" parm [edx] [ebx] [ecx] modify [eax ebx ecx edx]


//Ŀ
//Set Value Mono   Display A Word in Hexadecimal on the Monochrome adapter  
//                                                                          
//
void Set_Value_Mono(long Value,int X,int Y);
#pragma aux Set_Value_Mono "_*" parm [edx] [ebx] [ecx] modify [eax ebx ecx edx]


//ͻ
//                                                                          
// EOS Library                                                              
//                                                                          
//ͼ


//ͻ
//                                                                          
// VESA                                                                     
//                                                                          
//ͼ

//Ŀ
//Init Vesa   Initialize A Vesa video mode                                  
//                                                                          
//
char *Init_Vesa(int Vesa_Mode);
#pragma aux Init_Vesa parm [eax] modify [eax ebx ecx edx esi edi] value [eax]


//Ŀ
//Init Vesa2  Initialize A Vesa 2.0 Linear FrameBuffer mode                 
//                                                                          
//
char *Init_Vesa2(long Vesa_Mode,long Vesa_Size);
#pragma aux Init_Vesa2 parm [eax] [ecx] modify [eax ebx ecx edx esi edi] value [eax]


//Ŀ
//Init Vesa Bank  Init the Automatic Bank Switching                         
//                                                                          
//
long Init_Vesa_Bank();
#pragma aux Init_Vesa_Bank modify [eax ebx ecx edx esi edi] value [ebx]


//ͻ
//                                                                          
// FLI32                                                                    
//                                                                          
//ͼ

extern char Fli_Err;
extern char Fli_Svga;
extern char Fli_Swap;
extern char Fli_ReStart;
extern char Fli_Loop;
extern char Fli_TrackDisk;
extern char Fli_Last_Frame;
extern char Fli_Ligne_Shl;
extern int  Fli_Selector;
extern long Fli_Delay;
extern long Fli_Buffer;
extern long Fli_Scr_X;
extern long Fli_Scr_Y;
extern long Fli_Decal_Y;
extern long Fli_Decal_X;
extern long Fli_Current_Frame;

//Ŀ
//                                                                          
// Load_Fli(*adrs_file_name)                                                
//                                                                          
// Cette routine charge et vrifie le header d'un fichier FLI ou FLC        
//                                                                          
//
long Load_Fli(char *File_Name);
#pragma aux Load_Fli modify [eax ebx ecx edx esi edi] value [eax] parm [edx]

//Ŀ
//                                                                          
// First_Frame_Fli()                                                        
//                                                                          
// Cette routine dcompresse la premire image d'un fichier FLI ou FLC      
//                                                                          
//
void First_Frame_Fli();
#pragma aux First_Frame_Fli modify [eax ebx ecx edx esi edi]

//Ŀ
//                                                                          
// Next_Frame_Fli()                                                         
//                                                                          
// Cette routine dcompresse la prochaine image d'un fichier FLI ou FLC     
//                                                                          
//
void Next_Frame_Fli();
#pragma aux Next_Frame_Fli modify [eax ebx ecx edx esi edi]

//Ŀ
//                                                                          
// Dispose_Fli()                                                            
//                                                                          
// Cette routine libre la mmoire alloue par la fonction Load_Fli         
//                                                                          
//
void Dispose_Fli();
#pragma aux Dispose_Fli modify [eax ebx ecx edx esi edi]


//ͻ
//                                                                          
// SNAP                                                                     
//                                                                          
//ͼ

//Ŀ
//Snap        Grab a 256 Colors screen in Non-Mode and save it in IFF format
//            Scroll Lock to lunch it                                       
//

//Ŀ
//Init Snap   Initialize the screen grabber . (You can change the int 09    
//            function Use_Int_09 after this Init                           
//                                                                          
//
void Init_Snap();

//Ŀ
//Snap IFF    Grab the current Screen from Video RAM                        
//                                                                          
//
void Snap_Iff();

//Ŀ
//Save IFF    Save a buffer to IFF                                          
//                                                                          
//
void Save_Iff(int X,int Y,char *File_Name,char *Addr_File);
#pragma aux Save_Iff parm [eax] [ebx] [edx] [esi] modify [eax ebx edx esi]


//ͻ
//                                                                          
// MEMORY                                                                   
//                                                                          
//ͼ

//Ŀ
//Init_Memory    Turn the display memory on                                 
//                                                                          
//In :                                                                      
//                                                                          
//Out :                                                                     
//                                                                          
//Other Registers Change : None                                             
//                                                                          
//
void Init_Memory();


//ͻ
//                                                                          
// The 32bit debugger                                                       
//                                                                          
//ͼ

void Debug();
void Debug_Back();

void Break_Point();
#pragma aux Break_Point = "int 3";

//ͻ
//                                                                          
// The EOS Emulation when using WATCON                                      
//                                                                          
//ͼ

void Init_EOS();
#pragma aux     Init_EOS "*"


#ifdef __cplusplus
};
#endif

#endif