//ͻ
//                                                                          
// This example show how to use FLI32 library with Linear Frame Buffer      
//                                                                          
//                                                                          
//                                                                          
//ͼ

#include <stdlib.h>
#include "..\resource\eos.h"
#include <process.h>

void main(int argn, char **argv)
{
   char *Addr_Buffer;
    Init_EOS();

    Addr_Buffer=Init_Vesa2(0x101,640*480);
    Fli_Selector=Allocate_Selector(Addr_Buffer,0x0ffff);

    if (Load_Fli("..\\data\\test.flc")==NULL)
       Exit_Error ("     File not found !\x0D\x0A\x24");

    if (Addr_Buffer==NULL)
       Exit_Error ("     Mode SVGA not supported or VESA not found ! \x0D\x0A" \
                   "      To install a vesa driver, refer to your video card documentation. \x0D\x0A\x24");

    Fli_Scr_X=640;
    Fli_Scr_Y=480;
    Fli_Ligne_Shl=7;
    Fli_Svga=Off;               // Off = VGA ou VESA2    On = VESA1
    Fli_Decal_X=(640/2)-160;
    Fli_Decal_Y=(480/2)-100;

    First_Frame_Fli();
    while ( !kbhit() )
    {
      Wait_Vbl();
      Next_Frame_Fli();
    }
    Dispose_Fli();
  exit (0);
}