INT_F    PROC     NEAR
;***************************************************************
;                    rounds and converts a floating point number
;                    to a signed 32-bit integer
;***************************************************************
         PUSH     SI              ;save index registers
         PUSH     DI   
         CALL     RN_F            ;round to nearest integer
                                  ;rounded result now in DX:AX
         SUB      CX,CX           ;clear CX
         MOV      DI,10000000B    ;isolate sign in DI
         AND      DI,DX
         OR       DL,10000000B    ;restore leading 1
;
         MOV      CL,DH           ;exponent in CX
         SUB      DH,DH           ;clear DH
         SUB      CX,128          ;remove exponent bias
;                            exponent in range 0 < exponent <=31?
         JLE      INT7            ;return 0 result with underflow
         CMP      CX,32           ;must be less than 32
         JGE      INT8            ;return overflow
;                            shift left or right
         SUB      CX,24
         JE       INT4            ;if exponent = 24, no shift
         JL       INT2            ;if exponent < 24, shift right
INT1:    SHL      AX,1            ;shift left
         RCL      DX,1
         LOOP     INT1
         JMP      INT4
;                            shift right
INT2:    NEG      CX
INT3:    SHR      DX,1
         RCR      AX,1
         LOOP     INT3
;
INT4:    SUB      BX,BX           ;completion status=0  OK
;                            check sign
INT5:    OR       DI,DI
         JZ       INT6            ;if number was negative
         NOT      DX              ;negate it
         NOT      AX
         ADD      AX,1
         ADC      DX,0
;
INT6:    JMP      EXIT
INT7:    JMP      UNDER_F
INT8:    MOV      DX,7FFFH        ;return maximum signed integer
         MOV      AX,0FFFFH
         MOV      BX,1            ;completion status=+1
         JMP      INT5            ;check sign
INT_F    ENDP