/****************************************************************************/

 typedef unsigned char  BYTE;
 typedef unsigned short WORD;
 typedef unsigned long  XPTR;

/****************************************************************************/

 #define CPU_8086   0
 #define CPU_80286  2
 #define CPU_80386  3
 #define CPU_80386p 4

 #define MAX_EMB 32

 #define CF_SET  (_FLAGS & 1)
 #define CF_CLR !(_FLAGS & 1)

/****************************************************************************/

 enum PM           { PM_NA=0xFF, PM_OK=0, PM_V86, PM_DPMS, PM_PHAR_LAP, PM_DOS4GW, PM_DOSX, PM_DPMI };
 enum XMS_INIT_ERR { XMS_NOT_INSTALLED=0, XMS_BAD_VERSION, XMS_BAD_A20 };
 enum GET_RAM_ERR  { NO_FREE_RAM=0, NO_FREE_EMB, CANT_LOCK_XMS };

/****************************************************************************/

 extern pascal unsigned char CPU;

/****************************************************************************/

 extern pascal WORD FRMI_START(void);
 extern pascal WORD TEST_CPU(void);
 extern pascal WORD XMS_INIT(void);
 extern pascal WORD XMS_LOCAL_ENABLE_A20(void);
 extern pascal WORD XMS_QUERY_FREE(void);
 extern pascal WORD XMS_ALLOC(WORD KBYTES);
 extern pascal WORD XMS_FREE(WORD HANDLE);
 extern pascal XPTR XMS_LOCK(WORD HANDLE);
 extern pascal WORD XMS_UNLOCK(WORD HANDLE);
 extern pascal WORD XMS_REALLOC(WORD HANDLE, WORD NEW_SIZE);
 extern pascal WORD QUERY_FREE_RAM(void);
 extern pascal XPTR GET_RAM(WORD KBYTES);
 extern pascal void FREE_RAM(XPTR ADDRESS);

/****************************************************************************/
