
;----------------------------------------------------
;
;       MASTER -- remotely control a PC across
;       a Netbios LAN. (see SLAVE.ASM)
;
;       Test version 0.9
;
;       (c) 1990 Barry Nance
;
;----------------------------------------------------

                DOSSEG
                .MODEL small

StdIn           =       0000
StdOut          =       0001
StdErr          =       0002

RESET                   =       032h
CANCEL                  =       035h
STATUS                  =       0b3h
STATUS_WAIT             =       033h
TRACE                   =       0f9h
TRACE_WAIT              =       079h
UNLINK                  =       070h
ADD_NAME                =       0b0h
ADD_NAME_WAIT           =       030h
ADD_GROUP_NAME          =       0b6h
ADD_GROUP_NAME_WAIT     =       036h
DELETE_NAME             =       0b1h
DELETE_NAME_WAIT        =       031h
CALL_CMD                =       090h
CALL_WAIT               =       010h
LISTEN                  =       091h
LISTEN_WAIT             =       011h
HANG_UP                 =       092h
HANG_UP_WAIT            =       012h
SEND                    =       094h
SEND_WAIT               =       014h
SEND_NO_ACK             =       0f1h
SEND_NO_ACK_WAIT        =       071h
CHAIN_SEND              =       097h
CHAIN_SEND_WAIT         =       017h
CHAIN_SEND_NO_ACK       =       0f2h
CHAIN_SEND_NO_ACK_WAIT  =       072h
RECEIVE                 =       095h
RECEIVE_WAIT            =       015h
RECEIVE_ANY             =       096h
RECEIVE_ANY_WAIT        =       016h
SESSION_STATUS          =       0b4h
SESSION_STATUS_WAIT     =       034h
SEND_DATAGRAM           =       0a0h
SEND_DATAGRAM_WAIT      =       020h
SEND_BCST_DATAGRAM      =       0a2h
SEND_BCST_DATAGRAM_WAIT =       022h
RECEIVE_DATAGRAM        =       0a1h
RECEIVE_DATAGRAM_WAIT   =       021h
RECEIVE_BCST_DATAGRAM   =       0a3h
RECEIVE_BCST_DATAGRAM_WAIT =    023h

NCB             struc
    COMMAND     db      ?
    RETCODE     db      ?
    LSN         db      ?
    NUM         db      ?
    BUFFER_PTR  dd      ?
    LEN         dw      ?
    CALLNAME    db      16 dup (?)
    OURNAME     db      16 dup (?)
    RTO         db      ?
    STO         db      ?
    POST_FUNC   dd      ?
    LANA_NUM    db      ?
    CMD_CPLT    db      ?
    RESERVE     db      14 dup (?)
NCB             EndS

                .DATA

Msg2            DB      "Looking for SLAVE -- Press ESC to quit."
                DB      13, 10
Msg2Len         =       $-Msg2

Msg3            DB      "Early versions of DOS not supported."
                DB      13, 10
Msg3Len         =       $-Msg3

Msg4            DB      "ERROR--NETBIOS not active."
                DB      13, 10
Msg4Len         =       $-Msg4

Msg5            DB      "Adding name to network..."
                DB      13, 10
Msg5Len         =       $-Msg5

Msg6            DB      "ERROR -- SLAVE not found."
                DB      13, 10
Msg6Len         =       $-Msg6

Msg8            DB      13, 10, 13, 10
                DB      "MASTER finished."
                DB      13, 10
Msg8Len         =       $-Msg8

dos_major       DB      0
dos_minor       DB      0

EGAFlagPtr      Label   DWord
EGAFlagOfs      DW      0487h
EGAFlagSeg      DW      0

VideoPtr        Label   DWord
VideoOfs        DW      0
VideoSeg        DW      0

Done            DB      1
OurNameNumber   DB      0

LocSave         DW      0
ShapeSave       DW      0

slave_name      DB      "Slave          "
                DB      0
master_name     DB      "Master         "
                DB      0

send_ncb        NCB     <>
recv_ncb        NCB     <>
add_name_ncb    NCB     <>
delete_name_ncb NCB     <>
cncl_ncb        NCB     <>

Screen_Data     Label   Byte
  ScreenPos     DW      0
  CursorShape   DW      0
  CursorLoc     DW      0
  Head2         DW      0
  ScreenPkt     DB      500 Dup(0)

Kbd_Data        Label   Byte
  KbdFlag1      DB      0
  KbdFlag2      DB      0
  AltInput      DB      0
  Sess_Flag     DW      0
  Tail          DW      0
  KbdBuffer     DW      16 Dup(0)

                .STACK 200h
                .CODE
scan_code       DB      0
In_Int10        DB      0

oldint09        Label   DWord
oldint09_ofs    DW      0
oldint09_seg    DW      0

oldint10        Label   DWord
oldint10_ofs    DW      0
oldint10_seg    DW      0

SS_Save1        DW      0
SP_Save1        DW      0
StackSeg1       DW      0
StackOfs1       DW      0

                DW      256 Dup(0)
OurStack1       DW      0

SS_Save2        DW      0
SP_Save2        DW      0
StackSeg2       DW      0
StackOfs2       DW      0

                DW      256 Dup(0)
OurStack2       DW      0

;---------------------------------------

                Assume  CS:_TEXT, DS:_DATA, ES:Nothing

Add_Our_Name    Proc    Near
                mov     add_name_ncb.COMMAND, ADD_NAME
                push    ds
                pop     es
                mov     si, offset master_name
                mov     di, offset add_name_ncb.OURNAME
                mov     cx, 8
        rep     movsw
                mov     word ptr add_name_ncb.POST_FUNC+2, 0
                mov     word ptr add_name_ncb.POST_FUNC, 0
                mov     add_name_ncb.CMD_CPLT, 0FFh
                mov     bx, offset add_name_ncb
                Int     5Ch

wait_add:       cmp     add_name_ncb.CMD_CPLT, 0FFh
                je      wait_add
                ret
Add_Our_Name    EndP


Delete_Our_Name Proc    Near
                push    ds
                pop     es
                mov     delete_name_ncb.COMMAND, DELETE_NAME
                mov     si, offset master_name
                mov     di, offset delete_name_ncb.OURNAME
                mov     cx, 8
        rep     movsw
                mov     word ptr delete_name_ncb.POST_FUNC+2, 0
                mov     word ptr delete_name_ncb.POST_FUNC, 0
                mov     delete_name_ncb.CMD_CPLT, 0FFh
                mov     bx, offset delete_name_ncb
                Int     5Ch

wait_delete:    cmp     delete_name_ncb.CMD_CPLT, 0FFh
                je      wait_delete
                ret
Delete_Our_Name EndP



Cancel_Recv     Proc    Near
                push    ds
                pop     es
                mov     cncl_ncb.COMMAND, CANCEL
                mov     ax, offset recv_ncb
                mov     word ptr cncl_ncb.BUFFER_PTR, ax
                mov     word ptr cncl_ncb.BUFFER_PTR+2, ds
                mov     bx, offset cncl_ncb
                int     5Ch
                ret
Cancel_Recv     EndP


;
;       enter Receive with:
;       DX:AX - address of buffer
;       CX    - number of bytes to receive
;       BP:BX - address of POST routine
;

Recv_Msg        Proc    Near
                push    ds
                pop     es
                mov     recv_ncb.COMMAND, RECEIVE_DATAGRAM
                push    ax
                mov     al, OurNameNumber
                mov     recv_ncb.NUM, al
                pop     ax
                mov     recv_ncb.LEN, CX
                mov     word ptr recv_ncb.BUFFER_PTR+2, dx
                mov     word ptr recv_ncb.BUFFER_PTR, ax
                mov     word ptr recv_ncb.POST_FUNC+2, bp
                mov     word ptr recv_ncb.POST_FUNC, bx
                mov     recv_ncb.CMD_CPLT, 0FFh
                mov     bx, offset recv_ncb
                Int     5Ch
                ret
Recv_Msg        EndP

;---------------------------------------

;
;       enter Send with:
;       DX:AX - address of buffer
;       CX    - number of bytes to send
;       BP:BX - address of POST routine
;       DS:SI - address of destination name
;

Send_Msg        Proc    Near
                push    ds
                pop     es
                mov     send_ncb.COMMAND, SEND_DATAGRAM
                lea     di, send_ncb.CALLNAME
                push    cx
                mov     cx, 8
        rep     movsw
                pop     cx
                push    ax
                mov     al, OurNameNumber
                mov     send_ncb.NUM, al
                pop     ax
                mov     send_ncb.LEN, cx
                mov     word ptr send_ncb.BUFFER_PTR+2, dx
                mov     word ptr send_ncb.BUFFER_PTR, ax
                mov     word ptr send_ncb.POST_FUNC+2, bp
                mov     word ptr send_ncb.POST_FUNC, bx
                mov     send_ncb.CMD_CPLT, 0FFh
                mov     bx, offset send_ncb
                Int     5Ch
                ret
Send_Msg        EndP

;---------------------------------------

                Assume  CS:_TEXT, DS:Nothing, ES:Nothing

Int_09:         sti
                push    ax

I9_get_scan:    in      al, 60h
                mov     cs:scan_code, al
                pop     ax

I9_chain_old:   pushf
                cli
                call    cs:oldint09

                cli
                mov     cs:SS_Save1, ss
                mov     cs:SP_Save1, sp
                mov     ss, cs:StackSeg1
                mov     sp, cs:StackOfs1
                sti

I9_save_regs:   push    ax
                push    bx
                push    cx
                push    dx
                push    si
                push    di
                push    bp
                push    ds
                push    es

                Assume  CS:_TEXT, DS:_DATA, ES:Nothing
                mov     ax, @DATA
                mov     ds, ax
                cld

ChkCtrl5:       mov     ax, 0040h
                mov     es, ax
                test    byte ptr es:[0017h], 04h    ; Ctrl
                jz      NotCtrl5
                cmp     cs:scan_code, 4Ch           ; Center 5
                je      SayToQuit

NotCtrl5:       jmp     I9_SendKbd

SayToQuit:      mov     Done, 1

I9_ChkLastSend: cmp     send_ncb.CMD_CPLT, 0FFh
                je      I9_ChkLastSend

                mov     Sess_Flag, -1
                mov     dx, ds
                mov     ax, offset Kbd_Data
                mov     cx, 39
                mov     bp, 0
                mov     bx, 0
                mov     si, offset slave_name
                call    Send_Msg

GotoExit:       jmp     Int09Exit


I9_SendKbd:     cmp     Done, 0
                je      Chk_Changed

                jmp     Int09Exit

Chk_Changed:    mov     ax, 0040h
                mov     es, ax

                mov     al, es:[0017h]
                cmp     al, KbdFlag1
                jne     I9_Send_It

                mov     al, es:[0018h]
                cmp     al, KbdFlag2
                jne     I9_Send_It

                mov     ax, es:[001Ch]
                cmp     ax, Tail
                jne     I9_Send_It

                jmp     short Int09Exit

I9_Send_It:     cmp     send_ncb.CMD_CPLT, 0FFh
                je      GotoExit

I9_SaveKbd:     push    ds
                pop     es
                mov     ax, 0040h
                mov     ds, ax
                mov     si, 0017h
                mov     di, offset Kbd_Data
                mov     cx, 39
        rep     movsb
                push    es
                pop     ds
                mov     Sess_Flag, 0

                mov     dx, ds
                mov     ax, offset Kbd_Data
                mov     cx, 39
                mov     bp, 0
                mov     bx, 0
                mov     si, offset slave_name
                call    Send_Msg

Int09Exit:      Assume  CS:_TEXT, DS:Nothing
                pop     es
                pop     ds
                pop     bp
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     bx
                pop     ax

I9_Sw_Stack2:   cli
                mov     ss, cs:SS_Save1
                mov     sp, cs:SP_Save1

                iret

;---------------------------------------

Int_10:         mov     cs:In_Int10, 1
                pushf
                call    cs:OldInt10
                mov     cs:In_Int10, 0
                iret

;---------------------------------------

ScreenRecv:     mov     cs:SS_Save2, ss
                mov     cs:SP_Save2, sp
                mov     ss, cs:StackSeg2
                mov     sp, cs:StackOfs2

                sti
                cld
                push    ax
                push    bx
                push    cx
                push    dx
                push    si
                push    di
                push    bp
                push    ds
                push    es

                Assume  CS:_TEXT, DS:_DATA, ES:Nothing
                mov     ax, @DATA
                mov     ds, ax

                cmp     Done, 0
                je      Chk_RetCode

                jmp     ScreenRecvExit

Chk_RetCode:    cmp     recv_ncb.CMD_CPLT, 0
                je      EchoScreen

                jmp     RecvScreen2

EchoScreen:     les     di, VideoPtr
                add     di, ScreenPos
                mov     si, offset ScreenPkt
                mov     cx, 250
        rep     movsw

CheckIn10:      cmp     cs:In_Int10, 1
                je      Set_Head

CheckShape:     mov     cx, CursorShape
                cmp     cx, ShapeSave
                je      CheckLocation
                mov     ShapeSave, cx
                mov     ah, 1
                int     10h

CheckLocation:  mov     dx, CursorLoc
                cmp     dx, LocSave
                je      Set_Head
                mov     LocSave, dx
                mov     bh, 0
                mov     ah, 2
                int     10h

Set_Head:       mov     ax, 0040h
                mov     es, ax
                cli
                mov     ax, Head2
                mov     word ptr es:[001Ah], ax
                sti

RecvScreen2:    mov     dx, ds
                mov     ax, offset Screen_Data
                mov     cx, 508
                mov     bp, cs
                mov     bx, offset ScreenRecv
                call    Recv_Msg

ScreenRecvExit: Assume  CS:_TEXT, DS:Nothing
                pop     es
                pop     ds
                pop     bp
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     bx
                pop     ax

                cli
                mov     ss, cs:SS_Save2
                mov     sp, cs:SP_Save2

                iret

;---------------------------------------

Start:          Assume  CS:_TEXT, DS:_DATA, ES:Nothing
                mov     ax, @DATA
                mov     ds, ax

                mov     ax, cs
                mov     cs:StackSeg1, ax
                mov     ax, offset OurStack1
                mov     cs:StackOfs1, ax

                mov     ax, cs
                mov     cs:StackSeg2, ax
                mov     ax, offset OurStack2
                mov     cs:StackOfs2, ax

get_dos_vers:   mov     ax, 3000h
                int     21h
                mov     dos_major, al
                mov     dos_minor, ah
                cmp     al, 2
                ja      netbios_test1

wrong_dos:      mov     bx, 2
                mov     dx, offset Msg3
                mov     cx, Msg3Len
                mov     ah, 40h
                int     21h

                mov     ax, 4C00h
                int     21h

netbios_test1:  mov     ax, 0
                mov     es, ax
                cmp     word ptr es:[0170h], 0
                jne     netbios_test2

no_netbios:     mov     bx, 2
                mov     dx, offset Msg4
                mov     cx, Msg4Len
                mov     ah, 40h
                int     21h

                mov     ax, 4C00h
                int     21h

netbios_test2:  mov     send_ncb.COMMAND, 7Fh
                mov     send_ncb.RETCODE, 0
                mov     send_ncb.CMD_CPLT, 0FFh
                mov     ax, ds
                mov     es, ax
                mov     bx, offset send_ncb
                Int     5Ch
                cmp     send_ncb.RETCODE, 3
                jne     no_netbios

bw_or_color:    mov     ah, 0Fh
                int     10h
                Cmp     AL, 7
                JE      SetMono
                Jmp     LookFurther

SetMono:        Mov     VideoSeg, 0B000h
                Mov     VideoOfs, 0000
                Jmp     network_name

LookFurther:    Mov     bx, 0FF10h
                Mov     ah, 12h
                Int     10h
                Test    bh, 0FEh
                JZ      EGAPresent
                Jmp     SetCGA

EGAPresent:     LES     BX, EGAFlagPtr
                Mov     AL, Byte Ptr ES:[BX]
                Test    AL, 00000101b
                JNZ     SetCGA
                Test    AL, 00000100b
                JNZ     SetMono
                Test    AL, 00000001b
                JNZ     SetMono

EGAIsActive:    Mov     VideoSeg, 0B800h
                Mov     VideoOfs, 0000
                Jmp     network_name

SetCGA:         Mov     VideoSeg, 0B800h
                Mov     VideoOfs, 0000

network_name:   mov     bx, 2
                mov     dx, offset Msg5
                mov     cx, Msg5Len
                mov     ah, 40h
                int     21h

                call    Add_Our_Name
                mov     al, add_name_ncb.NUM
                mov     OurNameNumber, al
                cmp     add_name_ncb.CMD_CPLT, 0
                je      say_hello
                jmp     prog_exit

say_hello:      mov     bx, 2
                mov     dx, offset Msg2
                mov     cx, Msg2Len
                mov     ah, 40h
                int     21h

Ping_Slave:     mov     Sess_Flag, 1
                mov     dx, ds
                mov     ax, offset Kbd_Data
                mov     cx, 39
                mov     bp, 0
                mov     bx, 0
                mov     si, offset slave_name
                call    Send_Msg

                mov     dx, ds
                mov     ax, offset Screen_Data
                mov     cx, 8
                mov     bp, 0
                mov     bx, 0
                call    Recv_Msg

Wait_Ping:      cmp     recv_ncb.CMD_CPLT, 0FFh
                jne     Pinged_Back
                mov     ah, 1
                int     16h
                jz      Wait_Ping
                mov     ah, 0
                int     16h
                cmp     al, 27
                jne     Wait_Ping

Ping_Error:     mov     bx, 2
                mov     dx, offset Msg6
                mov     cx, Msg6Len
                mov     ah, 40h
                int     21h
                call    Delete_Our_Name
                jmp     prog_exit

Pinged_Back:    cmp     recv_ncb.CMD_CPLT, 0
                jne     Ping_Error

ChkPing:        cmp     ScreenPos, -1
                jne     Ping_Error

ResetKBD:       mov     ax, 0040h
                mov     es, ax
                cli
                mov     byte ptr es:[0017h], 0
                mov     byte ptr es:[0018h], 0
                mov     ax, word ptr es:[0080h]
                mov     word ptr es:[001Ah], ax
                mov     word ptr es:[001Ch], ax
                sti
                mov     ax, ds
                mov     es, ax

save_int9:      mov     ax, 3509h
                int     21h
                mov     cs:oldint09_seg, ES
                mov     cs:oldint09_ofs, BX

save_int10:     mov     ax, 3510h
                int     21h
                mov     cs:oldint10_seg, ES
                mov     cs:oldint10_ofs, BX

install_int9:   push    ds
                mov     dx, offset Int_09
                push    cs
                pop     ds
                mov     ax, 2509h
                int     21h
                pop     ds

install_int10:  push    ds
                mov     dx, offset Int_10
                push    cs
                pop     ds
                mov     ax, 2510h
                int     21h
                pop     ds

RecvScreen:     mov     dx, ds
                mov     ax, offset Screen_Data
                mov     cx, 508
                mov     bp, cs
                mov     bx, offset ScreenRecv
                call    Recv_Msg

                mov     Done, 0
while_not_done: cmp     Done, 0
                je      while_not_done

deinstall_int9: push    ds
                mov     dx, cs:oldint09_ofs
                mov     ds, cs:oldint09_seg
                mov     ax, 2509h
                int     21h
                pop     ds

deinstall_10:   push    ds
                mov     dx, cs:oldint10_ofs
                mov     ds, cs:oldint10_seg
                mov     ax, 2510h
                int     21h
                pop     ds

ResetKBD2:      mov     ax, 0040h
                mov     es, ax
                cli
                mov     byte ptr es:[0017h], 0
                mov     byte ptr es:[0018h], 0
                mov     ax, word ptr es:[0080h]
                mov     word ptr es:[001Ah], ax
                mov     word ptr es:[001Ch], ax
                sti
                mov     ax, ds
                mov     es, ax

CnclRecv:       call    Cancel_Recv
remove_name:    call    Delete_Our_Name

prog_exit:      mov     bx, 2
                mov     dx, offset Msg8
                mov     cx, Msg8Len
                mov     ah, 40h
                int     21h

                mov     ax, 4C00h
                int     21h

                End     Start


