
;----------------------------------------------------
;
;       SLAVE -- allow another PC (on a Netbios LAN)
;       to control this one.  (see MASTER.ASM)
;
;       Test version 0.9
;
;       (c) 1990 Barry Nance
;
;----------------------------------------------------

                DOSSEG
                .MODEL small

StdIn           =       0000
StdOut          =       0001
StdErr          =       0002

RESET                   =       032h
CANCEL                  =       035h
STATUS                  =       0b3h
STATUS_WAIT             =       033h
TRACE                   =       0f9h
TRACE_WAIT              =       079h
UNLINK                  =       070h
ADD_NAME                =       0b0h
ADD_NAME_WAIT           =       030h
ADD_GROUP_NAME          =       0b6h
ADD_GROUP_NAME_WAIT     =       036h
DELETE_NAME             =       0b1h
DELETE_NAME_WAIT        =       031h
CALL_CMD                =       090h
CALL_WAIT               =       010h
LISTEN                  =       091h
LISTEN_WAIT             =       011h
HANG_UP                 =       092h
HANG_UP_WAIT            =       012h
SEND                    =       094h
SEND_WAIT               =       014h
SEND_NO_ACK             =       0f1h
SEND_NO_ACK_WAIT        =       071h
CHAIN_SEND              =       097h
CHAIN_SEND_WAIT         =       017h
CHAIN_SEND_NO_ACK       =       0f2h
CHAIN_SEND_NO_ACK_WAIT  =       072h
RECEIVE                 =       095h
RECEIVE_WAIT            =       015h
RECEIVE_ANY             =       096h
RECEIVE_ANY_WAIT        =       016h
SESSION_STATUS          =       0b4h
SESSION_STATUS_WAIT     =       034h
SEND_DATAGRAM           =       0a0h
SEND_DATAGRAM_WAIT      =       020h
SEND_BCST_DATAGRAM      =       0a2h
SEND_BCST_DATAGRAM_WAIT =       022h
RECEIVE_DATAGRAM        =       0a1h
RECEIVE_DATAGRAM_WAIT   =       021h
RECEIVE_BCST_DATAGRAM   =       0a3h
RECEIVE_BCST_DATAGRAM_WAIT =    023h

NCB             struc
    COMMAND     db      ?
    RETCODE     db      ?
    LSN         db      ?
    NUM         db      ?
    BUFFER_PTR  dd      ?
    LEN         dw      ?
    CALLNAME    db      16 dup (?)
    OURNAME     db      16 dup (?)
    RTO         db      ?
    STO         db      ?
    POST_FUNC   dd      ?
    LANA_NUM    db      ?
    CMD_CPLT    db      ?
    RESERVE     db      14 dup (?)
NCB             EndS

                .DATA
EGAFlagPtr      Label   DWord
EGAFlagOfs      DW      0487h
EGAFlagSeg      DW      0

Msg1            DB      "SLAVE is now waiting for MASTER to make contact."
                DB      13, 10
Msg1Len         =       $-Msg1

Msg2            DB      "Early versions of DOS not supported."
                DB      13, 10
Msg2Len         =       $-Msg2

Msg3            DB      "Error--NETBIOS not active."
                DB      13, 10
Msg3Len         =       $-Msg3

Msg4            DB      "Adding name to network..."
                DB      13, 10
Msg4Len         =       $-Msg4

                .STACK 200h
                .CODE

;---------------------------------------

our_psp         DW      0
our_mcb_seg     DW      0
next_mcb_seg    DW      0
dos_major       DB      0
dos_minor       DB      0
SessionActive   DB      0
OurNameNumber   DB      0
InInt8          DB      0

slave_name      DB      "Slave          "
                DB      0
master_name     DB      "Master         "
                DB      0

send_ncb        NCB     <>
recv_ncb        NCB     <>
add_name_ncb    NCB     <>
delete_name_ncb NCB     <>

oldint08        Label   DWord
oldint08_ofs    DW      0
oldint08_seg    DW      0

VideoPtr        Label   DWord
VideoOfs        DW      0
VideoSeg        DW      0
ScreenSave      DB      4000 Dup(0)

Screen_Data     Label   Byte
  ScreenPos     DW      0
  CursorShape   DW      0
  CursorLoc     DW      0
  Head2         DW      0
  ScreenPkt     DB      500 Dup(0)

Kbd_Data        Label   Byte
  KbdFlag1      DB      0
  KbdFlag2      DB      0
  AltInput      DB      0
  Sess_Flag     DW      0
  Tail          DW      0
  KbdBuffer     DW      16 Dup(0)

QuadrantCounter DW      0
Quadrant        DW      8
Quadrant_Ofs    DW      0

SS_Save1        DW      0
SP_Save1        DW      0
StackSeg1       DW      0
StackOfs1       DW      0

                DW      256 Dup(0)
OurStack1       DW      0

SS_Save2        DW      0
SP_Save2        DW      0
StackSeg2       DW      0
StackOfs2       DW      0

                DW      256 Dup(0)
OurStack2       DW      0

;---------------------------------------

                Assume  CS:_TEXT, DS:_TEXT, ES:Nothing

Add_Our_Name    Proc    Near
                push    ds

                push    cs
                pop     ds
                push    cs
                pop     es

                mov     add_name_ncb.COMMAND, ADD_NAME
                mov     si, offset slave_name
                mov     di, offset add_name_ncb.OURNAME
                mov     cx, 8
        rep     movsw
                mov     word ptr add_name_ncb.POST_FUNC+2, 0
                mov     word ptr add_name_ncb.POST_FUNC, 0
                mov     add_name_ncb.CMD_CPLT, 0FFh
                mov     bx, offset add_name_ncb
                Int     5Ch

wait_add:       cmp     add_name_ncb.CMD_CPLT, 0FFh
                je      wait_add

                pop     ds
                ret
Add_Our_Name    EndP


;
;       enter Send with:
;       DX:AX - address of buffer
;       CX    - number of bytes to send
;       BP:BX - address of POST routine
;       DS:SI - address of destination name
;

Send_Msg        Proc    Near
                push    ds

                push    cs
                pop     ds
                push    cs
                pop     es

                mov     send_ncb.COMMAND, SEND_DATAGRAM
                lea     di, send_ncb.CALLNAME
                push    ax
                push    cx
                mov     cx, 8
        rep     movsw
                mov     al, OurNameNumber
                mov     send_ncb.NUM, al
                pop     cx
                pop     ax
                mov     send_ncb.LEN, cx
                mov     word ptr send_ncb.BUFFER_PTR+2, dx
                mov     word ptr send_ncb.BUFFER_PTR, ax
                mov     word ptr send_ncb.POST_FUNC+2, bp
                mov     word ptr send_ncb.POST_FUNC, bx
                mov     send_ncb.CMD_CPLT, 0FFh
                mov     bx, offset send_ncb
                int     5Ch

                pop     ds
                ret
Send_Msg        EndP


Recv_Msg        Proc    Near
                push    ds

                push    cs
                pop     ds
                push    cs
                pop     es

                push    ax
                mov     recv_ncb.COMMAND, RECEIVE_DATAGRAM
                mov     al, OurNameNumber
                mov     recv_ncb.NUM, al
                mov     recv_ncb.LEN, cx
                pop     ax
                mov     word ptr recv_ncb.BUFFER_PTR+2, dx
                mov     word ptr recv_ncb.BUFFER_PTR, ax
                mov     word ptr recv_ncb.POST_FUNC+2, bp
                mov     word ptr recv_ncb.POST_FUNC, bx
                mov     recv_ncb.CMD_CPLT, 0FFh
                mov     bx, offset recv_ncb
                Int     5Ch

                pop     ds
                ret
Recv_Msg        EndP


                Assume  CS:_TEXT, DS:Nothing, ES:Nothing

Int_08:         pushf
                call    cs:oldint08

I8_Sw_Stack1:   mov     cs:SS_Save1, ss
                mov     cs:SP_Save1, sp
                mov     ss, cs:StackSeg1
                mov     sp, cs:StackOfs1

                sti
                cld

I8_save_regs:   push    ax
                push    bx
                push    cx
                push    dx
                push    si
                push    di
                push    bp
                push    ds
                push    es

                Assume  CS:_TEXT, DS:_TEXT
                mov     ax, cs
                mov     ds, ax

                mov     QuadrantCounter, 0

I8_Semaphore:   Cmp     InInt8, 0
                JE      I8_Sess_Switch

                Jmp     I8_RestoreRegs

I8_Sess_Switch: cmp     SessionActive, 1
                je      I8_ChkHotIRQs

br_to_exit:     jmp     Int08Exit

I8_ChkHotIRQs:  mov     InInt8, 1
                Mov     AL, 0bh
                Out     20h, AL
                In      AL, 20h
                Cmp     AL, 0
                JE      I8_ChkScreen

                Jmp     Int08Exit

I8_ChkScreen:   cmp     send_ncb.CMD_CPLT, 0FFh
                je      br_to_exit

Next_Quadrant:  inc     Quadrant
                add     Quadrant_Ofs, 500
                cmp     Quadrant, 9
                jne     ChkThisSection

                mov     Quadrant, 1
                mov     Quadrant_Ofs, 0

ChkThisSection: les     di, VideoPtr
                mov     ax, Quadrant_Ofs
                mov     si, offset ScreenSave
                add     si, ax
                add     di, ax
                mov     cx, 250
        repe    cmpsw
                jne     I8_SaveScreen

                inc     QuadrantCounter
                cmp     QuadrantCounter, 8
                je      ChkShape
                jmp     I8_ChkScreen

ChkShape:       mov     ax, 0040h
                mov     es, ax
                mov     ax, word ptr es:[0060h]
                cmp     ax, CursorShape
                jne     I8_SaveScreen

                mov     ax, word ptr es:[0050h]
                cmp     ax, CursorLoc
                jne     I8_SaveScreen

                jmp     Int08Exit

I8_SaveScreen:  push    cs
                pop     es
                mov     ax, Quadrant_Ofs
                mov     di, offset ScreenSave
                lds     si, VideoPtr
                add     si, ax
                add     di, ax
                mov     cx, 250
        rep     movsw
                push    cs
                pop     ds

I8_BldPacket:   mov     ax, Quadrant_Ofs
                mov     ScreenPos, ax
                mov     ax, 0040h
                mov     es, ax
                mov     ax, word ptr es:[0060h]
                mov     CursorShape, ax
                mov     ax, word ptr es:[0050h]
                mov     CursorLoc, ax
                mov     ax, word ptr es:[001Ah]
                mov     Head2, ax

                mov     ax, cs
                mov     es, ax
                mov     si, offset ScreenSave
                add     si, Quadrant_Ofs
                mov     di, offset ScreenPkt
                mov     cx, 250
        rep     movsw

I8_SendScreen:  mov     dx, cs
                mov     ax, offset Screen_Data
                mov     cx, 508
                mov     bp, 0
                mov     bx, 0
                mov     si, offset master_name
                call    Send_Msg

Int08Exit:      mov     InInt8, 0

I8_RestoreRegs: pop     es
                pop     ds
                pop     bp
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     bx
                pop     ax

I8_Sw_Stack2:   cli
                mov     ss, cs:SS_Save1
                mov     sp, cs:SP_Save1

                iret

                Assume  CS:_TEXT, DS:Nothing

;---------------------------------------

Kbd_Receive:    mov     cs:SS_Save2, ss
                mov     cs:SP_Save2, sp
                mov     ss, cs:StackSeg2
                mov     sp, cs:StackOfs2

                sti
                cld
                push    ax
                push    bx
                push    cx
                push    dx
                push    si
                push    di
                push    bp
                push    ds
                push    es

                Assume  CS:_TEXT, DS:_TEXT
                mov     ax, cs
                mov     ds, ax

Chk_RetCode:    cmp     recv_ncb.CMD_CPLT, 0
                je      ChkDone

                jmp     KR_RecvKbd

ChkDone:        cmp     Sess_Flag, -1
                je      KR_CloseSess

                cmp     Sess_Flag, 1
                je      KR_OpenSess

                jmp     KR_StuffBuffer

KR_CloseSess:   mov     SessionActive, 0
                mov     ax, 0040h
                mov     es, ax
                cli
                mov     byte ptr es:[0017h], 0
                mov     byte ptr es:[0018h], 0
                mov     ax, word ptr es:[0080h]
                mov     word ptr es:[001Ah], ax
                mov     word ptr es:[001Ch], ax
                sti
                mov     ax, ds
                mov     es, ax
                jmp     KR_RecvKbd

KR_OpenSess:    mov     ax, 0040h
                mov     es, ax
                cli
                mov     byte ptr es:[0017h], 0
                mov     byte ptr es:[0018h], 0
                mov     ax, word ptr es:[0080h]
                mov     word ptr es:[001Ah], ax
                mov     word ptr es:[001Ch], ax
                sti
                mov     ax, ds
                mov     es, ax

KR_ResetScrn:   mov     di, offset ScreenSave
                mov     ax, 0
                mov     cx, 2000
        rep     stosw
                mov     CursorShape, 0
                mov     CursorLoc, 0

PingBack:       mov     ScreenPos, -1
                mov     dx, cs
                mov     ax, offset Screen_Data
                mov     cx, 8
                mov     bp, 0
                mov     bx, 0
                mov     si, offset master_name
                call    Send_Msg

KR_WaitCplt:    cmp     send_ncb.CMD_CPLT, 0FFh
                je      KR_WaitCplt

                mov     SessionActive, 1
                jmp     KR_RecvKbd

KR_StuffBuffer: mov     ax, 0040h
                mov     es, ax
                cli
                mov     al, KbdFlag1
                mov     byte ptr es:[0017h], al
                mov     al, KbdFlag2
                mov     byte ptr es:[0018h], al
                mov     al, AltInput
                mov     byte ptr es:[0019h], al
                mov     ax, Tail
                mov     word ptr es:[001Ch], ax
                mov     di, 001Eh
                mov     si, offset KbdBuffer
                mov     cx, 16
        rep     movsw
                sti

KR_RecvKbd:     mov     dx, cs
                mov     ax, offset Kbd_Data
                mov     cx, 39
                mov     bp, cs
                mov     bx, offset Kbd_Receive
                call    Recv_Msg

                Assume  CS:_TEXT, DS:Nothing
Kbd_Exit:       pop     es
                pop     ds
                pop     bp
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     bx
                pop     ax

                cli
                mov     ss, cs:SS_Save2
                mov     sp, cs:SP_Save2

                iret

;---------------------------------------

EndResident     Label   Byte
                DB      0

;---------------------------------------

Start:          Assume  CS:_TEXT, DS:_DATA, ES:Nothing
                mov     ax, @DATA
                mov     ds, ax

                mov     ax, cs
                mov     cs:StackSeg1, ax
                mov     ax, offset OurStack1
                mov     cs:StackOfs1, ax

                mov     ax, cs
                mov     cs:StackSeg2, ax
                mov     ax, offset OurStack2
                mov     cs:StackOfs2, ax

save_int8:      mov     ax, 3508h
                int     21h
                mov     cs:oldint08_seg, ES
                mov     cs:oldint08_ofs, BX

get_dos_vers:   mov     ax, 3000h
                int     21h
                mov     cs:dos_major, al
                mov     cs:dos_minor, ah
                cmp     al, 2
                ja      netbios_test1

wrong_dos:      mov     bx, 2
                mov     dx, offset Msg2
                mov     cx, Msg2Len
                mov     ah, 40h
                int     21h

                mov     ax, 4C00h
                int     21h

netbios_test1:  mov     ax, 0
                mov     es, ax
                cmp     word ptr es:[0170h], 0
                jne     netbios_test2

no_netbios:     mov     bx, 2
                mov     dx, offset Msg3
                mov     cx, Msg3Len
                mov     ah, 40h
                int     21h

prog_exit:      mov     ax, 4C00h
                int     21h

netbios_test2:  mov     cs:send_ncb.COMMAND, 7Fh
                mov     cs:send_ncb.RETCODE, 0
                mov     cs:send_ncb.CMD_CPLT, 0FFh
                mov     ax, cs
                mov     es, ax
                mov     bx, offset send_ncb
                Int     5Ch
                cmp     cs:send_ncb.RETCODE, 3
                jne     no_netbios

bw_or_color:    mov     ah, 0Fh
                int     10h
                Cmp     AL, 7
                JE      SetMono
                Jmp     LookFurther

SetMono:        Mov     cs:VideoSeg, 0B000h
                Mov     cs:VideoOfs, 0000
                Jmp     get_psp

LookFurther:    Mov     bx, 0FF10h
                Mov     ah, 12h
                Int     10h
                Test    bh, 0FEh
                JZ      EGAPresent
                Jmp     SetCGA

EGAPresent:     LES     BX, EGAFlagPtr
                Mov     AL, Byte Ptr ES:[BX]
                Test    AL, 00000101b
                JNZ     SetCGA
                Test    AL, 00000100b
                JNZ     SetMono
                Test    AL, 00000001b
                JNZ     SetMono

EGAIsActive:    Mov     cs:VideoSeg, 0B800h
                Mov     cs:VideoOfs, 0000
                Jmp     get_psp

SetCGA:         Mov     cs:VideoSeg, 0B800h
                Mov     cs:VideoOfs, 0000

get_psp:        mov     ax, 5100h
                int     21h
                mov     cs:our_psp, bx
                dec     bx
                mov     cs:our_mcb_seg, bx

network_name:   mov     bx, 2
                mov     dx, offset Msg4
                mov     cx, Msg4Len
                mov     ah, 40h
                int     21h

                call    Add_Our_Name
                mov     al, cs:add_name_ncb.NUM
                mov     cs:OurNameNumber, al
                cmp     cs:add_name_ncb.CMD_CPLT, 0
                je      install_int8
                jmp     prog_exit

install_int8:   push    ds
                mov     dx, offset Int_08
                push    cs
                pop     ds
                mov     ax, 2508h
                int     21h
                pop     ds

say_hello:      mov     bx, 2
                mov     dx, offset Msg1
                mov     cx, Msg1Len
                mov     ah, 40h
                int     21h

First_Recv:     mov     dx, cs
                mov     ax, offset Kbd_Data
                mov     cx, 39
                mov     bp, cs
                mov     bx, offset Kbd_Receive
                call    Recv_Msg

issue_tsr:      Mov     AX, cs
                Sub     AX, cs:our_psp
                Mov     BX, Offset EndResident
                Mov     CX, 4
                Shr     BX, CL
                Inc     BX
                Add     AX, BX
                Mov     DX, AX
                Mov     AH, 31h
                Int     21h

                End     Start


