;************************************************************************
;*                                                                      *
;*      OnOff. (C) 1996 Ronald Nordberg.                                *
;*      A VERY simple Terminate and stay resident program (TSR).        *
;*      It intercepts the keyboard hardware interrupt 09h.              *
;*      Press CTRL and 9 to turn the screen OFF.                        *
;*      Press CTRL and 1 to turn it ON.                                 *
;*      When loaded: Onoff U to uninstall.                              *
;*      It uses the FCB-block area in the PSP to store it's data.       *
;*      Assembled with NASM v0.93.                                      *
;*                                                                      *
;*      Ronald Nordberg.                                                *
;*      Silvervgen 3.                                                  *
;*      907 50 Ume.                                                    *
;*      Sweden.                                                         *
;*      Email:                                                          *
;*      christine.martinson@swipnet.se                                  *
;*      Homepage:                                                       *
;*      http://home2.swipnet.se/~w-20064                                *
;*                                                                      *
;*      THIS IS ALL PUBLIC DOMAIN FREEWARE.                             *
;*      GIVE ME CREDITS IF YOU USE THE CODE.                            *
;*                                                                      *                                                        
;************************************************************************

msdos           equ     21h             ;MSDOS irq
writef          equ     40h             ;write to file with handle
exit            equ     4c00h           ;msdos exit

newfunc         equ     0E0h            ;could be ANYTHING
checkin         equ     0
remove          equ     1               ;not used here
fcbblock        equ     05Ch            ;FCB block address in PSP

[BITS 16]
[ORG 100h]
[SEGMENT .text]
                                ;our handler start will be 100h+2
        jmp     start           ;one word
        
;**********************************************************************
;*      The handler code
;**********************************************************************
handler:                        ;handler for interrupt 09h

        cmp     ah,newfunc      ;anyone checking us out ?
        jne     dous            ;noo, do the stuff
        jmp     goout
dous:
         pusha                  ;save regs
         push ds
         push es

         mov    ax,40h          ;BIOS SEG address
         mov    es,ax
         mov    ch,[es:+17h]    ;offset keyboard flag
         in     al,60h          ;get scan code
         and    ch,04h          ;clear all bits except CTRL
         cmp    ch,04h          ;equal ?
         jne    toold           ;noo
       
         sub    al,1            ;<1 ?    
         jng    toold           ;yeahh
         cmp    al,9            ;>9 ?
         jg     toold           ;yeahh
         cmp    al,1            ;1 ?
         je     screenon        ;yeahh, turn screen on
         cmp    al,9            ;9 ?
         je     screenoff       ;yeahh, turn screen off
         jmp    toold           ;none, skip this

screenon:                       ;turn screen ON
        mov     ax,1200h        ;BIOS function 12h (enable/disable refresh)
        mov     bl,36h          ;subfunction 36h
        int     10h             ;BIOS int 10h
        jmp     toold           ;leave 
        
screenoff:                      ;turn screen OFF
        mov     ax,1201h        ;AL 01 = disable refresh
        mov     bl,36h
        int     10h
        jmp     toold

;**********************************************************************
;*      Answer to installation check by INT
;********************************************************************** 
goout:
        mov     ah,checkin              ;load regs with return values
        mov     al,newfunc
        iret                            ;return from handler

;**********************************************************************
;*      Back to original Interrupt handler
;**********************************************************************
toold:
        pop es                  ;restore registers
        pop ds
        popa
        db      0EAh            ;JMP FAR
orgoff: dw      0               ;old interrupt OFFSET
orgseg: dw      0               ;old     "     SEGMENT
respsp: dw      0               ;resident PSP

ehandle:

;**********************************************************************
;*      Load our TSR stuff
;**********************************************************************
start:
        mov     [pspaddr],es            ;save PSP
        mov     sp,0f000h               ;stack at end of program area
        mov     es,[es:+2Ch]            ;address of environment block
        mov     ah,49h                  ;free memory
        int     21h                     ;call dos
        mov     es,[pspaddr]            ;set ES to PSP
        mov     [comseg],cs             ;save current segment
        mov     ds,[comseg]             ;make DS = CS

        mov     ah,newfunc              ;ID of our own handler
        mov     al,checkin              ;0 = function check
        int     09h                     ;call KBD IRQ
        cmp     ah,checkin              ;are we there ?
        je      loaded                  ;yeahh, already loaded
install:
        mov     [respsp],es             ;save PSP of resident part 
        mov     ax,3509h                ;get KBD IRQ Vector
        int     21h                     ;call DOS
        mov     [orgoff],bx             ;save offset for old handler
        mov     [orgseg],es             ;save segment of old handler
        mov     cx,handler              ;save offset new handler
        mov     dx,ds                   ;save resident segment
        push    es
        mov     ax,fcbblock             ;address to PSP:s FCB block
        sub     word ax,1               ;adjust back one word
        mov     es,ax                   ;copy to work
        mov     ax,[respsp]             ;get our values
        mov     [es:+0],ax              ;save resident PSP
        mov     ax,[orgseg]
        mov     [es:+2],ax              ;save original segment
        mov     ax,[orgoff]
        mov     [es:+4],ax              ;save original offset
        mov     [es:+6],ds              ;save segment new handler
        mov     [es:+8],cx              ;save offset new handler
        pop     es
        
        cli                             ;disable irq
        mov     dx,handler              ;our own handler         
        mov     ax,2509h                ;set new handler
        int     21h                     ;call DOS
        sti                             ;turn on irqs

        mov     ah,09h                  ;let them know we are installed
        mov     dx,alert1               ;pointer text
        int     21h                     ;call dos

        mov     dx,ehandle-handler      ;get size of our handler
        add     dx,110h                 ;add size of PSP + 16 byte
        mov     cx,4                    ;divide by 16
        shr     dx,cl
        mov     ax,3100h                ;Terminate and Stay Resident
        int     21h                     ;call DOS

notus:  mov     dx,alert4               ;cant uninstall
uexit:  mov     ds,[comseg]             ;can be destroyed
        mov     ah,09h                  ;display ASCIIZ
        int     21h                     ;call DOS
quit:   xor     eax,eax                 ;better do this 
        mov     ax,4c00h                ;clean exit
        int     21h                     ;call DOS
 
loaded:                                 ;we are loaded, remove us
        mov     es,[pspaddr]            ;PSP to ES
        cmp     byte [es:80h],1         ;anything on command line ?
        jle     usage                   ;noo, advertise
        mov     bx,82h                  ;first param on command line
        and     byte [es:bx],0DFh       ;force uppercase
        cmp     byte [es:bx],'U'        ;unload ?
        jne     quit                    ;noo, skip

        mov     ax,fcbblock             ;get address of FCB-block
        sub     word ax,1               ;adjust everything back one word
        mov     gs,ax                   ;store it there

        mov     al,checkin              ;get info about resident part
        mov     es,[comseg]             ;ES = current segment
        mov     bx,resbuff              ;buffer for data, not used here
        int     09h                     ;call handler
        mov     ax,3509h                ;get interrupt vector
        int     21h                     ;call dos
        mov     ax,es                   ;AX = seg of current handler
        cmp     ax,[gs:+6]              ;segment OK ?
        jne     notus                   ;noo
        cmp     bx,[gs:+8]              ;offset OK ?
        jne     notus                   ;noo

        push    es                      ;save those
        push    ds
        mov     es,[gs:+0]              ;get resident PSP
        mov     ah,49h                  ;free mem
        int     21h                     ;call dos
        jnc     memok                   ;all ok
        pop     ds                      ;restore
        pop     es
        mov     dx,alert3               ;something wrong
        jmp     uexit
memok:
        cli
        mov     ds,[gs:+2]              ;original segment
        mov     dx,[gs:+4]              ;original offset
        mov     ax,2509h                ;set interrupt vector
        int     21h                     ;call dos
        sti
        pop     ds
        pop     es
        mov     dx,alert2               ;let em know we are uninstalled
        jmp     uexit                   ;done
usage:
        mov     dx,alert5
        jmp     uexit

;***********************************************************************
;       The loader data
;***********************************************************************
pspaddr dw      0
comseg  dw      0

resbuff times 8 dw 0
numbuff times 4 dw 0
alert1  db      'TSR installed OK.$',0
alert2  db      'TSR removed OK.$',0
alert3  db      'Could not release environment.$',0
alert4  db      'Cant unload. Not last handler.$',0
alert5  db      'OnOff (C) 1997 RonSoft.',13,10
        db      'OnOff U to uninstall.$',0

END          
