	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
ENDIF

	EXTRN	sendMsg:NEAR

	EXTRN	Dir:WORD
	EXTRN	DosError:WORD
	EXTRN	FileDlg:WORD
	EXTRN	FileName:WORD
	EXTRN	MemMngr:WORD
	EXTRN	Self:WORD

	.CODE

	PUBLIC getFileName
COMMENT	%
==============================================================================
Gets name of file to open from one of FileDlg's slave objects and moves it to
the DTA.

=============================================================================%
getFileName	PROC	NEAR
	push		Self
	call		getDrive		;Get current drive
	call		getPath			;Get current path
	getInst		si,ActiveSlave,FileDlg	;Get ptr to active slave obj
	getInst		si,TxtPtr,si		;Get ptr to file name string
gfn1:	lodsb					;Get a byte
	mov		Bptr[di],al		;Move to destination
	inc		di			;Point to next dest byte
	notZero		al,gfn1			;Not end of string? - Loop

	mov		al,Bptr[di-2]		;Get 2nd previous byte
	neq		al,Space,gfn2		;Not a space? - Exit
	mov		Bptr[di-2],0		;Else - Overwrite with zero
gfn2:	pop		Self
	ret
getFileName	ENDP



	PUBLIC getDrive
COMMENT	%
==============================================================================
Gets the current or default disk drive.

Passes:	di - Pointer to next available byte in file name buffer

=============================================================================%
getDrive	PROC	NEAR
	lea		di,FileName		;Get ptr to file name buffer
	mov		ah,19h			;Pass service number
	int		DosInt			;DOS interrupt
	add		al,41h			;Convert drive# to ASCII
	mov		Bptr[di],al		;Set drive
	mov		Bptr[di+1],':'		;Colon
	mov		Bptr[di+2],'\'		;Slash
	add		di,3			;Account for drive (C:\)
	ret
getDrive	ENDP



	PUBLIC getPath
COMMENT	%
==============================================================================
Gets the current path.

Passed:	di - Pointer to next available byte in file name buffer

Passes:	di - Pointer to next available byte in file name buffer

=============================================================================%
getPath	PROC	NEAR
	mov		ah,47h			;Pass service number
	mov		dl,0			;Use default drive
	mov		si,di			;Pass ptr to name buffer
	int		DosInt			;DOS interrupt
	jc		gpth2			;Jump if error

gpth1:	lodsb					;Get a byte
	notZero		al,gpth1		;Not end of path? - Loop
	dec		si			;Overwrite terminal zero
	eq		di,si,gpth3		;Exit if root directory
	mov		di,si			;Return ptr to name buffer
	mov		Bptr[di],'\'		;Move backslash to destination
	inc		di			;Point to next dest byte
	jmp		gpth3

gpth2:	send		DosError,Error,ax	;Handle error
gpth3:	ret
getPath	ENDP



IF Dbug
	PUBLIC ?OpenFile
ENDIF
COMMENT	%
==============================================================================
Opens the specified file unless it is a subdirectory in which case it moves
to that subdirectory.

=============================================================================%
?OpenFile	PROC	NEAR
	setInst		FileHdl,Nil,Self,2	;Clear file handle
	lea		dx,FileName		;Pass ptr to file name
	mov		al,11000010b		;Pass open mode
	mov		ah,3Dh			;Open file service number
	int		DosInt			;DOS interrupt
	jc		opnf1			;Jump if error

	setInst		FileHdl,ax		;Set file handle
	send		File,Read		;Read file
	send		FileDlg,Clear		;Clear dialog
	jmp		opnf2			;Exit

opnf1:	call		?ChangeDir		;Change dir if dir selected
opnf2:	ret
?OpenFile	ENDP



COMMENT	%
==============================================================================
Changes the current directory to the specified subdirectory.

Passed:	ax - Error code

=============================================================================%
?ChangeDir	PROC	NEAR
	push		ax
	lea		dx,FileName		;Pass ptr to file name
	mov		ah,3Bh			;Change dir service number
	int		DosInt			;DOS interrupt
	pop		ax
	jnc		chd1			;Jump if no error encountered

	send		DosError,Error,ax	;Handle error

chd1:	setInst		?ReadDir,Nil,Dir,2	;Must re-read directory
	send		Dir,Refresh		;Refresh directory
	send		FileDlg,Read		;Handle keyboard/mouse events
	ret
?ChangeDir	ENDP



IF Dbug
	PUBLIC readFile
ENDIF
COMMENT	%
==============================================================================
Opens the specified file.

=============================================================================%
readFile	PROC	NEAR
	getInst		bx,FileHdl,Self		;Get file handle
	null		bx,rdfl1		;Null handle? - Exit

	getInst		dx,MemSeg		;Get memory segment
	null		dx,rdfl1		;Null segment? - Exit

	push		ds
	getInst		ax,MemSize		;Get amount of free memory
	mov		cl,16			;Paragraph size
	mul		cl			;Calc memory size in byte
	mov		cx,ax			;Pass memory size
	mov		ds,dx			;Pass data segment
	mov		dx,0			;Pass segment offset
	mov		ah,3Fh			;Pass service number
	int		DosInt			;DOS interrupt
	pop		ds
	jc		rdfl2			;Jump if error
	setInst		BytesRead,ax		;Set number of bytes read
	jmp		rdfl1			;Exit

rdfl2:	send		DosError,Error,ax	;Handle error
rdfl1:	ret
readFile	ENDP



COMMENT	%
==============================================================================
Save the program's initial path for future reference.

=============================================================================%
saveHomePath	PROC	NEAR
	call		getDrive		;Get current drive
	call		getPath			;Get current path
	lea		di,HomePath		;Destination buffer addr
	lea		si,FileName		;Source addr
scp1:	lodsb					;Get a byte
	mov		Bptr[di],al		;Move to destination
	inc		di			;Point to next dest byte
	notZero		al,scp1			;Not end of string? - Loop
	mov		Bptr[di-2],0		;Replace last byte with zero
	ret
saveHomePath	ENDP



	PUBLIC getHomePath
COMMENT	%
==============================================================================
Gets the program's home path.

Passed:	di - Pointer to next available byte in file name buffer

Passes:	di - Pointer to next available byte in file name buffer

=============================================================================%
getHomePath	PROC	NEAR
	lea		si,HomePath		;Get addr of start-up path
ghp1:	lodsb					;Get a byte
	mov		Bptr[di],al		;Save it
	inc		di			;Point to next dest byte
	notZero		al,ghp1			;Loop if not end of path
	mov		Bptr[di-1],'\'		;Overwrite zero with backslash
	ret
getHomePath	ENDP



	.DATA

HomePath	DB	64 DUP (0)		;Program's home path name

defMsg	File,\
	Open,\
	<getFileName,,?OpenFile>

defMsg	File,\
	Read,\
	<,,readFile>

defMsg	File,\
	Init,\
	<,,saveHomePath>

defObj	File,\
	<MemMngr>,\
	<MemSize,2,80h,\
	MemSeg,2,Nil,\
	FileHdl,2,Nil,\
	BytesRead,2,Nil>,\
	<Open,Read,Init>



	END


