	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
	INCLUDE	keyboard.mac
	INCLUDE	strings.mac
ENDIF

	EXTRN	Self:WORD

	.CODE

COMMENT	%
==============================================================================
Gets the current keyboard shift status for display.

=============================================================================%
disShiftStatus	PROC	NEAR
	getInst		dh,Row1,Keyboard	;Get status display row
	getInst		dl,Col1			;Get status display column
	getInst		bl,Color		;Get color

	getShiftStatus	ax			;Get shift status

	push		ax
	and		al,32
	jz		dss1

	lea		si,Num
	jmp		dss2

dss1:	lea		si,Off
dss2:	call		disStatusString
	pop		ax

	push		ax
	and		al,128
	jz		dss3

	lea		si,Ins
	jmp		dss4

dss3:	lea		si,Off
dss4:	call		disStatusString
	pop		ax

	and		al,64
	jz		dss5

	lea		si,Cap
	jmp		dss6

dss5:	lea		si,Off
dss6:	call		disStatusString
	ret
disShiftStatus	ENDP



COMMENT	%
==============================================================================
Displays the specified shift status string.

Passed:	bl - Color
	dx - Row/Column
	es - Video segment addr
	si - String addr

=============================================================================%
disStatusString	PROC	NEAR
	push		dx
	disStrg		dh,dl,bl,si
	pop		dx
	inc		dh			;Advance cursor to next line
	ret
disStatusString	ENDP



COMMENT	%
==============================================================================
Reads a key event if available, and returns its Scan and ASCII codes.

=============================================================================%
readKeyboard	PROC	NEAR
	setInst		ScanCode,Nil,Keyboard,1	;Clear scan code
	ifNoKey		rdk1			;No key event? - Exit
	readKey		ah,al			;Else - read key
	setInst		ScanCode,ah		;Save scan code
	setInst		AsciiCode,al		;Save ASCII code
rdk1:	ret
readKeyboard	ENDP



	.DATA

Cap	DB	" CapsLock ",0
Ins	DB	" Insert   ",0
Num	DB	" NumLock  ",0
Off	DB	"          ",0

defMsg	KeyBoard,\
	Read,\
	<,,readKeyboard>

defMsg	KeyBoard,\
	Refresh,\
	<,,disShiftStatus>

defObj	KeyBoard,\
	<>,\
	<Row1,1,22,\
	Col1,1,70,\
	Row2,1,Nil,\
	Col2,1,Nil,\
	Color,1,31h,\
	ScanCode,1,Nil,\
	AsciiCode,1,Nil>,\
	<Read,Refresh>



	END
