	.MODEL	SMALL

	INCLUDE	equates.inc

	.CODE

COMMENT	%
==============================================================================
Convert long integer to string.

Passed:	dx,ax - long integer
	es:di - points to area for string

=============================================================================%
	PUBLIC  longToString
longToString	PROC  	NEAR
	push		bp
	push		di
	push		es
	mov		bp,sp

	mov		si,dx
	test		dh,80h
	jz		lts1
	not		dx
	neg		ax
	sbb		dx,-1

lts1:	sub		bx,bx
	push		bx

lts2:	push		si
	push		dx
	push		ax
	mov		cx,0
	mov		bx,10
	call		lDiv
	pop		bx
	pop		cx

	push		dx
	push		ax
	push		cx
	push		bx
	mov		cx,0
	mov		bx,10
	call		lMul
	mov		cx,dx
	mov		bx,ax
	pop		ax
	pop		dx
	call		lSub
	mov		bx,ax
	pop		ax
	pop		dx
	pop		si
	add		bl,'0'
	push		bx
	mov		bx,ax
	or		bx,dx
	jnz		lts2

	mov		di,[bp][2]
	mov		es,[bp]
	cld
	test		si,8000h
	jz		lts3
	mov		al,'-'
	stosb

lts3:	pop		ax
	stosb
	or 		al,al
	jnz		lts3
	mov		sp,bp
	pop		es
	pop		di
	pop		bp
	ret
longToString	ENDP



COMMENT	%
==============================================================================
Subtracts a long integer from a long integer.

Passed:	cx:bx - Number to be subtracted
	dx:ax - Number its subtracted from

Passes:	dx:ax - Result

=============================================================================%
lSub	PROC	NEAR
	push		ax
	mov		ax,0
	sub		ax,bx
	mov		bx,ax
	mov		ax,0
	sbb		ax,cx
	mov		cx,ax
	pop		ax
	add		ax,bx
	adc		dx,cx
	ret
lSub	ENDP




COMMENT	%
==============================================================================
Long integer multiplier.

=============================================================================%
lMul	PROC	NEAR
	push		si
	push		di
	push		bp
	sub		bp,bp

	test		dh,80h
	jz		lml1
	not		bp
	mov		si,0
	sub		si,ax
	mov		ax,si
	mov		si,0
	sbb		si,dx
	mov		dx,si

lml1:	test		Ch,80h
	jz		lml2
	not		bp
	mov		si,0
	sub		si,bx
	mov		bx,si
	mov		si,0
	sbb		si,cx
	mov		cx,si

lml2:	mov		si,dx
	mov		di,ax
	mul		bx
	push		ax
	push		dx

	mov		ax,si
	mul		bx
	pop		bx
	add		ax,bx
	adc		dx,0
	push		ax
	mov		bx,dx

	mov		ax,di
	mul		cx
	pop		di
	add		di,ax
	push		di
	mov		di,0
	adc		bx,dx
	adc		di,0

	mov		ax,si
	mul		cx
	add		ax,bx
	adc		dx,di
	pop		cx
	pop		bx

	or		ax,dx
	mov		ax,bx
	mov		dx,cx
	pushf
	test		bp,bp
	jz		lml3
	mov		bx,0
	sub		bx,ax
	mov		ax,bx
	mov		bx,0
	sbb		bx,dx
	mov		dx,bx

lml3:	popf
	pop		bp
	pop		di
	pop		si
	jz		lml4
	stc
lml4:	ret
lMul	ENDP




COMMENT	%
==============================================================================
Long integer divider.

=============================================================================%
lDiv	PROC	NEAR
	push		bp 
	sub		sp,4 
	mov		bp,sp 
	mov		[bp],cx 
	or		cx,bx 
	jnz		ldv1
	sub		ax,ax
	mov		dx,ax
	jmp		ldv13 

ldv1:	mov		[bp+2],dx 
	or		dx,ax
	jnz		ldv2
	jmp		ldv13 

ldv2:	mov		cx,[bp] 
	mov		dx,[bp+2] 
	mov		si,dx 
	test		si,si
	jns		ldv3
	not		dx 
	neg		ax 
	sbb		dx,-1   

ldv3:	xor		si,cx
	mov		[bp],si
	sub		si,si 
	test		ch,ch 
	jns		ldv4
	not		cx 
	neg		bx 
	sbb		cx,-1

ldv4:	jnz		ldv7
	test		bx,bx 
	js		ldv7
	mov		di,20h

ldv5:	shl		ax,1 
	rcl		dx,1 
	rcl		si,1 
	cmp		si,bx 
	jb		ldv6
	sub		si,bx 
	inc		ax 

ldv6:	dec		di 
	jnz		ldv5 
	sub		cx,cx 
	mov		bx,si 
	jmp		ldv11

ldv7:	mov		di,0010h

ldv8:	shl		ax,1 
	rcl		dx,1 
	rcl		si,1 
	cmp		si,cx 
	jb		ldv10
	jnz		ldv9
	cmp		dx,bx 
	jb		ldv10

ldv9:	sub		dx,bx 
	sbb		si,cx 
	inc		ax

ldv10:	dec		di 
	jnz		ldv8
	mov		cx,si 
	mov		bx,dx 
	sub		dx,dx 

ldv11:	test		Wptr[bp],8000h
	jz		ldv12 
	not		dx 
	neg		ax 
	sbb		dx,-1

ldv12:	test		Wptr[bp+2],8000h
	jz		ldv13
	not		cx 
	neg		bx 
	sbb		cx,-1 

ldv13:	add		sp,4 
	pop		bp 
	ret
lDiv	ENDP


	END
