;
;       32-bit pmode/dpmi code to control interrupts
;	by Dhonn Lushine 3:30 PM 6/30/97
;
;	This demo will using int 8/irq 0 to change the value 
;	addressed at 0b8000h.
;
;	compile with watcom c++:
;        wcl386 pmint
;
;	Warning: I am not responsible for damages!
;

.386
.model flat
.stack 100h
.code

start:	jmp overdata

watcom		db	'WATCOM'	; need for watcom's dos extender
	align	4
oldint8		df	?		; Holds old interrupt

overdata:

	mov	ax,204h			; f204h i31h - get interrupt 
	mov	bl,8			; bl=interrupt number
	int	31h			; dpmi call
					; returns cx:edx for the old int
	mov	dword ptr[oldint8],edx	; save old interrupt
	mov	word ptr[oldint8+4],cx

	mov	ax,205h			; f205h i31h - set interrupt
	mov	bl,8			; int num
	mov	cx,cs			; cx=seg - for newint8
        mov     edx,offset newint8      ; edx offset - for newint8
	int	31h

	xor	ah,ah
	int	16h

	mov	ax,205h
	mov	bl,8
        mov     edx,dword ptr[oldint8]  ; set oldint8 back
        mov     cx,word ptr[oldint8+4]
	int	31h

	mov	ax,4c00h
	int	21h

newint8:
	pushad				; you have to save regs you use
					; this is called by the hardware
	mov	ebx,0b8000h
	mov	eax,[ebx]
	inc	eax
	mov	[ebx],eax

	popad
	jmp	cs:oldint8		; chain to the old interrupt

	end	start
