.286
;=======================================
; invoke ft2st, real, string
;
; Convert a REAL10 to an ascii string.
; Maximum string length is 42 bytes plus null.
;------------------------------------------------
cseg          segment word public 'code'
              assume  cs:cseg,ss:cseg
              assume  ds:cseg,es:cseg

              include math.inc

ft2st         proc    near real:NPR10, string:NPB
              local   t:REAL10, one:REAL10, big:REAL10

              pusha                             ;
              mov     si, real                  ; address real
              invoke  movx, addr t, si, 5       ; make copy (t) of real
              lea     si, t                     ; address copy

              mov     di, string                ; address string
              cld                               ; forward

              invoke  ftzero, si                ; check for zero
              .IF ax == TRUE                    ;
                 mov     ax, '0+'               ;
                 stosw                          ;
                 mov     ax, '0.'               ;
                 stosw                          ;
                 xor     al, al                 ;
                 stosb                          ; string = '+0.0',0
                 jmp     exit                   ;
              .ENDIF                            ;

              invoke  load10_19, addr big       ; load 10**19
              invoke  load1, addr one           ; load 1.0

              mov     ax, word ptr [si]+8       ;
              and     ax, 8000h                 ;
              .IF  ax == 8000h                  ; if negative
                 mov     al, '-'                ;
                 and     word ptr [si]+8, 7fffh ;
              .ELSE                             ; if positive
                 mov     al, '+'                ;
              .ENDIF                            ;
              stosb                             ; write string
;------------------------------------------------
; process integers
;------------------------------------------------
              mov     cx, 20                    ; 10**19 thru 10**0
              xor     dx, dx                    ;

              .WHILE (cx)                       ;
                 invoke  ftmod, si, addr big
                 .IF (ax)                       ; if ax > 0
                    or      dx, 1               ;
                 .ENDIF                         ;

                 .IF (dx)                       ;
                    add     al, '0'             ; convert to ascii
                    stosb                       ; write string
                 .ENDIF                         ;

                 invoke  ftdivi, addr big, +10  ; 10**N / 10.0
                 dec     cx                     ; continue
              .ENDW
;------------------------------------------------
; add decimal point
;------------------------------------------------
              mov     bx, di                    ; save posn of dec point
              .IF (dx)                          ;
                 mov     al, '.'                ;
                 stosb                          ;
              .ELSE                             ;
                 mov     ax, '.0'               ;
                 stosw                          ;
              .ENDIF                            ;
;------------------------------------------------
; process decimals
;------------------------------------------------
              mov     cx, 20                    ;
              .WHILE (cx)                       ;
                 invoke  ftzero, si             ;
                 .BREAK .IF (ax == TRUE)        ;

                 invoke  ftmuli, si, +10        ; binary * 10
                 invoke  ftmod, si, addr one    ;
                 add     al, '0'                ;
                 stosb                          ;
                 dec     cx                     ;
              .ENDW                             ;

              xor     al, al                    ; terminate string
              stosb                             ;
;------------------------------------------------
; round up decimals if '99' occurs
;------------------------------------------------
              inc     bx                        ; skip dec point
              mov     cx, 20                    ;
              .WHILE (cx)                       ;
                 lodsb                          ;
                 .BREAK .IF (al == 0)           ; exit if string end

                 .IF ((byte ptr [bx]-1 != '9') \
                   && (byte ptr [bx]+0 == '9') \
                   && (byte ptr [bx]+1 == '9'))
                    inc     byte ptr [bx]-1     ; + 1
                    mov     byte ptr [bx], 0    ; terminate string
                    .BREAK                      ; exit loop
                 .ENDIF                         ;

                 dec    cx                      ; continue
              .ENDW
exit:
              popa

              ret
ft2st         endp

cseg          ends
              end
