.286
;================================================
; Adds REAL10's dst, src
;
;------------------------------------------------
cseg          segment word public 'code'
              assume  cs:cseg,ss:cseg
              assume  ds:cseg,es:cseg

              include math.inc

ftadd         proc    near  dst:NPR10, src:NPR10
              local   dcopy[24]:BYTE, scopy[24]:BYTE, exp:SWORD

              pusha
              mov     di, dst
              mov     si, src

              invoke  ftzero, si                ; src = 0.0 ?
              .IF ax == TRUE                    ;
                 jmp     exit                   ; dst unchanged
              .ENDIF                            ;

              invoke  ftzero, di                ; dst = 0.0 ?
              .IF ax == TRUE                    ;
                 invoke  movx, di, si, 5        ; dst = src
                 jmp     exit                   ;
              .ENDIF                            ;

              invoke  clrx, addr dcopy, 12      ;
              invoke  movx, addr dcopy[8], di, 4  ;
              mov     ax, word ptr [di]+8    ;
              mov     cl, ah                    ;
              and     cl, 80h                   ;
              rol     cl, 1                     ; cl = sign of dst
              and     ax, 7fffh                 ;
              sub     ax, 3fffh                 ;
              mov     exp, ax                   ;

              .WHILE (exp > 0)                  ;
              dec     exp                       ;
              invoke  lshx, addr dcopy, 12      ;
              .ENDW                             ;

              .WHILE (exp < 0)                  ;
              inc     exp                       ;
              invoke  rshx, addr dcopy, 12      ;
              .ENDW                             ;

              invoke  clrx, addr scopy, 12      ;
              invoke  movx, addr scopy[8], si, 4 ;
              mov     ax, word ptr [si]+8       ;
              mov     ch, ah                    ;
              and     ch, 80h                   ;
              rol     ch, 1                     ; ch = sign of src
              and     ax, 7fffh                 ;
              sub     ax, 3fffh                 ;
              mov     exp, ax                   ;

              .WHILE (exp > 0)                  ;
              dec     exp                       ;
              invoke  lshx, addr scopy, 12      ;
              .ENDW                             ;

              .WHILE (exp < 0)                  ;
              inc     exp                       ;
              invoke  rshx, addr scopy, 12      ;
              .ENDW                             ;

              mov     dx, word ptr es:[di]+8    ;
              and     dx, 8000h                 ; preserve sign of dst
              add     dx, 3fffh                 ; exponent = 0

;------------------------------------------------
; add equal signs
;------------------------------------------------
              .IF     ((cx == 101h) || (cx == 0))
                 invoke  addx, addr dcopy, addr scopy, 12

;------------------------------------------------
; subtract unequal signs
;------------------------------------------------
              .ELSEIF ((cx == 100h) || (cx == 1))
                 invoke  cmpx, addr dcopy, addr scopy, 12

                 .IF ax == 0                    ; if equal
                    invoke  clrx, di, 5         ;
                    jmp     exit                ; dst = 0.0

                 .ELSEIF ax == 1                ; if dcopy > scopy
                    invoke  subx, addr dcopy, addr scopy, 12
                    .IF cx == 100h              ; if +dst > -src
                       and     dx, 7fffh        ; +ve result
                    .ELSEIF cx == 1             ; if -dst > +src
                       or      dx, 8000h        ; -ve result
                    .ENDIF

                 .ELSEIF ax == -1               ; if dcopy < scopy
                    invoke  subx, addr scopy, addr dcopy, 12
                    invoke  movx, addr dcopy, addr scopy, 12

                    .IF cx == 100h              ; if +dst < -src
                       or      dx, 8000h        ; -ve result
                    .ELSEIF cx == 1             ; if -dst < +src
                       and     dx, 7fffh        ; +ve result
                    .ENDIF

                 .ENDIF
              .ENDIF

              add     dx, 64                    ; max exponent
              .WHILE (1)                        ; normalise dcopy
                 mov     ax, word ptr dcopy[22] ;
                 .BREAK .IF (ax & 8000h)        ;
                 invoke  lshx, addr dcopy, 12   ;
                 dec     dx                     ; exponent--
              .ENDW                             ;

              mov     word ptr [di]+8, dx       ;
              invoke  movx, di, addr dcopy[16], 4
exit:
              popa

              ret
ftadd         endp

cseg          ends
              end
