.286
;================================================
; invoke ftcos, real, radians
;
; Returns real = cos(radians)
;------------------------------------------------
;              x**2     x**4     x**6
; cos x = 1 -  ----  +  ----  -  ----  +  .......
;               2!       4!       6!
;
; 8 terms give 18 significant decimal places for
; an angle of 45 degrees.
;------------------------------------------------
cseg          segment word public 'code'
              assume  cs:cseg,ss:cseg
              assume  ds:cseg,es:cseg

              include math.inc

ftcos         proc    near  real:NPR10, radians:NPR10
              local   p:REAL10, f:REAL10

              pusha                             ;
              mov     si, real                  ;
              mov     di, radians               ;

              invoke  load1, si                 ; real = 1.0
              xor     bx, bx                    ; BX = 0
              mov     cx, 8                     ; number of terms
              mov     dx, 2                     ; starting power, factorial

              .WHILE (cx)                       ;
                 invoke movx, addr p, di, 5     ; p = radians
                 invoke ftpower, addr p, dx     ; p = p**dx
                 invoke ftfact, addr f, dx      ; f = factorial dx
                 invoke ftdiv, addr p, addr f   ; p = p**dx / factorial dx

                 xor    bx, 1                   ;
                 .IF (bx == 1)                  ;
                    invoke ftsub, si, addr p    ; - term
                 .ELSE                          ;
                    invoke ftadd, si, addr p    ; + term
                 .ENDIF                         ;

                 add     dx, 2                  ; powers, factorials + 2
                 dec     cx                     ; continue
              .ENDW

              popa

              ret
ftcos         endp

cseg          ends
              end
