.286
;================================================
; Divides REAL10's dst, src
;
;------------------------------------------------
cseg          segment word public 'code'
              assume  cs:cseg,ss:cseg
              assume  ds:cseg,es:cseg

              include math.inc

ftdiv         proc    near uses ds es, dst:NPR10, src:NPR10
              local   t:REAL10, dcopy[4]:WORD, result[4]:WORD

              pusha
              mov     si, src
              mov     di, dst

              invoke  ftzero, si                ; if src = 0.0
              .IF ax == TRUE                    ;
                 jmp     exit                   ; dst unchanged
              .ENDIF                            ;

              invoke  ftzero, di                ; if dst = 0.0
              .IF ax == TRUE                    ;
                 jmp     exit                   ;
              .ENDIF                            ;
;------------------------------------------------
; get resultant exponent and sign
;------------------------------------------------
              mov     ax, word ptr [di]+8       ;
              mov     bl, ah                    ;
              and     bl, 80h                   ; BL = dst sign
              and     ax, 7fffh                 ;
              sub     ax, 3fffh                 ;

              mov     dx, word ptr [si]+8       ;
              mov     bh, dh                    ;
              and     bh, 80h                   ; BH = src sign
              and     dx, 7fffh                 ;
              sub     dx, 3fffh                 ;

              sub     ax, dx                    ; subtract binary exponents
              add     ax, 3fffh                 ; add bias

              .IF ((bx == 8000h) || (bx == 80h)); if -dst, +src OR +dst, -src
                 or      ax, 8000h              ; result is -ve
              .ENDIF                            ;

              mov     word ptr [di]+8, ax       ;
;------------------------------------------------
;
;------------------------------------------------
              invoke  movx, addr t, si, 5       ; don't violate src
              lea     si, t                     ; ss::si addresses t

              invoke  clrx, addr result, 4      ; clear result

              invoke  movx, addr dcopy, di, 4   ; save copy of dst64
;------------------------------------------------
; shift and subtract division
;------------------------------------------------
              mov     cx, 64                    ; for 64 bits

              .WHILE (cx)
                 invoke  cmpxz, di, 4           ; if dst64 == 0
                 .BREAK .IF (ax == TRUE)        ; exit loop

                 invoke  cmpx, di, si, 4        ;
                 .IF ax != -1                   ; if dst64 >= src64
                    invoke  subx, di, si, 4     ; dst64 -= src64
                    or      word ptr result[0], 1 ; insert 1 in result
                 .ENDIF                         ;

                 .IF cx > 1
                    invoke  lshx, addr result, 4 ; shl result
                    invoke  rshx, si, 4         ; shr divisor
                 .ENDIF
                 dec     cx                     ; continue
              .ENDW
;------------------------------------------------
; normalise result
;------------------------------------------------
              .WHILE (1)                        ;
                 mov     ax, word ptr result[6] ;
                 .BREAK .IF (ax & 8000h)        ;
                 invoke  lshx, addr result, 4   ;
              .ENDW                             ;

              invoke  movx, di, addr result, 4  ; res64 --> dst64

              invoke  cmpx, di, addr dcopy, 4   ;
              .IF ax == 1                       ; if dst64 > original
                 dec     word ptr [di]+8        ; exp--
              .ENDIF                            ;
exit:
              popa
              ret
ftdiv         endp

cseg          ends
              end
