.286
;================================================
; invoke ftexp, real
;
; Returns e**(real)
;------------------------------------------------
;              x**1     x**2     x**3
; exp x = 1 +  ----  +  ----  +  ----  +  .......
;               1!       2!       3!
;
; 8 terms excluding unity term
;------------------------------------------------
cseg          segment word public 'code'
              assume  cs:cseg,ss:cseg
              assume  ds:cseg,es:cseg

              include math.inc

ftexp         proc    near uses cx dx si di, real:NPR10
              local   p:REAL10, f:REAL10, t:REAL10

              mov     si, real                  ;
              lea     di, t                     ;

              invoke  load1, di                 ; t = 1.0
              invoke  ftadd, di, si             ; t = 1.0 + real (1st term)
              mov     cx, 8                     ; number of terms
              mov     dx, 2                     ; starting power, factorial

              .WHILE (cx)                       ;
                 invoke  movx, addr p, si, 5    ; p = real
                 invoke  ftpower, addr p, dx    ; p = real**dx
                 invoke  ftfact, addr f, dx     ; f = factorial dx
                 invoke  ftdiv, addr p, addr f  ; p = real**dx / factorial dx

                 invoke  ftadd, di, addr p      ; t += term
                 inc     dx                     ; powers, factorials + 1
                 dec     cx                     ; continue
              .ENDW

              invoke  movx, si, di, 5           ; real = t

              ret
ftexp         endp

cseg          ends
              end
