.286
;================================================
; invoke ftpower, real, power
;
; Returns real**power
;------------------------------------------------
cseg          segment word public 'code'
              assume  cs:cseg,ss:cseg
              assume  ds:cseg,es:cseg

              include math.inc

ftpower       proc    near uses cx si di ds, real:NPR10, power:WORD
              local   t:REAL10

              mov     cx, power
              .IF     (cx == 0)                 ;
                 invoke  load1, real            ; real**0 = 1.0
              .ELSEIF (cx == 1)
                 jmp     exit                   ; real**1 = real
              .ELSE
                 mov     si, real               ;
                 lea     di, t                  ;
                 invoke  movx, di, si, 5        ; t = real

                 dec     cx
                 .WHILE (cx)
                    invoke ftmul, si, di        ; real *= t
                    dec    cx
                 .ENDW
;------------------------------------------------
; if even power and -real, result is +ve
;------------------------------------------------
                 .IF ((word ptr [di]+8 & 8000h) && (!(power & 1)))
                    and     word ptr [si]+8, 7fffh
                 .ENDIF
              .ENDIF
exit:
              ret
ftpower       endp

cseg          ends
              end


