.286
;================================================
; invoke ftsin, real, radians
;
; Returns real = sin(radians)
;------------------------------------------------
;              x**3     x**5     x**7
; sin x = x -  ----  +  ----  -  ----  +  .......
;               3!       5!       7!
;
; 8 terms give 18 significant decimal places for
; an angle of 45 degrees.
;------------------------------------------------
cseg          segment word public 'code'
              assume  cs:cseg,ss:cseg
              assume  ds:cseg,es:cseg

              include math.inc

ftsin         proc    near  real:NPR10, radians:NPR10
              local   p:REAL10, f:REAL10

              pusha                             ;
              mov     si, real                  ;
              mov     di, radians               ;

              invoke  movx, si, di, 5           ; real = radians
              xor     bx, bx                    ; BX = 0
              mov     cx, 8                     ; number of terms
              mov     dx, 3                     ; starting power, factorial

              .WHILE (cx)                       ;
                 invoke movx, addr p, di, 5     ; p = radians
                 invoke ftpower, addr p, dx     ; p = p**dx
                 invoke ftfact, addr f, dx      ; f = factorial dx
                 invoke ftdiv, addr p, addr f   ; p = p**dx / factorial dx

                 xor    bx, 1                   ;
                 .IF (bx == 1)                  ;
                    invoke ftsub, si, addr p    ; - term
                 .ELSE                          ;
                    invoke ftadd, si, addr p    ; + term
                 .ENDIF                         ;

                 add     dx, 2                  ; powers, factorials + 2
                 dec     cx                     ; continue
              .ENDW

              popa

              ret
ftsin         endp

cseg          ends
              end
