;----------------------------
; MATH.INC
;----------------------------
TRUE          equ     1
FALSE         equ     0

MAXEXPONENT   equ   64
MINEXPONENT   equ  -64

szREAL10      equ   size REAL10  ; temporary real
szREAL8       equ   size REAL8   ; double precision (double)
szREAL4       equ   size REAL4   ; single precision (float)

NPB           typedef near ptr byte
NPR10         typedef near ptr REAL10
NPR8          typedef near ptr REAL8
NPR4          typedef near ptr REAL4

;---- MOVX.ASM ----
movx          proto near dst:NPB, src:NPB, wide:WORD
clrx          proto near dst:NPB, wide:WORD
addx          proto near dst:NPB, src:NPB, wide:WORD
subx          proto near dst:NPB, src:NPB, wide:WORD
lshx          proto near dst:NPB, wide:WORD
rshx          proto near dst:NPB, wide:WORD
cmpx          proto near dst:NPB, src:NPB, wide:WORD
cmpxz         proto near dst:NPB, wide:WORD

;---- MISC.ASM ----
ftzero        proto near dst:NPR10
ftequal       proto near x:NPR10, y:NPR10
ftrange       proto near dst:NPR10
ftnormal      proto near dst:NPR10
ftsign        proto near dst:NPR10
ftcomp        proto near x:NPR10, y:NPR10
ftswap        proto near dst:NPR10, src:NPR10

;---- FTLOAD.ASM --
load0         proto near dst:NPR10
load1         proto near dst:NPR10
load10        proto near dst:NPR10
load10_19     proto near dst:NPR10
loadpi        proto near dst:NPR10

;---- FLOAT.ASM ---
ft2s          proto near single:NPR4, temp:NPR10
ft2d          proto near double:NPR8, temp:NPR10
s2ft          proto near temp:NPR10, single:NPR4
d2ft          proto near temp:NPR10, double:NPR8

;---- individual files ----

ftadd         proto near dst:NPR10, src:NPR10
ftsub         proto near dst:NPR10, src:NPR10
ftmul         proto near dst:NPR10, src:NPR10
ftdiv         proto near dst:NPR10, src:NPR10

itoft         proto near real:NPR10, integer:SWORD
ftaddi        proto near real:NPR10, integer:SWORD
ftsubi        proto near real:NPR10, integer:SWORD
ftmuli        proto near real:NPR10, integer:SWORD
ftdivi        proto near real:NPR10, integer:SWORD

ftmod         proto near dst:NPR10, src:NPR10
ftrecip       proto near dst:NPR10
ftpower       proto near real:NPR10, power:WORD
ftfact        proto near real:NPR10, factorial:WORD
ftsqrt        proto near real:NPR10
ftsin         proto near real:NPR10, radians:NPR10
ftcos         proto near real:NPR10, radians:NPR10
ftexp         proto near real:NPR10

st2ft         proto near dst:NPR10, string:NPB
st2int        proto near string:NPB
ft2st         proto near src:NPR10, string:NPB




