.286
;=======================================
; Miscellaneous
;
;---------------------------------------
cseg          segment word public 'code'
              assume  cs:cseg,ss:cseg
              assume  ds:cseg,es:cseg

              include math.inc

;================================================
; Test REAL10 for 0.0
;
; Returns AX = TRUE if 0.0, else AX = FALSE
;------------------------------------------------
ftzero        proc    near uses si, dst:NPR10

              mov     si, dst
              mov     ax, word ptr [si]+8
              and     ax, 7fffh
              or      ax, word ptr [si]+6
              or      ax, word ptr [si]+4
              or      ax, word ptr [si]+2
              or      ax, word ptr [si]+0
              .IF ax == 0
                 mov     ax, TRUE
              .ELSE
                 mov     ax, FALSE
              .ENDIF
              ret
ftzero        endp

;================================================
; Check if REAL10's are of equal magnitude except
; for sign.
;
; If equal, returns AX = TRUE, else AX = FALSE
;------------------------------------------------
ftequal       proc    near uses si di, x:NPR10, y:NPR10

              mov     si, x
              mov     di, y

              invoke  cmpx, si, di, 4
              .IF ax != 0
                 mov     ax, FALSE
                 jmp     exit
              .ENDIF

              mov     ax, word ptr [si]+8
              and     ax, 7fffh
              mov     si, word ptr [di]+8
              and     si, 7fffh

              .IF ax == si
                 mov     ax, TRUE
              .ELSE
                 mov     ax, FALSE
              .ENDIF
exit:
              ret
ftequal       endp

;================================================
; Check if a REAL10 is within exponent range of
; +64 < exp < -64
;
; Returns: AX = TRUE, if within range
;    else: AX = FALSE
;------------------------------------------------
ftrange       proc    near uses bx si, dst:NPR10

              mov     si, dst                   ;
              mov     ax, TRUE                  ; assume within range

              mov     bx, word ptr [si]+8       ;
              and     bx, 7fffh                 ; remove sign
              sub     bx, 3fffh                 ; remove bias

              .IF ((SWORD PTR bx >= MAXEXPONENT) || \
                   (SWORD PTR bx <= MINEXPONENT))
                 mov     ax, FALSE
              .ENDIF

              ret
ftrange       endp

;================================================
; Normalise a REAL10
;
;------------------------------------------------
ftnormal      proc    near uses ax si, dst:NPR10

              mov     si, dst
              mov     ax, word ptr [si]+0
              or      ax, word ptr [si]+2
              or      ax, word ptr [si]+4
              or      ax, word ptr [si]+6

              .IF (ax)
                 .WHILE ( !(word ptr [si]+6 & 8000h) )
                    dec     word ptr [si]+8
                    invoke  lshx, si, 4
                 .ENDW
              .ELSE
                 mov     word ptr [si]+8, 0
              .ENDIF

              ret
ftnormal      endp

;================================================
; Change sign of a REAL10
;
;------------------------------------------------
ftsign        proc    near uses si, dst:NPR10

              mov     si, dst
              xor     word ptr [si]+8, 8000h

              ret
ftsign        endp

;================================================
; compare REAL10's x, y
;
; Returns: AX = 1,  if x > y
;              -1,  if x < y
;               0,  if x == y
;------------------------------------------------
ftcomp        proc    near uses bx si di, x:NPR10, y:NPR10

              mov     si, x
              mov     di, y

              invoke  ftequal, si, di
              .IF ax == TRUE
                 xor     ax, ax
                 jmp     exit
              .ENDIF

              invoke  ftzero, si
              mov     bx, ax
              invoke  ftzero, di

              .IF ((ax == TRUE) && (bx == FALSE)) ; if y == 0, x != 0
                 mov     ax, 1
                 jmp     exit
              .ELSEIF ((ax == FALSE) && (bx == TRUE)) ; if y != 0, x == 0
                 mov     ax, -1
                 jmp     exit
              .ENDIF

              mov     ax, word ptr [si]+8
              and     ax, 7fffh
              mov     bx, word ptr [di]+8
              and     bx, 7fffh

              .IF (SWORD ptr ax > SWORD ptr bx)
                 mov     ax, 1
                 jmp     exit
              .ELSEIF (SWORD ptr bx > SWORD ptr ax)
                 mov     ax, -1
                 jmp     exit
              .ENDIF

              invoke  cmpx, si, di, 4
exit:
              ret
ftcomp        endp

;================================================
; swap two REAL10's
;
;------------------------------------------------
ftswap        proc    near  uses si di, dst:NPR10, src:NPR10
              local   t:REAL10

              mov     di, dst
              mov     si, src
              invoke  movx, addr t, si, 5      ;   t <-- src
              invoke  movx, si, di, 5          ; src <-- dst
              invoke  movx, di, addr t, 5      ; dst <-- t

              ret
ftswap        endp

cseg          ends
              end
