.286
;======================================
; floating point support
;
;--------------------------------------
cseg          segment word public 'code'
              assume  cs:cseg,ss:cseg
              assume  ds:cseg,es:cseg

              include math.inc

;======================================
; invoke movx, dst, src, wide
;
; Move wide words from src to dst.
;--------------------------------------
movx          proc    near uses cx si di, dst:NPB, src:NPB, wide:WORD

              mov     si, src
              mov     di, dst
              mov     cx, wide
              cld
              rep     movsw

              ret
movx          endp

;======================================
; invoke clrx, dst, wide
;
; Clear wide words of dst.
;--------------------------------------
clrx          proc    near uses ax cx di, dst:NPB, wide:WORD

              mov     di, dst
              mov     cx, wide
              xor     ax, ax
              cld
              rep     stosw

              ret
clrx          endp

;======================================
; invoke addx, dst, src, wide
;
; dst += src, returns carry in AX.
;--------------------------------------
addx          proc    near uses cx si di, dst:NPB, src:NPB, wide:WORD

              mov     si, src
              mov     di, dst
              mov     cx, wide
              cld

              lodsw
              add     word ptr [di], ax
              inc     di
              inc     di
              dec     cx
@@:
              lodsw
              adc     word ptr [di], ax
              inc     di
              inc     di
              loop    @B

              rcl     ax, 1
              and     ax, 1

              ret
addx          endp

;======================================
; invoke subx, dst, src, wide
;
; dst -= src, returns borrow in AX.
;--------------------------------------
subx          proc    near uses cx si di, dst:NPB, src:NPB, wide:WORD

              mov     si, src
              mov     di, dst
              mov     cx, wide
              cld

              lodsw
              sub     word ptr [di], ax
              inc     di
              inc     di
              dec     cx
@@:
              lodsw
              sbb     word ptr [di], ax
              inc     di
              inc     di
              loop    @B

              rcl     ax, 1
              and     ax, 1

              ret
subx          endp

;======================================
; invoke lshx, dst, wide
;
; left shift dst, returns carry in AX.
;--------------------------------------
lshx          proc    near uses cx si, dst:NPB, wide:WORD

              mov     si, dst
              mov     cx, wide
              cld
              clc
@@:
              lodsw
              rcl     ax, 1
              mov     word ptr [si]-2, ax
              loop    @B

              rcl     ax, 1
              and     ax, 1

              ret
lshx          endp

;======================================
; invoke rshx, dst, wide
;
; right shift dst, returns carry in AX.
;--------------------------------------
rshx          proc    near uses cx si, dst:NPB, wide:WORD

              mov     si, dst
              mov     cx, wide
              mov     ax, cx
              shl     ax, 1
              sub     ax, 2
              add     si, ax
              std
              clc
@@:
              lodsw
              rcr     ax, 1
              mov     word ptr [si]+2, ax
              loop    @B

              rcl     ax, 1
              and     ax, 1
              cld

              ret
rshx          endp

;======================================
; invoke cmpx, dst, src, wide
;
; compares dst, src ( hi to lo)
;
; Returns: AX = 1,  if dst > src
;              -1,  if dst < src
;               0,  if dst == src
;--------------------------------------
cmpx          proc    near uses cx si di, dst:NPB, src:NPB, wide:WORD

              mov     si, dst                   ;
              mov     di, src                   ;
              mov     cx, wide                  ;

              mov     ax, cx                    ;
              shl     ax, 1                     ;
              sub     ax, 2                     ;
              add     si, ax                    ;
              add     di, ax                    ;

              xor     ax, ax                    ; assume equal
              std                               ;
              repe    cmpsw                     ; repeat while equal
              cld                               ;
              je      exit                      ; equal !
              mov     ax, 1                     ; assume dst > src
              ja      exit                      ; yes
              neg     ax                        ; no, dst < src
exit:
              ret
cmpx          endp

;======================================
; invoke cmpxz, dst, wide
;
; compares dst, to zero
;
; Returns: AX = TRUE,  if dst == zero
;    else  AX = FALSE
;--------------------------------------
cmpxz         proc    near uses cx bx si, dst:NPB, wide:WORD

              mov     si, dst
              mov     cx, wide
              xor     bx, bx
              cld
@@:
              lodsw
              or      bx, ax
              loop    @B

              .IF (bx == 0)
                 mov     ax, TRUE
              .ELSE
                 mov     ax, FALSE
              .ENDIF

              ret
cmpxz         endp

cseg          ends
              end
